/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.sitemesh.webapp;

import com.opensymphony.module.sitemesh.PageParser;
import com.opensymphony.module.sitemesh.PageParserSelector;
import com.opensymphony.module.sitemesh.filter.BufferedContent;
import com.opensymphony.module.sitemesh.filter.PageResponseWrapper;
import com.opensymphony.sitemesh.Content;
import com.opensymphony.sitemesh.ContentProcessor;
import com.opensymphony.sitemesh.webapp.SiteMeshWebAppContext;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class ContentBufferingResponse
extends HttpServletResponseWrapper {
    private final PageResponseWrapper pageResponseWrapper;
    private final ContentProcessor contentProcessor;
    private final SiteMeshWebAppContext webAppContext;

    public ContentBufferingResponse(HttpServletResponse response, final ContentProcessor contentProcessor, final SiteMeshWebAppContext webAppContext) {
        super((HttpServletResponse)new PageResponseWrapper(response, new PageParserSelector(){

            public boolean shouldParsePage(String contentType) {
                return contentProcessor.handles(contentType);
            }

            public PageParser getPageParser(String contentType) {
                return null;
            }
        }){

            public void setContentType(String contentType) {
                webAppContext.setContentType(contentType);
                super.setContentType(contentType);
            }
        });
        this.contentProcessor = contentProcessor;
        this.webAppContext = webAppContext;
        this.pageResponseWrapper = (PageResponseWrapper)this.getResponse();
    }

    public boolean isUsingStream() {
        return this.pageResponseWrapper.isUsingStream();
    }

    public Content getContent() throws IOException {
        BufferedContent content = this.pageResponseWrapper.getContents();
        if (content != null) {
            return this.contentProcessor.build(content, this.webAppContext);
        }
        return null;
    }
}

