package com.opensymphony.sitemesh.compatability;

import com.opensymphony.module.sitemesh.Factory;
import com.opensymphony.module.sitemesh.HTMLPage;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.PageParser;
import com.opensymphony.module.sitemesh.filter.BufferedContent;
import com.opensymphony.module.sitemesh.filter.HttpContentType;
import com.opensymphony.sitemesh.Content;
import com.opensymphony.sitemesh.SiteMeshContext;
import com.opensymphony.sitemesh.webapp.SiteMeshWebAppContext;
import com.opensymphony.sitemesh.ContentProcessor;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

/**
 * Adapts a SiteMesh 2 {@link PageParser} to a SiteMesh 3 {@link ContentProcessor}.
 *
 * @author Joe Walnes
 * @since SiteMesh 3
 */
public class PageParser2ContentProcessor implements ContentProcessor {

    private final Factory factory;

    public PageParser2ContentProcessor(Factory factory) {
        this.factory = factory;
    }

    public boolean handles(SiteMeshContext context) {
        SiteMeshWebAppContext webAppContext = (SiteMeshWebAppContext) context;
        return !factory.isPathExcluded(extractRequestPath(webAppContext.getRequest()));
    }

    private String extractRequestPath(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        String pathInfo = request.getPathInfo();
        String query = request.getQueryString();
        return (servletPath == null ? "" : servletPath)
                + (pathInfo == null ? "" : pathInfo)
                + (query == null ? "" : ("?" + query));
    }

    public boolean handles(String contentType) {
        return factory.shouldParsePage(contentType);
    }

    public Content build(BufferedContent content, SiteMeshContext context) throws IOException {
        HttpContentType httpContentType = new HttpContentType(context.getContentType());
        PageParser pageParser = factory.getPageParser(httpContentType.getType());
        Page page = pageParser.parse(content.getBuffer(), content.getLength());
        return new HTMLPage2Content((HTMLPage) page);
    }
}
