/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.sitemesh.taglib.decorator;

import com.opensymphony.module.sitemesh.HTMLPage;
import com.opensymphony.module.sitemesh.taglib.AbstractTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;

public class PropertyTag
extends AbstractTag {
    private String propertyName;
    private String defaultValue;
    private boolean writeEntireProperty = false;

    public void setProperty(String propertyName) {
        this.propertyName = propertyName;
    }

    public void setDefault(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public final void setWriteEntireProperty(String writeEntireProperty) {
        if (writeEntireProperty == null || writeEntireProperty.trim().length() == 0) {
            return;
        }
        switch (writeEntireProperty.charAt(0)) {
            case '1': 
            case 'T': 
            case 'Y': 
            case 't': 
            case 'y': {
                this.writeEntireProperty = true;
                break;
            }
            default: {
                this.writeEntireProperty = false;
            }
        }
    }

    public final int doEndTag() throws JspException {
        try {
            HTMLPage htmlPage = (HTMLPage)this.getPage();
            String propertyValue = htmlPage.getProperty(this.propertyName);
            if (propertyValue == null || propertyValue.trim().length() == 0) {
                propertyValue = this.defaultValue;
            }
            if (propertyValue != null) {
                JspWriter out = this.pageContext.getOut();
                if (this.writeEntireProperty) {
                    out.print(" ");
                    out.print(this.propertyName.substring(this.propertyName.lastIndexOf(46) + 1));
                    out.print("=\"");
                    out.print(propertyValue);
                    out.print("\"");
                } else {
                    out.print(propertyValue);
                }
            }
        }
        catch (Exception e) {
            PropertyTag.trace(e);
        }
        return 6;
    }

    public void release() {
        this.defaultValue = null;
        this.propertyName = null;
        super.release();
    }
}

