/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.sitemesh.factory;

import com.opensymphony.module.sitemesh.Config;
import com.opensymphony.module.sitemesh.DecoratorMapper;
import com.opensymphony.module.sitemesh.Factory;
import com.opensymphony.module.sitemesh.PageParser;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public abstract class BaseFactory
extends Factory {
    protected Config config = null;
    protected DecoratorMapper decoratorMapper = null;
    protected Map pageParsers = null;
    protected PageParser defaultPageParser = null;

    protected BaseFactory(Config config) {
        this.config = config;
        this.clearDecoratorMappers();
        this.clearParserMappings();
    }

    public DecoratorMapper getDecoratorMapper() {
        return this.decoratorMapper;
    }

    public PageParser getPageParser(String contentType) {
        if (this.pageParsers.containsKey(contentType)) {
            return (PageParser)this.pageParsers.get(contentType);
        }
        return this.defaultPageParser;
    }

    public boolean shouldParsePage(String contentType) {
        return this.pageParsers.containsKey(contentType);
    }

    protected void clearDecoratorMappers() {
        this.decoratorMapper = null;
    }

    protected void pushDecoratorMapper(String className, Properties properties) {
        try {
            Class<?> decoratorMapperClass = null;
            try {
                decoratorMapperClass = Class.forName(className);
            }
            catch (NoClassDefFoundError e) {
                decoratorMapperClass = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            }
            DecoratorMapper newMapper = (DecoratorMapper)decoratorMapperClass.newInstance();
            newMapper.init(this.config, properties, this.decoratorMapper);
            this.decoratorMapper = newMapper;
        }
        catch (ClassNotFoundException e) {
            BaseFactory.report("Could not load DecoratorMapper class : " + className, e);
        }
        catch (Exception e) {
            BaseFactory.report("Could not initialize DecoratorMapper : " + className, e);
        }
    }

    protected void clearParserMappings() {
        this.defaultPageParser = null;
        this.pageParsers = new HashMap();
    }

    protected void mapParser(String contentType, String className) {
        try {
            PageParser pp = (PageParser)Class.forName(className).newInstance();
            if (contentType == null) {
                this.defaultPageParser = pp;
            } else {
                this.pageParsers.put(contentType, pp);
            }
        }
        catch (ClassNotFoundException e) {
            BaseFactory.report("Could not load PageParser class : " + className, e);
        }
        catch (Exception e) {
            BaseFactory.report("Could not instantiate PageParser : " + className, e);
        }
    }
}

