/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.spi.memory;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import com.opensymphony.workflow.spi.SimpleStep;
import com.opensymphony.workflow.spi.SimpleWorkflowEntry;
import com.opensymphony.workflow.spi.Step;
import com.opensymphony.workflow.spi.WorkflowEntry;
import com.opensymphony.workflow.spi.memory.MemoryWorkflowStore;
import com.opensymphony.workflow.spi.memory.SerializableCache;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SerializableWorkflowStore
extends MemoryWorkflowStore {
    protected static final Log log = LogFactory.getLog((Class)(class$com$opensymphony$workflow$spi$memory$SerializableWorkflowStore == null ? (class$com$opensymphony$workflow$spi$memory$SerializableWorkflowStore = SerializableWorkflowStore.class$("com.opensymphony.workflow.spi.memory.SerializableWorkflowStore")) : class$com$opensymphony$workflow$spi$memory$SerializableWorkflowStore));
    static String storeFile;
    static /* synthetic */ Class class$com$opensymphony$workflow$spi$memory$SerializableWorkflowStore;

    public PropertySet getPropertySet(long entryId) {
        PropertySet ps = (PropertySet)SerializableCache.getInstance().propertySetCache.get(new Long(entryId));
        if (ps == null) {
            ps = PropertySetManager.getInstance((String)"serializable", null);
            SerializableCache.getInstance().propertySetCache.put(new Long(entryId), ps);
        }
        return ps;
    }

    public static void setStoreFile(String storeFile) {
        SerializableWorkflowStore.storeFile = storeFile;
    }

    public static String getStoreFile() {
        return storeFile;
    }

    public Step createCurrentStep(long entryId, int stepId, String owner, Date startDate, Date dueDate, String status, long[] previousIds) {
        long id = SerializableCache.getInstance().globalStepId++;
        SimpleStep step = new SimpleStep(id, entryId, stepId, 0, owner, startDate, dueDate, null, status, previousIds, null);
        ArrayList<SimpleStep> currentSteps = (ArrayList<SimpleStep>)SerializableCache.getInstance().currentStepsCache.get(new Long(entryId));
        if (currentSteps == null) {
            currentSteps = new ArrayList<SimpleStep>();
            SerializableCache.getInstance().currentStepsCache.put(new Long(entryId), currentSteps);
        }
        currentSteps.add(step);
        SerializableCache.store();
        return step;
    }

    public WorkflowEntry createEntry(String workflowName) {
        long id = SerializableCache.getInstance().globalEntryId++;
        SimpleWorkflowEntry entry = new SimpleWorkflowEntry(id, workflowName, 0);
        SerializableCache.getInstance().entryCache.put(new Long(id), entry);
        SerializableCache.store();
        return entry;
    }

    public List findCurrentSteps(long entryId) {
        ArrayList currentSteps = (ArrayList)SerializableCache.getInstance().currentStepsCache.get(new Long(entryId));
        if (currentSteps == null) {
            currentSteps = new ArrayList();
            SerializableCache.getInstance().currentStepsCache.put(new Long(entryId), currentSteps);
        }
        return currentSteps;
    }

    public WorkflowEntry findEntry(long entryId) {
        return (WorkflowEntry)SerializableCache.getInstance().entryCache.get(new Long(entryId));
    }

    public List findHistorySteps(long entryId) {
        ArrayList historySteps = (ArrayList)SerializableCache.getInstance().historyStepsCache.get(new Long(entryId));
        if (historySteps == null) {
            historySteps = new ArrayList();
            SerializableCache.getInstance().historyStepsCache.put(new Long(entryId), historySteps);
        }
        return historySteps;
    }

    public void init(Map props) {
        storeFile = (String)props.get("storeFile");
        if (!new File(storeFile).isFile()) {
            log.fatal((Object)"storePath property should indicate a normal file");
        }
        if (!new File(storeFile).getParentFile().exists()) {
            log.fatal((Object)("directory " + new File(storeFile).getParent() + " not found"));
        }
    }

    public Step markFinished(Step step, int actionId, Date finishDate, String status, String caller) {
        List currentSteps = (List)SerializableCache.getInstance().currentStepsCache.get(new Long(step.getEntryId()));
        Iterator iterator = currentSteps.iterator();
        while (iterator.hasNext()) {
            SimpleStep theStep = (SimpleStep)iterator.next();
            if (theStep.getId() != step.getId()) continue;
            theStep.setStatus(status);
            theStep.setActionId(actionId);
            theStep.setFinishDate(finishDate);
            theStep.setCaller(caller);
            return theStep;
        }
        SerializableCache.store();
        return null;
    }

    public void moveToHistory(Step step) {
        List currentSteps = (List)SerializableCache.getInstance().currentStepsCache.get(new Long(step.getEntryId()));
        ArrayList<SimpleStep> historySteps = (ArrayList<SimpleStep>)SerializableCache.getInstance().historyStepsCache.get(new Long(step.getEntryId()));
        if (historySteps == null) {
            historySteps = new ArrayList<SimpleStep>();
            SerializableCache.getInstance().historyStepsCache.put(new Long(step.getEntryId()), historySteps);
        }
        SimpleStep simpleStep = (SimpleStep)step;
        Iterator iterator = currentSteps.iterator();
        while (iterator.hasNext()) {
            Step currentStep = (Step)iterator.next();
            if (simpleStep.getId() != currentStep.getId()) continue;
            iterator.remove();
            historySteps.add(simpleStep);
            break;
        }
        SerializableCache.store();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

