/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.spi.ejb;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import com.opensymphony.workflow.StoreException;
import com.opensymphony.workflow.query.WorkflowExpressionQuery;
import com.opensymphony.workflow.query.WorkflowQuery;
import com.opensymphony.workflow.spi.Step;
import com.opensymphony.workflow.spi.WorkflowEntry;
import com.opensymphony.workflow.spi.WorkflowStore;
import com.opensymphony.workflow.spi.ejb.WorkflowStoreHome;
import com.opensymphony.workflow.spi.ejb.WorkflowStoreRemote;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EJBWorkflowStore
implements WorkflowStore {
    private static final Log log = LogFactory.getLog((Class)(class$com$opensymphony$workflow$spi$ejb$EJBWorkflowStore == null ? (class$com$opensymphony$workflow$spi$ejb$EJBWorkflowStore = EJBWorkflowStore.class$("com.opensymphony.workflow.spi.ejb.EJBWorkflowStore")) : class$com$opensymphony$workflow$spi$ejb$EJBWorkflowStore));
    private WorkflowStoreRemote session;
    static /* synthetic */ Class class$com$opensymphony$workflow$spi$ejb$EJBWorkflowStore;
    static /* synthetic */ Class class$com$opensymphony$workflow$spi$ejb$WorkflowStoreHome;

    public void setEntryState(long entryId, int state) throws StoreException {
        try {
            this.session.setEntryState(entryId, state);
        }
        catch (RemoteException ex) {
            log.error((Object)("Error changing state of workflow instance #" + entryId + " to " + state), (Throwable)ex);
        }
    }

    public PropertySet getPropertySet(long entryId) throws StoreException {
        try {
            HashMap<String, Object> args = new HashMap<String, Object>(2);
            args.put("entityId", new Long(entryId));
            args.put("entityName", "WorkflowEntry");
            return PropertySetManager.getInstance((String)"ejb", args);
        }
        catch (Exception e) {
            throw new StoreException("Could not retrieve PropertySet for workflow instance #" + entryId, e);
        }
    }

    public Step createCurrentStep(long entryId, int stepId, String owner, Date startDate, Date dueDate, String status, long[] previousIds) throws StoreException {
        try {
            return this.session.createCurrentStep(entryId, stepId, owner, startDate, dueDate, status, previousIds);
        }
        catch (RemoteException ex) {
            log.fatal((Object)"System error", (Throwable)ex);
            return null;
        }
    }

    public WorkflowEntry createEntry(String workflowName) throws StoreException {
        try {
            return this.session.createEntry(workflowName);
        }
        catch (RemoteException ex) {
            log.fatal((Object)"System error", (Throwable)ex);
            return null;
        }
    }

    public List findCurrentSteps(long entryId) throws StoreException {
        try {
            return this.session.findCurrentSteps(entryId);
        }
        catch (RemoteException ex) {
            log.fatal((Object)"System error", (Throwable)ex);
            return null;
        }
    }

    public WorkflowEntry findEntry(long entryId) throws StoreException {
        try {
            return this.session.findEntry(entryId);
        }
        catch (RemoteException ex) {
            log.fatal((Object)"System error", (Throwable)ex);
            return null;
        }
    }

    public List findHistorySteps(long entryId) throws StoreException {
        try {
            return this.session.findHistorySteps(entryId);
        }
        catch (RemoteException ex) {
            log.fatal((Object)"System error", (Throwable)ex);
            return null;
        }
    }

    public void init(Map props) {
        String workflowSessionLocation = (String)props.get("workflow.store");
        if (workflowSessionLocation == null) {
            workflowSessionLocation = "WorkflowStore";
        }
        try {
            InitialContext context = new InitialContext();
            this.session = ((WorkflowStoreHome)PortableRemoteObject.narrow((Object)context.lookup(workflowSessionLocation), (Class)(class$com$opensymphony$workflow$spi$ejb$WorkflowStoreHome == null ? (class$com$opensymphony$workflow$spi$ejb$WorkflowStoreHome = EJBWorkflowStore.class$("com.opensymphony.workflow.spi.ejb.WorkflowStoreHome")) : class$com$opensymphony$workflow$spi$ejb$WorkflowStoreHome))).create();
        }
        catch (Exception ex) {
            log.error((Object)"Error looking up homes", (Throwable)ex);
            throw new IllegalArgumentException(ex.toString());
        }
    }

    public Step markFinished(Step step, int actionId, Date finishDate, String status, String caller) throws StoreException {
        try {
            return this.session.markFinished(step, actionId, finishDate, status, caller);
        }
        catch (RemoteException ex) {
            log.fatal((Object)"System error", (Throwable)ex);
            return null;
        }
    }

    public void moveToHistory(Step step) throws StoreException {
        try {
            this.session.moveToHistory(step);
        }
        catch (RemoteException ex) {
            log.fatal((Object)"System error", (Throwable)ex);
        }
    }

    public List query(WorkflowQuery query) {
        throw new UnsupportedOperationException("EJB store does not support queries");
    }

    public List query(WorkflowExpressionQuery query) throws StoreException {
        throw new UnsupportedOperationException("EJB store does not support queries");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

