/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.loader;

import com.opensymphony.workflow.FactoryException;
import com.opensymphony.workflow.InvalidWorkflowDescriptorException;
import com.opensymphony.workflow.loader.AbstractWorkflowFactory;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import com.opensymphony.workflow.loader.WorkflowLoader;
import com.opensymphony.workflow.loader.XMLUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLWorkflowFactory
extends AbstractWorkflowFactory
implements Serializable {
    private static final long serialVersionUID = 452755218478437087L;
    protected Map workflows;
    protected boolean reload;

    public void setLayout(String workflowName, Object layout) {
    }

    public Object getLayout(String workflowName) {
        return null;
    }

    public boolean isModifiable(String name) {
        return true;
    }

    public String getName() {
        return "";
    }

    public WorkflowDescriptor getWorkflow(String name, boolean validate) throws FactoryException {
        WorkflowConfig c = (WorkflowConfig)this.workflows.get(name);
        if (c == null) {
            throw new FactoryException("Unknown workflow name \"" + name + '\"');
        }
        if (c.descriptor != null) {
            File file;
            if (this.reload && (file = new File(c.url.getFile())).exists() && file.lastModified() > c.lastModified) {
                c.lastModified = file.lastModified();
                this.loadWorkflow(c, validate);
            }
        } else {
            this.loadWorkflow(c, validate);
        }
        c.descriptor.setName(name);
        return c.descriptor;
    }

    public String[] getWorkflowNames() {
        int i = 0;
        String[] res = new String[this.workflows.keySet().size()];
        Iterator it = this.workflows.keySet().iterator();
        while (it.hasNext()) {
            res[i++] = (String)it.next();
        }
        return res;
    }

    public void createWorkflow(String name) {
    }

    public void initDone() throws FactoryException {
        this.reload = this.getProperties().getProperty("reload", "false").equals("true");
        String name = this.getProperties().getProperty("resource", "workflows.xml");
        InputStream is = this.getInputStream(name);
        if (is == null) {
            throw new FactoryException("Unable to find workflows file '" + name + "' in classpath");
        }
        try {
            DocumentBuilder db;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            try {
                db = dbf.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new FactoryException("Error creating document builder", e);
            }
            Document doc = db.parse(is);
            Element root = (Element)doc.getElementsByTagName("workflows").item(0);
            this.workflows = new HashMap();
            String basedir = this.getBaseDir(root);
            List list = XMLUtil.getChildElements(root, "workflow");
            for (int i = 0; i < list.size(); ++i) {
                Element e = (Element)list.get(i);
                WorkflowConfig config = new WorkflowConfig(basedir, e.getAttribute("type"), e.getAttribute("location"));
                this.workflows.put(e.getAttribute("name"), config);
            }
        }
        catch (Exception e) {
            throw new InvalidWorkflowDescriptorException("Error in workflow config", e);
        }
    }

    public boolean removeWorkflow(String name) throws FactoryException {
        throw new FactoryException("remove workflow not supported");
    }

    public void renameWorkflow(String oldName, String newName) {
    }

    public void save() {
    }

    public boolean saveWorkflow(String name, WorkflowDescriptor descriptor, boolean replace) throws FactoryException {
        boolean isOK;
        OutputStreamWriter out;
        WorkflowConfig c = (WorkflowConfig)this.workflows.get(name);
        if (c != null && !replace) {
            return false;
        }
        if (c == null) {
            throw new UnsupportedOperationException("Saving of new workflow is not currently supported");
        }
        try {
            out = new OutputStreamWriter((OutputStream)new FileOutputStream(c.url.getFile() + ".new"), "utf-8");
        }
        catch (FileNotFoundException ex) {
            throw new FactoryException("Could not create new file to save workflow " + c.url.getFile());
        }
        catch (UnsupportedEncodingException ex) {
            throw new FactoryException("utf-8 encoding not supported, contact your JVM vendor!");
        }
        this.writeXML(descriptor, out);
        File original = new File(c.url.getFile());
        File backup = new File(c.url.getFile() + ".bak");
        File updated = new File(c.url.getFile() + ".new");
        boolean bl = isOK = !original.exists() || original.renameTo(backup);
        if (!isOK) {
            throw new FactoryException("Unable to backup original workflow file " + original + " to " + backup + ", aborting save");
        }
        isOK = updated.renameTo(original);
        if (!isOK) {
            throw new FactoryException("Unable to rename new  workflow file " + updated + " to " + original + ", aborting save");
        }
        backup.delete();
        return true;
    }

    protected String getBaseDir(Element root) {
        String basedir = root.getAttribute("basedir");
        if (basedir.length() == 0) {
            return null;
        }
        if (new File(basedir).isAbsolute()) {
            return basedir;
        }
        return new File(System.getProperty("user.dir"), basedir).getAbsolutePath();
    }

    protected InputStream getInputStream(String name) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream is = null;
        if (name != null && name.indexOf(":/") > -1) {
            try {
                is = new URL(name).openStream();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (is == null) {
            try {
                is = classLoader.getResourceAsStream(name);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (is == null) {
            try {
                is = classLoader.getResourceAsStream('/' + name);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (is == null) {
            try {
                is = classLoader.getResourceAsStream("META-INF/" + name);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (is == null) {
            try {
                is = classLoader.getResourceAsStream("/META-INF/" + name);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return is;
    }

    protected void writeXML(WorkflowDescriptor descriptor, Writer out) {
        PrintWriter writer = new PrintWriter(new BufferedWriter(out));
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.println("<!DOCTYPE workflow PUBLIC \"-//OpenSymphony Group//DTD OSWorkflow 2.8//EN\" \"http://www.opensymphony.com/osworkflow/workflow_2_8.dtd\">");
        descriptor.writeXML(writer, 0);
        writer.flush();
        writer.close();
    }

    private void loadWorkflow(WorkflowConfig c, boolean validate) throws FactoryException {
        try {
            c.descriptor = WorkflowLoader.load(c.url, validate);
        }
        catch (Exception e) {
            throw new FactoryException("Error in workflow descriptor: " + c.url, e);
        }
    }

    static class WorkflowConfig
    implements Serializable {
        private static final long serialVersionUID = 4939957922893602958L;
        String location;
        String type;
        URL url;
        WorkflowDescriptor descriptor;
        long lastModified;

        public WorkflowConfig(String basedir, String type, String location) {
            if ("URL".equals(type)) {
                try {
                    this.url = new URL(location);
                    File file = new File(this.url.getFile());
                    if (file.exists()) {
                        this.lastModified = file.lastModified();
                    }
                }
                catch (Exception ex) {}
            } else if ("file".equals(type)) {
                try {
                    File file = new File(basedir, location);
                    this.url = file.toURL();
                    this.lastModified = file.lastModified();
                }
                catch (Exception ex) {}
            } else {
                this.url = Thread.currentThread().getContextClassLoader().getResource(location);
            }
            this.type = type;
            this.location = location;
        }
    }
}

