/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.loader;

import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class WorkflowSerializer {
    private VelocityEngine engine;

    public byte[] generateWorkflowXML(WorkflowDescriptor wf) throws Exception {
        this.initVelocity();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(baos);
        Template template = this.engine.getTemplate("workflowtemplate.vm");
        VelocityContext ctx = new VelocityContext();
        ctx.put("workflow", (Object)wf);
        template.merge((Context)ctx, (Writer)writer);
        writer.flush();
        baos.flush();
        return baos.toByteArray();
    }

    protected void initVelocity() throws Exception {
        if (this.engine == null) {
            this.engine = new VelocityEngine();
            this.engine.setProperty("resource.loader", (Object)"class");
            this.engine.setProperty("class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            this.engine.init();
        }
    }
}

