/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.loader;

import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.XMLUtil;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class RegisterDescriptor
extends AbstractDescriptor {
    protected Map args = new HashMap();
    protected String type;
    protected String variableName;

    RegisterDescriptor() {
    }

    RegisterDescriptor(Element register) {
        this.init(register);
    }

    public Map getArgs() {
        return this.args;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void writeXML(PrintWriter out, int indent) {
        XMLUtil.printIndent(out, indent++);
        out.println("<register " + (this.hasId() ? "id=\"" + this.getId() + "\" " : "") + "type=\"" + this.type + "\" variable-name=\"" + this.variableName + "\">");
        Iterator iter = this.args.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            XMLUtil.printIndent(out, indent);
            out.print("<arg name=\"");
            out.print(entry.getKey());
            out.print("\">");
            if ("beanshell".equals(this.type) || "bsf".equals(this.type)) {
                out.print("<![CDATA[");
                out.print(entry.getValue());
                out.print("]]>");
            } else {
                out.print(XMLUtil.encode(entry.getValue()));
            }
            out.println("</arg>");
        }
        XMLUtil.printIndent(out, --indent);
        out.println("</register>");
    }

    protected void init(Element register) {
        this.type = register.getAttribute("type");
        this.variableName = register.getAttribute("variable-name");
        try {
            this.setId(Integer.parseInt(register.getAttribute("id")));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        List args = XMLUtil.getChildElements(register, "arg");
        for (int l = 0; l < args.size(); ++l) {
            Element arg = (Element)args.get(l);
            this.args.put(arg.getAttribute("name"), XMLUtil.getText(arg));
        }
    }
}

