/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.loader;

import com.opensymphony.workflow.FactoryException;
import com.opensymphony.workflow.loader.AbstractWorkflowFactory;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class HTTPWorkflowFactory
extends AbstractWorkflowFactory {
    protected Map workflows;
    protected boolean reload;

    public void setLayout(String workflowName, Object layout) {
    }

    public Object getLayout(String workflowName) {
        return null;
    }

    public boolean isModifiable(String name) {
        return true;
    }

    public String getName() {
        return null;
    }

    public WorkflowDescriptor getWorkflow(String name, boolean validate) throws FactoryException {
        HTTPWorkflowConfig c = (HTTPWorkflowConfig)this.workflows.get(name);
        if (c == null) {
            throw new FactoryException("Unknown workflow name \"" + name + '\"');
        }
        if (c.descriptor != null) {
            this.loadWorkflow(c);
        }
        c.descriptor.setName(name);
        return c.descriptor;
    }

    public String[] getWorkflowNames() throws FactoryException {
        int i = 0;
        String[] res = new String[this.workflows.keySet().size()];
        Iterator it = this.workflows.keySet().iterator();
        while (it.hasNext()) {
            res[i++] = (String)it.next();
        }
        return res;
    }

    public void createWorkflow(String name) {
    }

    public void initDone() throws FactoryException {
    }

    public boolean removeWorkflow(String name) throws FactoryException {
        throw new FactoryException("remove workflow not supported");
    }

    public void renameWorkflow(String oldName, String newName) {
    }

    public void save() {
    }

    public boolean saveWorkflow(String name, WorkflowDescriptor descriptor, boolean replace) throws FactoryException {
        OutputStreamWriter out;
        HTTPWorkflowConfig c = (HTTPWorkflowConfig)this.workflows.get(name);
        if (c != null && !replace) {
            return false;
        }
        if (c == null) {
            throw new UnsupportedOperationException("Saving of new workflow is not currently supported");
        }
        try {
            out = new OutputStreamWriter(null, "utf-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new FactoryException("utf-8 encoding not supported, contact your JVM vendor!");
        }
        this.writeXML(descriptor, out);
        return true;
    }

    protected static String get(String urlValue, Map data) throws IOException {
        String line;
        StringBuffer value = new StringBuffer(urlValue);
        if (data.size() > 0) {
            if (value.indexOf("?") == -1) {
                value.append("?");
            } else {
                value.append("&");
            }
        }
        Iterator i = data.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            value.append(entry.getKey()).append('=');
            value.append(URLEncoder.encode((String)entry.getValue(), "utf-8"));
            if (!i.hasNext()) continue;
            value.append("&");
        }
        URL url = new URL(urlValue);
        URLConnection connection = url.openConnection();
        connection.setDoOutput(true);
        connection.setUseCaches(false);
        BufferedReader input = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        StringBuffer output = new StringBuffer();
        while (null != (line = input.readLine())) {
            output.append(line).append('\n');
        }
        input.close();
        return output.toString();
    }

    protected static String post(String urlValue, Map data) throws IOException {
        String line;
        URL url = new URL(urlValue);
        URLConnection connection = url.openConnection();
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setUseCaches(false);
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        DataOutputStream out = new DataOutputStream(connection.getOutputStream());
        StringBuffer content = new StringBuffer();
        Iterator i = data.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            content.append(entry.getKey()).append('=');
            content.append(URLEncoder.encode((String)entry.getValue(), "utf-8"));
            if (!i.hasNext()) continue;
            content.append("&");
        }
        out.writeBytes(content.toString());
        out.flush();
        out.close();
        BufferedReader input = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        StringBuffer output = new StringBuffer();
        while (null != (line = input.readLine())) {
            output.append(line).append('\n');
        }
        input.close();
        return output.toString();
    }

    protected String readLayoutBuffer(String url, String docId) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("docId", docId);
        map.put("command", "layout");
        return HTTPWorkflowFactory.get(url, map);
    }

    protected String readWorkflowBuffer(String url, String docId) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("docId", docId);
        map.put("command", "workflow");
        return HTTPWorkflowFactory.get(url, map);
    }

    protected String writeWorkflowDescriptor(String url, String docId, String name, String workflowXML) throws Exception {
        Object ret = null;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("docId", docId);
        map.put("data", workflowXML);
        map.put("command", "workflow");
        return HTTPWorkflowFactory.post(url, map);
    }

    protected String writeWorkflowLayout(String url, String docId, String name, String layoutXML) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("docId", docId);
        map.put("data", layoutXML);
        map.put("command", "layout");
        return HTTPWorkflowFactory.post(url, map);
    }

    protected void writeXML(WorkflowDescriptor descriptor, Writer out) {
        PrintWriter writer = new PrintWriter(new BufferedWriter(out));
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.println("<!DOCTYPE workflow PUBLIC \"-//OpenSymphony Group//DTD OSWorkflow 2.8//EN\" \"http://www.opensymphony.com/osworkflow/workflow_2_8.dtd\">");
        descriptor.writeXML(writer, 0);
        writer.flush();
        writer.close();
    }

    private void loadWorkflow(HTTPWorkflowConfig c) throws FactoryException {
    }

    static class HTTPWorkflowConfig {
        String docId;
        String name;
        String service_addr;
        WorkflowDescriptor descriptor;

        public HTTPWorkflowConfig(String service_addr, String name, String docId) {
            this.service_addr = service_addr;
            this.name = name;
            this.docId = docId;
        }
    }
}

