/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.loader;

import com.opensymphony.workflow.InvalidWorkflowDescriptorException;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.ConditionalResultDescriptor;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.ValidationHelper;
import com.opensymphony.workflow.loader.XMLUtil;
import com.opensymphony.workflow.util.Validatable;
import com.opensymphony.workflow.util.XMLizable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConditionsDescriptor
extends AbstractDescriptor
implements Validatable {
    private List conditions = new ArrayList();
    private String type;

    ConditionsDescriptor() {
    }

    ConditionsDescriptor(Element element) {
        this.type = element.getAttribute("type");
        NodeList children = element.getChildNodes();
        int size = children.getLength();
        for (int i = 0; i < size; ++i) {
            AbstractDescriptor condition;
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            if ("condition".equals(child.getNodeName())) {
                condition = DescriptorFactory.getFactory().createConditionDescriptor((Element)child);
                this.conditions.add(condition);
                continue;
            }
            if (!"conditions".equals(child.getNodeName())) continue;
            condition = DescriptorFactory.getFactory().createConditionsDescriptor((Element)child);
            this.conditions.add(condition);
        }
    }

    public void setConditions(List conditions) {
        this.conditions = conditions;
    }

    public List getConditions() {
        return this.conditions;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void validate() throws InvalidWorkflowDescriptorException {
        AbstractDescriptor desc;
        ValidationHelper.validate(this.conditions);
        if (this.conditions.size() == 0 && (desc = this.getParent()) != null && desc instanceof ConditionalResultDescriptor) {
            throw new InvalidWorkflowDescriptorException("Conditional result from " + ((ActionDescriptor)desc.getParent()).getName() + " to " + ((ConditionalResultDescriptor)desc).getDestination() + " must have at least one condition");
        }
        if (this.conditions.size() > 1 && this.type == null) {
            throw new InvalidWorkflowDescriptorException("Conditions must have AND or OR type specified");
        }
    }

    public void writeXML(PrintWriter out, int indent) {
        if (this.conditions.size() > 0) {
            XMLUtil.printIndent(out, indent++);
            StringBuffer sb = new StringBuffer("<conditions");
            if (this.conditions.size() > 1) {
                sb.append(" type=\"").append(this.type).append('\"');
            }
            sb.append('>');
            out.println(sb.toString());
            for (int i = 0; i < this.conditions.size(); ++i) {
                XMLizable condition = (XMLizable)this.conditions.get(i);
                condition.writeXML(out, indent);
            }
            XMLUtil.printIndent(out, --indent);
            out.println("</conditions>");
        }
    }
}

