/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import com.opensymphony.workflow.Condition;
import com.opensymphony.workflow.FactoryException;
import com.opensymphony.workflow.FunctionProvider;
import com.opensymphony.workflow.InvalidActionException;
import com.opensymphony.workflow.InvalidEntryStateException;
import com.opensymphony.workflow.InvalidInputException;
import com.opensymphony.workflow.InvalidRoleException;
import com.opensymphony.workflow.JoinNodes;
import com.opensymphony.workflow.Register;
import com.opensymphony.workflow.StoreException;
import com.opensymphony.workflow.TypeResolver;
import com.opensymphony.workflow.Validator;
import com.opensymphony.workflow.Workflow;
import com.opensymphony.workflow.WorkflowContext;
import com.opensymphony.workflow.WorkflowException;
import com.opensymphony.workflow.config.Configuration;
import com.opensymphony.workflow.config.DefaultConfiguration;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.ConditionDescriptor;
import com.opensymphony.workflow.loader.ConditionalResultDescriptor;
import com.opensymphony.workflow.loader.ConditionsDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import com.opensymphony.workflow.loader.JoinDescriptor;
import com.opensymphony.workflow.loader.PermissionDescriptor;
import com.opensymphony.workflow.loader.RegisterDescriptor;
import com.opensymphony.workflow.loader.RestrictionDescriptor;
import com.opensymphony.workflow.loader.ResultDescriptor;
import com.opensymphony.workflow.loader.SplitDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.ValidatorDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import com.opensymphony.workflow.query.WorkflowExpressionQuery;
import com.opensymphony.workflow.query.WorkflowQuery;
import com.opensymphony.workflow.spi.Step;
import com.opensymphony.workflow.spi.WorkflowEntry;
import com.opensymphony.workflow.spi.WorkflowStore;
import com.opensymphony.workflow.util.VariableResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AbstractWorkflow
implements Workflow {
    private static final Log log = LogFactory.getLog((Class)(class$com$opensymphony$workflow$AbstractWorkflow == null ? (class$com$opensymphony$workflow$AbstractWorkflow = AbstractWorkflow.class$("com.opensymphony.workflow.AbstractWorkflow")) : class$com$opensymphony$workflow$AbstractWorkflow));
    protected WorkflowContext context;
    private Configuration configuration;
    private ThreadLocal stateCache = new ThreadLocal();
    private TypeResolver typeResolver;
    static /* synthetic */ Class class$com$opensymphony$workflow$AbstractWorkflow;

    public AbstractWorkflow() {
        this.stateCache.set(new HashMap());
    }

    public int[] getAvailableActions(long id) {
        return this.getAvailableActions(id, new HashMap());
    }

    public int[] getAvailableActions(long id, Map inputs) {
        try {
            WorkflowStore store = this.getPersistence();
            WorkflowEntry entry = store.findEntry(id);
            if (entry == null) {
                throw new IllegalArgumentException("No such workflow id " + id);
            }
            if (entry.getState() != 1) {
                return new int[0];
            }
            WorkflowDescriptor wf = this.getConfiguration().getWorkflow(entry.getWorkflowName());
            if (wf == null) {
                throw new IllegalArgumentException("No such workflow " + entry.getWorkflowName());
            }
            ArrayList<Integer> l = new ArrayList<Integer>();
            PropertySet ps = store.getPropertySet(id);
            HashMap<String, Integer> transientVars = inputs == null ? new HashMap<String, Integer>() : new HashMap(inputs);
            List currentSteps = store.findCurrentSteps(id);
            this.populateTransientMap(entry, transientVars, wf.getRegisters(), new Integer(0), currentSteps, ps);
            List globalActions = wf.getGlobalActions();
            Iterator iterator = globalActions.iterator();
            while (iterator.hasNext()) {
                ActionDescriptor action = (ActionDescriptor)iterator.next();
                RestrictionDescriptor restriction = action.getRestriction();
                ConditionsDescriptor conditions = null;
                transientVars.put("actionId", new Integer(action.getId()));
                if (restriction != null) {
                    conditions = restriction.getConditionsDescriptor();
                }
                if (!this.passesConditions(wf.getGlobalConditions(), transientVars, ps, 0) || !this.passesConditions(conditions, transientVars, ps, 0)) continue;
                l.add(new Integer(action.getId()));
            }
            iterator = currentSteps.iterator();
            while (iterator.hasNext()) {
                Step step = (Step)iterator.next();
                l.addAll(this.getAvailableActionsForStep(wf, step, transientVars, ps));
            }
            int[] actions = new int[l.size()];
            for (int i = 0; i < actions.length; ++i) {
                actions[i] = (Integer)l.get(i);
            }
            return actions;
        }
        catch (Exception e) {
            log.error((Object)"Error checking available actions", (Throwable)e);
            return new int[0];
        }
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Configuration getConfiguration() {
        Configuration config;
        Configuration configuration = config = this.configuration != null ? this.configuration : DefaultConfiguration.INSTANCE;
        if (!config.isInitialized()) {
            try {
                config.load(null);
            }
            catch (FactoryException e) {
                log.fatal((Object)"Error initialising configuration", (Throwable)e);
                return null;
            }
        }
        return config;
    }

    public List getCurrentSteps(long id) {
        try {
            WorkflowStore store = this.getPersistence();
            return store.findCurrentSteps(id);
        }
        catch (StoreException e) {
            log.error((Object)("Error checking current steps for instance #" + id), (Throwable)e);
            return Collections.EMPTY_LIST;
        }
    }

    public int getEntryState(long id) {
        try {
            WorkflowStore store = this.getPersistence();
            return store.findEntry(id).getState();
        }
        catch (StoreException e) {
            log.error((Object)("Error checking instance state for instance #" + id), (Throwable)e);
            return -1;
        }
    }

    public List getHistorySteps(long id) {
        try {
            WorkflowStore store = this.getPersistence();
            return store.findHistorySteps(id);
        }
        catch (StoreException e) {
            log.error((Object)("Error getting history steps for instance #" + id), (Throwable)e);
            return Collections.EMPTY_LIST;
        }
    }

    public Properties getPersistenceProperties() {
        Properties p = new Properties();
        Iterator iter = this.getConfiguration().getPersistenceArgs().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            p.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return p;
    }

    public PropertySet getPropertySet(long id) {
        PropertySet ps = null;
        try {
            ps = this.getPersistence().getPropertySet(id);
        }
        catch (StoreException e) {
            log.error((Object)("Error getting propertyset for instance #" + id), (Throwable)e);
        }
        return ps;
    }

    public void setResolver(TypeResolver resolver) {
        this.typeResolver = resolver;
    }

    public TypeResolver getResolver() {
        if (this.typeResolver == null) {
            this.typeResolver = TypeResolver.getResolver();
        }
        return this.typeResolver;
    }

    public List getSecurityPermissions(long id) {
        return this.getSecurityPermissions(id, null);
    }

    public List getSecurityPermissions(long id, Map inputs) {
        try {
            WorkflowStore store = this.getPersistence();
            WorkflowEntry entry = store.findEntry(id);
            WorkflowDescriptor wf = this.getConfiguration().getWorkflow(entry.getWorkflowName());
            PropertySet ps = store.getPropertySet(id);
            HashMap transientVars = inputs == null ? new HashMap() : new HashMap(inputs);
            List currentSteps = store.findCurrentSteps(id);
            this.populateTransientMap(entry, transientVars, wf.getRegisters(), null, currentSteps, ps);
            ArrayList<String> s = new ArrayList<String>();
            Iterator interator = currentSteps.iterator();
            while (interator.hasNext()) {
                Step step = (Step)interator.next();
                int stepId = step.getStepId();
                StepDescriptor xmlStep = wf.getStep(stepId);
                List securities = xmlStep.getPermissions();
                Iterator iterator2 = securities.iterator();
                while (iterator2.hasNext()) {
                    PermissionDescriptor security = (PermissionDescriptor)iterator2.next();
                    if (security.getRestriction() == null || !this.passesConditions(security.getRestriction().getConditionsDescriptor(), transientVars, ps, xmlStep.getId())) continue;
                    s.add(security.getName());
                }
            }
            return s;
        }
        catch (Exception e) {
            log.error((Object)("Error getting security permissions for instance #" + id), (Throwable)e);
            return Collections.EMPTY_LIST;
        }
    }

    public WorkflowDescriptor getWorkflowDescriptor(String workflowName) {
        try {
            return this.getConfiguration().getWorkflow(workflowName);
        }
        catch (FactoryException e) {
            log.error((Object)("Error loading workflow " + workflowName), (Throwable)e);
            return null;
        }
    }

    public String getWorkflowName(long id) {
        try {
            WorkflowStore store = this.getPersistence();
            WorkflowEntry entry = store.findEntry(id);
            if (entry != null) {
                return entry.getWorkflowName();
            }
        }
        catch (StoreException e) {
            log.error((Object)("Error getting instance name for instance #" + id), (Throwable)e);
        }
        return null;
    }

    public String[] getWorkflowNames() {
        try {
            return this.getConfiguration().getWorkflowNames();
        }
        catch (FactoryException e) {
            log.error((Object)"Error getting workflow names", (Throwable)e);
            return new String[0];
        }
    }

    public boolean canInitialize(String workflowName, int initialAction) {
        return this.canInitialize(workflowName, initialAction, null);
    }

    public boolean canInitialize(String workflowName, int initialAction, Map inputs) {
        final String mockWorkflowName = workflowName;
        WorkflowEntry mockEntry = new WorkflowEntry(){

            public long getId() {
                return 0L;
            }

            public String getWorkflowName() {
                return mockWorkflowName;
            }

            public boolean isInitialized() {
                return false;
            }

            public int getState() {
                return 0;
            }
        };
        PropertySet ps = PropertySetManager.getInstance((String)"memory", null);
        HashMap transientVars = new HashMap();
        if (inputs != null) {
            transientVars.putAll(inputs);
        }
        try {
            this.populateTransientMap(mockEntry, transientVars, Collections.EMPTY_LIST, new Integer(initialAction), Collections.EMPTY_LIST, ps);
            return this.canInitialize(workflowName, initialAction, transientVars, ps);
        }
        catch (InvalidActionException e) {
            log.error((Object)e.getMessage());
            return false;
        }
        catch (WorkflowException e) {
            log.error((Object)"Error checking canInitialize", (Throwable)e);
            return false;
        }
    }

    public boolean canModifyEntryState(long id, int newState) {
        try {
            WorkflowStore store = this.getPersistence();
            WorkflowEntry entry = store.findEntry(id);
            int currentState = entry.getState();
            boolean result = false;
            switch (newState) {
                case 4: {
                    if (currentState != 1) break;
                    result = true;
                    break;
                }
                case 0: {
                    result = false;
                }
                case 1: {
                    if (currentState != 0 && currentState != 2) break;
                    result = true;
                    break;
                }
                case 2: {
                    if (currentState != 1) break;
                    result = true;
                    break;
                }
                case 3: {
                    if (currentState != 0 && currentState != 1 && currentState != 2) break;
                    result = true;
                    break;
                }
                default: {
                    result = false;
                }
            }
            return result;
        }
        catch (StoreException e) {
            log.error((Object)("Error checking state modifiable for instance #" + id), (Throwable)e);
            return false;
        }
    }

    public void changeEntryState(long id, int newState) throws WorkflowException {
        WorkflowStore store = this.getPersistence();
        WorkflowEntry entry = store.findEntry(id);
        if (entry.getState() == newState) {
            return;
        }
        if (this.canModifyEntryState(id, newState)) {
            List currentSteps;
            if ((newState == 3 || newState == 4) && (currentSteps = this.getCurrentSteps(id)).size() > 0) {
                this.completeEntry(null, id, currentSteps, newState);
            }
        } else {
            throw new InvalidEntryStateException("Can't transition workflow instance #" + id + ". Current state is " + entry.getState() + ", requested state is " + newState);
        }
        store.setEntryState(id, newState);
        if (log.isDebugEnabled()) {
            log.debug((Object)(entry.getId() + " : State is now : " + entry.getState()));
        }
    }

    public void doAction(long id, int actionId, Map inputs) throws WorkflowException {
        WorkflowStore store = this.getPersistence();
        WorkflowEntry entry = store.findEntry(id);
        if (entry.getState() != 1) {
            return;
        }
        WorkflowDescriptor wf = this.getConfiguration().getWorkflow(entry.getWorkflowName());
        List currentSteps = store.findCurrentSteps(id);
        ActionDescriptor action = null;
        PropertySet ps = store.getPropertySet(id);
        HashMap transientVars = new HashMap();
        if (inputs != null) {
            transientVars.putAll(inputs);
        }
        this.populateTransientMap(entry, transientVars, wf.getRegisters(), new Integer(actionId), currentSteps, ps);
        boolean validAction = false;
        Iterator gIter = wf.getGlobalActions().iterator();
        while (!validAction && gIter.hasNext()) {
            ActionDescriptor actionDesc = (ActionDescriptor)gIter.next();
            if (actionDesc.getId() != actionId || !this.isActionAvailable(action = actionDesc, transientVars, ps, 0)) continue;
            validAction = true;
        }
        Iterator iter = currentSteps.iterator();
        while (!validAction && iter.hasNext()) {
            Step step = (Step)iter.next();
            StepDescriptor s = wf.getStep(step.getStepId());
            Iterator iterator = s.getActions().iterator();
            while (!validAction && iterator.hasNext()) {
                ActionDescriptor actionDesc = (ActionDescriptor)iterator.next();
                if (actionDesc.getId() != actionId || !this.isActionAvailable(action = actionDesc, transientVars, ps, s.getId())) continue;
                validAction = true;
            }
        }
        if (!validAction) {
            throw new InvalidActionException("Action " + actionId + " is invalid");
        }
        try {
            if (!this.transitionWorkflow(entry, currentSteps, store, wf, action, transientVars, inputs, ps)) {
                this.checkImplicitFinish(action, id);
            }
        }
        catch (WorkflowException e) {
            this.context.setRollbackOnly();
            throw e;
        }
    }

    public void executeTriggerFunction(long id, int triggerId) throws WorkflowException {
        WorkflowStore store = this.getPersistence();
        WorkflowEntry entry = store.findEntry(id);
        if (entry == null) {
            log.warn((Object)("Cannot execute trigger #" + triggerId + " on non-existent workflow id#" + id));
            return;
        }
        WorkflowDescriptor wf = this.getConfiguration().getWorkflow(entry.getWorkflowName());
        PropertySet ps = store.getPropertySet(id);
        HashMap transientVars = new HashMap();
        this.populateTransientMap(entry, transientVars, wf.getRegisters(), null, store.findCurrentSteps(id), ps);
        this.executeFunction(wf.getTriggerFunction(triggerId), transientVars, ps);
    }

    public long initialize(String workflowName, int initialAction, Map inputs) throws InvalidRoleException, InvalidInputException, WorkflowException {
        WorkflowDescriptor wf = this.getConfiguration().getWorkflow(workflowName);
        WorkflowStore store = this.getPersistence();
        WorkflowEntry entry = store.createEntry(workflowName);
        PropertySet ps = store.getPropertySet(entry.getId());
        HashMap transientVars = new HashMap();
        if (inputs != null) {
            transientVars.putAll(inputs);
        }
        this.populateTransientMap(entry, transientVars, wf.getRegisters(), new Integer(initialAction), Collections.EMPTY_LIST, ps);
        if (!this.canInitialize(workflowName, initialAction, transientVars, ps)) {
            this.context.setRollbackOnly();
            throw new InvalidRoleException("You are restricted from initializing this workflow");
        }
        ActionDescriptor action = wf.getInitialAction(initialAction);
        try {
            this.transitionWorkflow(entry, Collections.EMPTY_LIST, store, wf, action, transientVars, inputs, ps);
        }
        catch (WorkflowException e) {
            this.context.setRollbackOnly();
            throw e;
        }
        long entryId = entry.getId();
        return entryId;
    }

    public List query(WorkflowQuery query) throws StoreException {
        return this.getPersistence().query(query);
    }

    public List query(WorkflowExpressionQuery query) throws WorkflowException {
        return this.getPersistence().query(query);
    }

    public boolean removeWorkflowDescriptor(String workflowName) throws FactoryException {
        return this.getConfiguration().removeWorkflow(workflowName);
    }

    public boolean saveWorkflowDescriptor(String workflowName, WorkflowDescriptor descriptor, boolean replace) throws FactoryException {
        boolean success = this.getConfiguration().saveWorkflow(workflowName, descriptor, replace);
        return success;
    }

    protected List getAvailableActionsForStep(WorkflowDescriptor wf, Step step, Map transientVars, PropertySet ps) throws WorkflowException {
        ArrayList<Integer> l = new ArrayList<Integer>();
        StepDescriptor s = wf.getStep(step.getStepId());
        if (s == null) {
            log.warn((Object)("getAvailableActionsForStep called for non-existent step Id #" + step.getStepId()));
            return l;
        }
        List actions = s.getActions();
        if (actions == null || actions.size() == 0) {
            return l;
        }
        Iterator iterator2 = actions.iterator();
        while (iterator2.hasNext()) {
            ActionDescriptor action = (ActionDescriptor)iterator2.next();
            RestrictionDescriptor restriction = action.getRestriction();
            ConditionsDescriptor conditions = null;
            transientVars.put("actionId", new Integer(action.getId()));
            if (restriction != null) {
                conditions = restriction.getConditionsDescriptor();
            }
            if (!this.passesConditions(wf.getGlobalConditions(), new HashMap(transientVars), ps, s.getId()) || !this.passesConditions(conditions, new HashMap(transientVars), ps, s.getId())) continue;
            l.add(new Integer(action.getId()));
        }
        return l;
    }

    protected int[] getAvailableAutoActions(long id, Map inputs) {
        try {
            WorkflowStore store = this.getPersistence();
            WorkflowEntry entry = store.findEntry(id);
            if (entry == null) {
                throw new IllegalArgumentException("No such workflow id " + id);
            }
            if (entry.getState() != 1) {
                log.debug((Object)("--> state is " + entry.getState()));
                return new int[0];
            }
            WorkflowDescriptor wf = this.getConfiguration().getWorkflow(entry.getWorkflowName());
            if (wf == null) {
                throw new IllegalArgumentException("No such workflow " + entry.getWorkflowName());
            }
            ArrayList<Integer> l = new ArrayList<Integer>();
            PropertySet ps = store.getPropertySet(id);
            HashMap<String, Integer> transientVars = inputs == null ? new HashMap<String, Integer>() : new HashMap(inputs);
            List currentSteps = store.findCurrentSteps(id);
            this.populateTransientMap(entry, transientVars, wf.getRegisters(), new Integer(0), currentSteps, ps);
            List globalActions = wf.getGlobalActions();
            Iterator iterator = globalActions.iterator();
            while (iterator.hasNext()) {
                ActionDescriptor action = (ActionDescriptor)iterator.next();
                transientVars.put("actionId", new Integer(action.getId()));
                if (!action.getAutoExecute() || !this.isActionAvailable(action, transientVars, ps, 0)) continue;
                l.add(new Integer(action.getId()));
            }
            iterator = currentSteps.iterator();
            while (iterator.hasNext()) {
                Step step = (Step)iterator.next();
                l.addAll(this.getAvailableAutoActionsForStep(wf, step, transientVars, ps));
            }
            int[] actions = new int[l.size()];
            for (int i = 0; i < actions.length; ++i) {
                actions[i] = (Integer)l.get(i);
            }
            return actions;
        }
        catch (Exception e) {
            log.error((Object)"Error checking available actions", (Throwable)e);
            return new int[0];
        }
    }

    protected List getAvailableAutoActionsForStep(WorkflowDescriptor wf, Step step, Map transientVars, PropertySet ps) throws WorkflowException {
        ArrayList<Integer> l = new ArrayList<Integer>();
        StepDescriptor s = wf.getStep(step.getStepId());
        if (s == null) {
            log.warn((Object)("getAvailableAutoActionsForStep called for non-existent step Id #" + step.getStepId()));
            return l;
        }
        List actions = s.getActions();
        if (actions == null || actions.size() == 0) {
            return l;
        }
        Iterator iterator2 = actions.iterator();
        while (iterator2.hasNext()) {
            ActionDescriptor action = (ActionDescriptor)iterator2.next();
            transientVars.put("actionId", new Integer(action.getId()));
            if (!action.getAutoExecute() || !this.isActionAvailable(action, transientVars, ps, s.getId())) continue;
            l.add(new Integer(action.getId()));
        }
        return l;
    }

    protected WorkflowStore getPersistence() throws StoreException {
        return this.getConfiguration().getWorkflowStore();
    }

    protected void checkImplicitFinish(ActionDescriptor action, long id) throws WorkflowException {
        WorkflowStore store = this.getPersistence();
        WorkflowEntry entry = store.findEntry(id);
        WorkflowDescriptor wf = this.getConfiguration().getWorkflow(entry.getWorkflowName());
        List currentSteps = store.findCurrentSteps(id);
        boolean isCompleted = true;
        Iterator iterator = currentSteps.iterator();
        while (iterator.hasNext()) {
            Step step = (Step)iterator.next();
            StepDescriptor stepDes = wf.getStep(step.getStepId());
            if (stepDes.getActions().size() <= 0) continue;
            isCompleted = false;
        }
        if (isCompleted) {
            this.completeEntry(action, id, currentSteps, 4);
        }
    }

    protected void completeEntry(ActionDescriptor action, long id, Collection currentSteps, int state) throws StoreException {
        this.getPersistence().setEntryState(id, state);
        Iterator i = new ArrayList(currentSteps).iterator();
        while (i.hasNext()) {
            Step step = (Step)i.next();
            String oldStatus = action != null ? action.getUnconditionalResult().getOldStatus() : "Finished";
            this.getPersistence().markFinished(step, action != null ? action.getId() : -1, new Date(), oldStatus, this.context.getCaller());
            this.getPersistence().moveToHistory(step);
        }
    }

    protected void executeFunction(FunctionDescriptor function, Map transientVars, PropertySet ps) throws WorkflowException {
        if (function != null) {
            String type = function.getType();
            HashMap args = new HashMap(function.getArgs());
            Iterator iterator = args.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry mapEntry = iterator.next();
                mapEntry.setValue(this.getConfiguration().getVariableResolver().translateVariables((String)mapEntry.getValue(), transientVars, ps));
            }
            FunctionProvider provider = this.getResolver().getFunction(type, args);
            if (provider == null) {
                String message = "Could not load FunctionProvider class";
                this.context.setRollbackOnly();
                throw new WorkflowException(message);
            }
            try {
                provider.execute(transientVars, args, ps);
            }
            catch (WorkflowException e) {
                this.context.setRollbackOnly();
                throw e;
            }
        }
    }

    protected boolean passesCondition(ConditionDescriptor conditionDesc, Map transientVars, PropertySet ps, int currentStepId) throws WorkflowException {
        Condition condition;
        Object stepId;
        String type = conditionDesc.getType();
        HashMap<String, String> args = new HashMap<String, String>(conditionDesc.getArgs());
        Iterator iterator = args.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry mapEntry = iterator.next();
            mapEntry.setValue(this.getConfiguration().getVariableResolver().translateVariables((String)mapEntry.getValue(), transientVars, ps));
        }
        if (currentStepId != -1 && (stepId = args.get("stepId")) != null && stepId.equals("-1")) {
            args.put("stepId", String.valueOf(currentStepId));
        }
        if ((condition = this.getResolver().getCondition(type, args)) == null) {
            this.context.setRollbackOnly();
            throw new WorkflowException("Could not load condition");
        }
        try {
            boolean passed = condition.passesCondition(transientVars, args, ps);
            if (conditionDesc.isNegate()) {
                passed = !passed;
            }
            return passed;
        }
        catch (Exception e) {
            this.context.setRollbackOnly();
            if (e instanceof WorkflowException) {
                throw (WorkflowException)e;
            }
            throw new WorkflowException("Unknown exception encountered when checking condition " + condition, e);
        }
    }

    protected boolean passesConditions(String conditionType, List conditions, Map transientVars, PropertySet ps, int currentStepId) throws WorkflowException {
        if (conditions == null || conditions.size() == 0) {
            return true;
        }
        boolean and = "AND".equals(conditionType);
        boolean or = !and;
        Iterator iterator = conditions.iterator();
        while (iterator.hasNext()) {
            boolean result;
            AbstractDescriptor descriptor = (AbstractDescriptor)iterator.next();
            if (descriptor instanceof ConditionsDescriptor) {
                ConditionsDescriptor conditionsDescriptor = (ConditionsDescriptor)descriptor;
                result = this.passesConditions(conditionsDescriptor.getType(), conditionsDescriptor.getConditions(), transientVars, ps, currentStepId);
            } else {
                result = this.passesCondition((ConditionDescriptor)descriptor, transientVars, ps, currentStepId);
            }
            if (and && !result) {
                return false;
            }
            if (!or || !result) continue;
            return true;
        }
        if (and) {
            return true;
        }
        if (or) {
            return false;
        }
        return false;
    }

    protected boolean passesConditions(ConditionsDescriptor descriptor, Map transientVars, PropertySet ps, int currentStepId) throws WorkflowException {
        if (descriptor == null) {
            return true;
        }
        return this.passesConditions(descriptor.getType(), descriptor.getConditions(), transientVars, ps, currentStepId);
    }

    protected void populateTransientMap(WorkflowEntry entry, Map transientVars, List registers, Integer actionId, Collection currentSteps, PropertySet ps) throws WorkflowException {
        transientVars.put("context", this.context);
        transientVars.put("entry", entry);
        transientVars.put("store", this.getPersistence());
        transientVars.put("configuration", this.getConfiguration());
        transientVars.put("descriptor", this.getConfiguration().getWorkflow(entry.getWorkflowName()));
        if (actionId != null) {
            transientVars.put("actionId", actionId);
        }
        transientVars.put("currentSteps", new ArrayList(currentSteps));
        Iterator iterator = registers.iterator();
        while (iterator.hasNext()) {
            RegisterDescriptor register = (RegisterDescriptor)iterator.next();
            Map args = register.getArgs();
            String type = register.getType();
            Register r = this.getResolver().getRegister(type, args);
            if (r == null) {
                String message = "Could not load register class";
                this.context.setRollbackOnly();
                throw new WorkflowException(message);
            }
            try {
                transientVars.put(register.getVariableName(), r.registerVariable(this.context, entry, args, ps));
            }
            catch (Exception e) {
                this.context.setRollbackOnly();
                if (e instanceof WorkflowException) {
                    throw (WorkflowException)e;
                }
                throw new WorkflowException("An unknown exception occured while registering variable using register " + r, e);
            }
        }
    }

    protected boolean transitionWorkflow(WorkflowEntry entry, List currentSteps, WorkflowStore store, WorkflowDescriptor wf, ActionDescriptor action, Map transientVars, Map inputs, PropertySet ps) throws WorkflowException {
        Iterator iterator;
        FunctionDescriptor function;
        FunctionDescriptor function2;
        Iterator iterator2;
        Map cache = (Map)this.stateCache.get();
        if (cache != null) {
            cache.clear();
        } else {
            this.stateCache.set(new HashMap());
        }
        Step step = this.getCurrentStep(wf, action.getId(), currentSteps, transientVars, ps);
        if (action.getValidators().size() > 0) {
            this.verifyInputs(entry, action.getValidators(), Collections.unmodifiableMap(transientVars), ps);
        }
        if (step != null) {
            List stepPostFunctions = wf.getStep(step.getStepId()).getPostFunctions();
            iterator2 = stepPostFunctions.iterator();
            while (iterator2.hasNext()) {
                function2 = (FunctionDescriptor)iterator2.next();
                this.executeFunction(function2, transientVars, ps);
            }
        }
        List preFunctions = action.getPreFunctions();
        iterator2 = preFunctions.iterator();
        while (iterator2.hasNext()) {
            function2 = (FunctionDescriptor)iterator2.next();
            this.executeFunction(function2, transientVars, ps);
        }
        List conditionalResults = action.getConditionalResults();
        List extraPreFunctions = null;
        List extraPostFunctions = null;
        ResultDescriptor[] theResults = new ResultDescriptor[1];
        Iterator iterator3 = conditionalResults.iterator();
        while (iterator3.hasNext()) {
            ConditionalResultDescriptor conditionalResult = (ConditionalResultDescriptor)iterator3.next();
            if (!this.passesConditions(null, conditionalResult.getConditions(), Collections.unmodifiableMap(transientVars), ps, step != null ? step.getStepId() : -1)) continue;
            theResults[0] = conditionalResult;
            if (conditionalResult.getValidators().size() > 0) {
                this.verifyInputs(entry, conditionalResult.getValidators(), Collections.unmodifiableMap(transientVars), ps);
            }
            extraPreFunctions = conditionalResult.getPreFunctions();
            extraPostFunctions = conditionalResult.getPostFunctions();
            break;
        }
        if (theResults[0] == null) {
            theResults[0] = action.getUnconditionalResult();
            this.verifyInputs(entry, theResults[0].getValidators(), Collections.unmodifiableMap(transientVars), ps);
            extraPreFunctions = theResults[0].getPreFunctions();
            extraPostFunctions = theResults[0].getPostFunctions();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("theResult=" + theResults[0].getStep() + ' ' + theResults[0].getStatus()));
        }
        if (extraPreFunctions != null && extraPreFunctions.size() > 0) {
            iterator3 = extraPreFunctions.iterator();
            while (iterator3.hasNext()) {
                function = (FunctionDescriptor)iterator3.next();
                this.executeFunction(function, transientVars, ps);
            }
        }
        if (theResults[0].getSplit() != 0) {
            FunctionDescriptor function3;
            SplitDescriptor splitDesc = wf.getSplit(theResults[0].getSplit());
            List results = splitDesc.getResults();
            ArrayList splitPreFunctions = new ArrayList();
            ArrayList splitPostFunctions = new ArrayList();
            Iterator iterator4 = results.iterator();
            while (iterator4.hasNext()) {
                ResultDescriptor resultDescriptor = (ResultDescriptor)iterator4.next();
                if (resultDescriptor.getValidators().size() > 0) {
                    this.verifyInputs(entry, resultDescriptor.getValidators(), Collections.unmodifiableMap(transientVars), ps);
                }
                splitPreFunctions.addAll(resultDescriptor.getPreFunctions());
                splitPostFunctions.addAll(resultDescriptor.getPostFunctions());
            }
            iterator4 = splitPreFunctions.iterator();
            while (iterator4.hasNext()) {
                function3 = (FunctionDescriptor)iterator4.next();
                this.executeFunction(function3, transientVars, ps);
            }
            if (!action.isFinish()) {
                boolean moveFirst = true;
                theResults = new ResultDescriptor[results.size()];
                results.toArray(theResults);
                iterator = results.iterator();
                while (iterator.hasNext()) {
                    ResultDescriptor resultDescriptor = (ResultDescriptor)iterator.next();
                    Step moveToHistoryStep = null;
                    if (moveFirst) {
                        moveToHistoryStep = step;
                    }
                    long[] previousIds = null;
                    if (step != null) {
                        previousIds = new long[]{step.getId()};
                    }
                    this.createNewCurrentStep(resultDescriptor, entry, store, action.getId(), moveToHistoryStep, previousIds, transientVars, ps);
                    moveFirst = false;
                }
            }
            iterator = splitPostFunctions.iterator();
            while (iterator.hasNext()) {
                function3 = (FunctionDescriptor)iterator.next();
                this.executeFunction(function3, transientVars, ps);
            }
        } else if (theResults[0].getJoin() != 0) {
            JoinDescriptor joinDesc = wf.getJoin(theResults[0].getJoin());
            step = store.markFinished(step, action.getId(), new Date(), theResults[0].getOldStatus(), this.context.getCaller());
            store.moveToHistory(step);
            ArrayList<Step> joinSteps = new ArrayList<Step>();
            joinSteps.add(step);
            Iterator iterator5 = currentSteps.iterator();
            while (iterator5.hasNext()) {
                StepDescriptor stepDesc;
                Step currentStep = (Step)iterator5.next();
                if (currentStep.getId() == step.getId() || !(stepDesc = wf.getStep(currentStep.getStepId())).resultsInJoin(theResults[0].getJoin())) continue;
                joinSteps.add(currentStep);
            }
            List historySteps = store.findHistorySteps(entry.getId());
            Iterator i = historySteps.iterator();
            while (i.hasNext()) {
                StepDescriptor stepDesc;
                Step historyStep = (Step)i.next();
                if (historyStep.getId() == step.getId() || !(stepDesc = wf.getStep(historyStep.getStepId())).resultsInJoin(theResults[0].getJoin())) continue;
                joinSteps.add(historyStep);
            }
            JoinNodes jn = new JoinNodes(joinSteps);
            transientVars.put("jn", jn);
            if (this.passesConditions(null, joinDesc.getConditions(), Collections.unmodifiableMap(transientVars), ps, 0)) {
                ResultDescriptor joinresult = joinDesc.getResult();
                if (joinresult.getValidators().size() > 0) {
                    this.verifyInputs(entry, joinresult.getValidators(), Collections.unmodifiableMap(transientVars), ps);
                }
                iterator = joinresult.getPreFunctions().iterator();
                while (iterator.hasNext()) {
                    FunctionDescriptor function4 = (FunctionDescriptor)iterator.next();
                    this.executeFunction(function4, transientVars, ps);
                }
                long[] previousIds = new long[joinSteps.size()];
                int i2 = 1;
                Iterator iterator6 = joinSteps.iterator();
                while (iterator6.hasNext()) {
                    Step currentStep = (Step)iterator6.next();
                    if (currentStep.getId() == step.getId()) continue;
                    if (!historySteps.contains(currentStep)) {
                        store.moveToHistory(currentStep);
                    }
                    previousIds[i2] = currentStep.getId();
                    ++i2;
                }
                if (!action.isFinish()) {
                    previousIds[0] = step.getId();
                    theResults[0] = joinDesc.getResult();
                    this.createNewCurrentStep(joinDesc.getResult(), entry, store, action.getId(), null, previousIds, transientVars, ps);
                }
                iterator6 = joinresult.getPostFunctions().iterator();
                while (iterator6.hasNext()) {
                    FunctionDescriptor function5 = (FunctionDescriptor)iterator6.next();
                    this.executeFunction(function5, transientVars, ps);
                }
            }
        } else {
            long[] previousIds = null;
            if (step != null) {
                previousIds = new long[]{step.getId()};
            }
            if (!action.isFinish()) {
                this.createNewCurrentStep(theResults[0], entry, store, action.getId(), step, previousIds, transientVars, ps);
            }
        }
        if (extraPostFunctions != null) {
            iterator3 = extraPostFunctions.iterator();
            while (iterator3.hasNext()) {
                function = (FunctionDescriptor)iterator3.next();
                this.executeFunction(function, transientVars, ps);
            }
        }
        List postFunctions = action.getPostFunctions();
        Iterator iterator7 = postFunctions.iterator();
        while (iterator7.hasNext()) {
            FunctionDescriptor function6 = (FunctionDescriptor)iterator7.next();
            this.executeFunction(function6, transientVars, ps);
        }
        if (wf.getInitialAction(action.getId()) != null && entry.getState() != 1) {
            this.changeEntryState(entry.getId(), 1);
        }
        if (action.isFinish()) {
            this.completeEntry(action, entry.getId(), this.getCurrentSteps(entry.getId()), 4);
            return true;
        }
        int[] availableAutoActions = this.getAvailableAutoActions(entry.getId(), inputs);
        if (availableAutoActions.length > 0) {
            this.doAction(entry.getId(), availableAutoActions[0], inputs);
        }
        return false;
    }

    protected void verifyInputs(WorkflowEntry entry, List validators, Map transientVars, PropertySet ps) throws WorkflowException {
        Iterator iterator = validators.iterator();
        while (iterator.hasNext()) {
            ValidatorDescriptor input = (ValidatorDescriptor)iterator.next();
            if (input == null) continue;
            String type = input.getType();
            HashMap args = new HashMap(input.getArgs());
            Iterator iterator2 = args.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry mapEntry = iterator2.next();
                mapEntry.setValue(this.getConfiguration().getVariableResolver().translateVariables((String)mapEntry.getValue(), transientVars, ps));
            }
            Validator validator = this.getResolver().getValidator(type, args);
            if (validator == null) {
                String message = "Could not load validator class";
                this.context.setRollbackOnly();
                throw new WorkflowException(message);
            }
            try {
                validator.validate(transientVars, args, ps);
            }
            catch (InvalidInputException e) {
                throw e;
            }
            catch (Exception e) {
                this.context.setRollbackOnly();
                if (e instanceof WorkflowException) {
                    throw (WorkflowException)e;
                }
                String message = "An unknown exception occured executing Validator " + validator;
                throw new WorkflowException(message, e);
            }
        }
    }

    private boolean isActionAvailable(ActionDescriptor action, Map transientVars, PropertySet ps, int stepId) throws WorkflowException {
        if (action == null) {
            return false;
        }
        WorkflowDescriptor wf = this.getWorkflowDescriptorForAction(action);
        HashMap<ActionDescriptor, Boolean> cache = (HashMap<ActionDescriptor, Boolean>)this.stateCache.get();
        Boolean result = null;
        if (cache != null) {
            result = (Boolean)cache.get(action);
        } else {
            cache = new HashMap<ActionDescriptor, Boolean>();
            this.stateCache.set(cache);
        }
        if (result == null) {
            RestrictionDescriptor restriction = action.getRestriction();
            ConditionsDescriptor conditions = null;
            if (restriction != null) {
                conditions = restriction.getConditionsDescriptor();
            }
            result = new Boolean(this.passesConditions(wf.getGlobalConditions(), new HashMap(transientVars), ps, stepId) && this.passesConditions(conditions, new HashMap(transientVars), ps, stepId));
            cache.put(action, result);
        }
        return result;
    }

    private Step getCurrentStep(WorkflowDescriptor wfDesc, int actionId, List currentSteps, Map transientVars, PropertySet ps) throws WorkflowException {
        if (currentSteps.size() == 1) {
            return (Step)currentSteps.get(0);
        }
        Iterator iterator = currentSteps.iterator();
        while (iterator.hasNext()) {
            Step step = (Step)iterator.next();
            ActionDescriptor action = wfDesc.getStep(step.getStepId()).getAction(actionId);
            if (!this.isActionAvailable(action, transientVars, ps, step.getStepId())) continue;
            return step;
        }
        return null;
    }

    private WorkflowDescriptor getWorkflowDescriptorForAction(ActionDescriptor action) {
        AbstractDescriptor objWfd = action;
        while (!(objWfd instanceof WorkflowDescriptor)) {
            objWfd = objWfd.getParent();
        }
        WorkflowDescriptor wf = (WorkflowDescriptor)objWfd;
        return wf;
    }

    private boolean canInitialize(String workflowName, int initialAction, Map transientVars, PropertySet ps) throws WorkflowException {
        WorkflowDescriptor wf = this.getConfiguration().getWorkflow(workflowName);
        ActionDescriptor actionDescriptor = wf.getInitialAction(initialAction);
        if (actionDescriptor == null) {
            throw new InvalidActionException("Invalid Initial Action #" + initialAction);
        }
        RestrictionDescriptor restriction = actionDescriptor.getRestriction();
        ConditionsDescriptor conditions = null;
        if (restriction != null) {
            conditions = restriction.getConditionsDescriptor();
        }
        return this.passesConditions(conditions, new HashMap(transientVars), ps, 0);
    }

    private Step createNewCurrentStep(ResultDescriptor theResult, WorkflowEntry entry, WorkflowStore store, int actionId, Step currentStep, long[] previousIds, Map transientVars, PropertySet ps) throws WorkflowException {
        try {
            WorkflowDescriptor descriptor;
            StepDescriptor step;
            int nextStep = theResult.getStep();
            if (nextStep == -1) {
                if (currentStep != null) {
                    nextStep = currentStep.getStepId();
                } else {
                    throw new StoreException("Illegal argument: requested new current step same as current step, but current step not specified");
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Outcome: stepId=" + nextStep + ", status=" + theResult.getStatus() + ", owner=" + theResult.getOwner() + ", actionId=" + actionId + ", currentStep=" + (currentStep != null ? currentStep.getStepId() : 0)));
            }
            if (previousIds == null) {
                previousIds = new long[]{};
            }
            String owner = theResult.getOwner();
            VariableResolver variableResolver = this.getConfiguration().getVariableResolver();
            if (owner != null) {
                Object o = variableResolver.translateVariables(owner, transientVars, ps);
                owner = o != null ? o.toString() : null;
            }
            String oldStatus = theResult.getOldStatus();
            oldStatus = variableResolver.translateVariables(oldStatus, transientVars, ps).toString();
            String status = theResult.getStatus();
            status = variableResolver.translateVariables(status, transientVars, ps).toString();
            if (currentStep != null) {
                store.markFinished(currentStep, actionId, new Date(), oldStatus, this.context.getCaller());
                store.moveToHistory(currentStep);
            }
            Date startDate = new Date();
            Date dueDate = null;
            if (theResult.getDueDate() != null && theResult.getDueDate().length() > 0) {
                Number num;
                long offset;
                Object dueDateObject = variableResolver.translateVariables(theResult.getDueDate(), transientVars, ps);
                if (dueDateObject instanceof Date) {
                    dueDate = (Date)dueDateObject;
                } else if (dueDateObject instanceof String) {
                    long offset2 = 0L;
                    try {
                        offset2 = Long.parseLong((String)dueDateObject);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    if (offset2 > 0L) {
                        dueDate = new Date(startDate.getTime() + offset2);
                    }
                } else if (dueDateObject instanceof Number && (offset = (num = (Number)dueDateObject).longValue()) > 0L) {
                    dueDate = new Date(startDate.getTime() + offset);
                }
            }
            Step newStep = store.createCurrentStep(entry.getId(), nextStep, owner, startDate, dueDate, status, previousIds);
            transientVars.put("createdStep", newStep);
            if (previousIds != null && previousIds.length == 0 && currentStep == null) {
                ArrayList<Step> currentSteps = new ArrayList<Step>();
                currentSteps.add(newStep);
                transientVars.put("currentSteps", new ArrayList(currentSteps));
            }
            if ((step = (descriptor = (WorkflowDescriptor)transientVars.get("descriptor")).getStep(nextStep)) == null) {
                throw new WorkflowException("step #" + nextStep + " does not exist");
            }
            List preFunctions = step.getPreFunctions();
            Iterator iterator = preFunctions.iterator();
            while (iterator.hasNext()) {
                FunctionDescriptor function = (FunctionDescriptor)iterator.next();
                this.executeFunction(function, transientVars, ps);
            }
            return newStep;
        }
        catch (WorkflowException e) {
            this.context.setRollbackOnly();
            throw e;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

