/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.user.authenticator.weblogic;

import com.opensymphony.user.authenticator.AbstractAuthenticator;
import com.opensymphony.user.authenticator.AuthenticationException;
import com.opensymphony.user.authenticator.JAASCallbackHandler;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import weblogic.security.services.Authentication;
import weblogic.servlet.security.ServletAuthentication;

public class WeblogicAuthenticator
extends AbstractAuthenticator {
    private static final Log log = LogFactory.getLog((Class)WeblogicAuthenticator.class);

    public boolean login(String username, String password, HttpServletRequest req) throws AuthenticationException {
        JAASCallbackHandler handler = new JAASCallbackHandler(username, password);
        try {
            Subject subject = this.properties.getProperty("realm") == null ? Authentication.login((CallbackHandler)handler) : Authentication.login((String)this.properties.getProperty("realm"), (CallbackHandler)handler);
            ServletAuthentication.runAs((Subject)subject, (HttpServletRequest)req);
        }
        catch (LoginException e) {
            log.warn((Object)("Error authenticating username " + username + ":" + e));
            return false;
        }
        return true;
    }
}

