/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.random;

import com.opensymphony.module.random.Rijndael;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Random;

public final class Yarrow
extends Random {
    private static final int Pt = 5;
    private static final int Pg = 10;
    private static String seedfile;
    private static final int FAST_THRESHOLD = 100;
    private static final int SLOW_THRESHOLD = 160;
    private static final int SLOW_K = 2;
    static final int[][] bitTable;
    public byte[] ZERO_ARRAY = new byte[16384];
    private Hashtable entropySeen;
    private MessageDigest fast_pool;
    private MessageDigest reseed_ctx;
    private MessageDigest slow_pool;
    private Rijndael cipher_ctx;
    private byte[] allZeroString;
    private byte[] counter;
    private byte[] output_buffer;
    private byte[] tmp;
    private boolean fast_select;
    private int fast_entropy;
    private int fetch_counter;
    private int output_count;
    private int slow_entropy;

    public Yarrow() {
        try {
            this.accumulator_init();
            this.reseed_init();
            this.generator_init();
            this.entropy_init(seedfile);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void acceptEntropy(EntropySource source, long data, int entropyGuess) {
        this.accept_entropy(data, source, Math.min(32, Math.min(this.estimateEntropy(source, data), entropyGuess)));
    }

    public void acceptTimerEntropy(EntropySource timer) {
        long now = System.currentTimeMillis();
        this.acceptEntropy(timer, now - timer.lastVal, 32);
    }

    public void makeKey(byte[] entropy, byte[] key, int offset, int len) {
        try {
            MessageDigest ctx = MessageDigest.getInstance("SHA1");
            int ic = 0;
            while (len > 0) {
                int bc;
                ++ic;
                for (int i = 0; i < ic; ++i) {
                    ctx.update((byte)0);
                }
                ctx.update(entropy, 0, entropy.length);
                if (len > 20) {
                    ctx.digest(key, offset, 20);
                    bc = 20;
                } else {
                    byte[] hash = ctx.digest();
                    bc = Math.min(len, hash.length);
                    System.arraycopy(hash, 0, key, offset, bc);
                }
                offset += bc;
                len -= bc;
            }
            this.wipe(entropy);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not generate key: " + e.getMessage());
        }
    }

    public void wipe(byte[] data) {
        System.arraycopy(this.ZERO_ARRAY, 0, data, 0, data.length);
    }

    protected int next(int bits) {
        int[] parameters = bitTable[bits];
        int offset = this.getBytes(parameters[0]);
        int val = this.output_buffer[offset];
        if (parameters[0] == 4) {
            val += (this.output_buffer[offset + 1] << 24) + (this.output_buffer[offset + 2] << 16) + (this.output_buffer[offset + 3] << 8);
        } else if (parameters[0] == 3) {
            val += (this.output_buffer[offset + 1] << 16) + (this.output_buffer[offset + 2] << 8);
        } else if (parameters[0] == 2) {
            val += this.output_buffer[offset + 2] << 8;
        }
        return val & parameters[1];
    }

    private synchronized int getBytes(int count) {
        if (this.fetch_counter + count > this.output_buffer.length) {
            this.fetch_counter = 0;
            this.generateOutput();
            return this.getBytes(count);
        }
        int rv = this.fetch_counter;
        this.fetch_counter += count;
        return rv;
    }

    private void accept_entropy(long data, EntropySource source, int actualEntropy) {
        block4: {
            block3: {
                MessageDigest pool = this.fast_select ? this.fast_pool : this.slow_pool;
                pool.update((byte)data);
                pool.update((byte)(data >> 8));
                pool.update((byte)(data >> 16));
                pool.update((byte)(data >> 24));
                pool.update((byte)(data >> 32));
                pool.update((byte)(data >> 40));
                pool.update((byte)(data >> 48));
                pool.update((byte)(data >> 56));
                boolean bl = this.fast_select = !this.fast_select;
                if (!this.fast_select) break block3;
                this.fast_entropy += actualEntropy;
                if (this.fast_entropy <= 100) break block4;
                this.fast_pool_reseed();
                break block4;
            }
            this.slow_entropy += actualEntropy;
            if (source != null) {
                Integer contributedEntropy = (Integer)this.entropySeen.get(source);
                contributedEntropy = contributedEntropy == null ? new Integer(actualEntropy) : new Integer(actualEntropy + contributedEntropy);
                this.entropySeen.put(source, contributedEntropy);
                if (this.slow_entropy >= 320) {
                    int kc = 0;
                    Enumeration e = this.entropySeen.keys();
                    while (e.hasMoreElements()) {
                        Object key = e.nextElement();
                        Integer v = (Integer)this.entropySeen.get(key);
                        if (v <= 160 || ++kc < 2) continue;
                        this.slow_pool_reseed();
                        break;
                    }
                }
            }
        }
    }

    private void accumulator_init() throws NoSuchAlgorithmException {
        this.fast_pool = MessageDigest.getInstance("SHA1");
        this.slow_pool = MessageDigest.getInstance("SHA1");
        this.entropySeen = new Hashtable();
    }

    private void consumeBytes(byte[] bytes) {
        if (this.fast_select) {
            this.fast_pool.update(bytes, 0, bytes.length);
        } else {
            this.slow_pool.update(bytes, 0, bytes.length);
        }
        this.fast_select = !this.fast_select;
    }

    private void consumeString(String str) {
        if (str == null) {
            return;
        }
        byte[] b = str.getBytes();
        this.consumeBytes(b);
    }

    private void counterInc() {
        int i = this.counter.length - 1;
        while (i >= 0) {
            int n = i--;
            this.counter[n] = (byte)(this.counter[n] + 1);
            if (this.counter[n] != 0) break;
        }
    }

    private void entropy_init(String seed) {
        Properties sys = System.getProperties();
        EntropySource startupEntropy = new EntropySource();
        Enumeration<?> e = sys.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            this.consumeString(key);
            this.consumeString(sys.getProperty(key));
        }
        try {
            this.consumeString(InetAddress.getLocalHost().toString());
        }
        catch (Exception e2) {
            // empty catch block
        }
        this.acceptEntropy(startupEntropy, System.currentTimeMillis(), 0);
        this.read_seed(seed);
    }

    private int estimateEntropy(EntropySource source, long newVal) {
        int delta = (int)(newVal - source.lastVal);
        int delta2 = delta - source.lastDelta;
        source.lastDelta = delta;
        int delta3 = delta2 - source.lastDelta2;
        source.lastDelta2 = delta2;
        if (delta < 0) {
            delta = -delta;
        }
        if (delta2 < 0) {
            delta2 = -delta2;
        }
        if (delta3 < 0) {
            delta3 = -delta3;
        }
        if (delta > delta2) {
            delta = delta2;
        }
        if (delta > delta3) {
            delta = delta3;
        }
        delta >>= 1;
        delta &= 0xFFF;
        delta |= delta >> 8;
        delta |= delta >> 4;
        delta |= delta >> 2;
        delta |= delta >> 1;
        delta >>= 1;
        delta -= delta >> 1 & 0x555;
        delta = (delta & 0x333) + (delta >> 2 & 0x333);
        delta += delta >> 4;
        delta += delta >> 8;
        source.lastVal = newVal;
        return delta & 0xF;
    }

    private void fast_pool_reseed() {
        byte[] v0;
        byte[] vi = v0 = this.fast_pool.digest();
        for (byte i = 0; i < 5; i = (byte)(i + 1)) {
            this.reseed_ctx.update(vi, 0, vi.length);
            this.reseed_ctx.update(v0, 0, v0.length);
            this.reseed_ctx.update(i);
            vi = this.reseed_ctx.digest();
        }
        this.makeKey(vi, this.tmp, 0, this.tmp.length);
        this.rekey(this.tmp);
        this.wipe(v0);
        this.fast_entropy = 0;
        this.write_seed(seedfile);
    }

    private void generateOutput() {
        this.counterInc();
        this.output_buffer = this.cipher_ctx.encipher(this.counter);
        if (this.output_count++ > 10) {
            this.output_count = 0;
            this.nextBytes(this.tmp);
            this.rekey(this.tmp);
        }
    }

    private void generator_init() {
        this.cipher_ctx = new Rijndael();
        this.output_buffer = new byte[this.cipher_ctx.getBlockSize() / 8];
        this.counter = new byte[this.cipher_ctx.getBlockSize() / 8];
        this.allZeroString = new byte[this.cipher_ctx.getBlockSize() / 8];
        this.tmp = new byte[this.cipher_ctx.getKeySize() / 8];
        this.fetch_counter = this.output_buffer.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read_seed(String filename) {
        EntropySource seedFile = new EntropySource();
        FilterInputStream dis = null;
        try {
            dis = new DataInputStream(new FileInputStream(filename));
            for (int i = 0; i < 32; ++i) {
                this.acceptEntropy(seedFile, ((DataInputStream)dis).readLong(), 64);
            }
        }
        catch (Exception f) {
            Random rand = new Random();
            for (int i = 0; i < 32; ++i) {
                this.acceptEntropy(seedFile, rand.nextLong(), 64);
            }
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException e) {}
            }
        }
        this.fast_pool_reseed();
    }

    private void rekey(byte[] key) {
        this.cipher_ctx.initialize(key);
        this.counter = this.cipher_ctx.encipher(this.allZeroString);
        this.wipe(key);
    }

    private void reseed_init() throws NoSuchAlgorithmException {
        this.reseed_ctx = MessageDigest.getInstance("SHA1");
    }

    private void slow_pool_reseed() {
        byte[] slow_hash = this.slow_pool.digest();
        this.fast_pool.update(slow_hash, 0, slow_hash.length);
        this.fast_pool_reseed();
        this.slow_entropy = 0;
        Integer ZERO = new Integer(0);
        Enumeration e = this.entropySeen.keys();
        while (e.hasMoreElements()) {
            this.entropySeen.put(e.nextElement(), ZERO);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write_seed(String filename) {
        FilterOutputStream dos = null;
        try {
            dos = new DataOutputStream(new FileOutputStream(filename));
            for (int i = 0; i < 32; ++i) {
                ((DataOutputStream)dos).writeLong(this.nextLong());
            }
        }
        catch (IOException ex) {
            System.out.println(this.getClass().getName() + " error writing seed file to " + filename + ": " + ex);
        }
        finally {
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static {
        bitTable = new int[][]{{0, 0}, {1, 1}, {1, 3}, {1, 7}, {1, 15}, {1, 31}, {1, 63}, {1, 127}, {1, 255}, {2, 511}, {2, 1023}, {2, 2047}, {2, 4095}, {2, 8191}, {2, 16383}, {2, Short.MAX_VALUE}, {2, 65535}, {3, 131071}, {3, 262143}, {3, 524287}, {3, 1048575}, {3, 0x1FFFFF}, {3, 0x3FFFFF}, {3, 0x7FFFFF}, {3, 0xFFFFFF}, {4, 0x1FFFFFF}, {4, 0x3FFFFFF}, {4, 0x7FFFFFF}, {4, 0xFFFFFFF}, {4, 0x1FFFFFFF}, {4, 0x3FFFFFFF}, {4, Integer.MAX_VALUE}, {4, -1}};
        try {
            File file = new File(new File(System.getProperty("java.io.tmpdir")), "prng.seed." + System.currentTimeMillis());
            seedfile = file.toString();
            file.deleteOnExit();
        }
        catch (Throwable t) {
            seedfile = "prng.seed";
        }
    }

    public static class EntropySource {
        public int lastDelta;
        public int lastDelta2;
        public long lastVal;
    }
}

