/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.oscache.base;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Config
implements Serializable {
    private static final transient Log log = LogFactory.getLog((Class)Config.class);
    private static final String PROPERTIES_FILENAME = "/oscache.properties";
    private Properties properties = null;

    public Config() {
        this(null);
    }

    public Config(Properties p) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"OSCache: Config called");
        }
        this.properties = p == null ? Config.loadProperties(PROPERTIES_FILENAME, "the default configuration") : p;
    }

    public String getProperty(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (this.properties == null) {
            return null;
        }
        return this.properties.getProperty(key);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Object get(Object key) {
        return this.properties.get(key);
    }

    public void set(Object key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (value == null) {
            return;
        }
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(URL url, String info) {
        log.info((Object)("OSCache: Getting properties from URL " + url + " for " + info));
        Properties properties = new Properties();
        InputStream in = null;
        try {
            in = url.openStream();
            properties.load(in);
            log.info((Object)("OSCache: Properties read " + properties));
        }
        catch (Exception e) {
            log.error((Object)("OSCache: Error reading from " + url), (Throwable)e);
            log.error((Object)("OSCache: Ensure the properties information in " + url + " is readable and in your classpath."));
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                log.warn((Object)("OSCache: IOException while closing InputStream: " + e.getMessage()));
            }
        }
        return properties;
    }

    public static Properties loadProperties(String filename, String info) {
        URL url = null;
        ClassLoader threadContextClassLoader = Thread.currentThread().getContextClassLoader();
        if (threadContextClassLoader != null) {
            url = threadContextClassLoader.getResource(filename);
        }
        if (url == null && (url = Config.class.getResource(filename)) == null) {
            log.warn((Object)("OSCache: No properties file found in the classpath by filename " + filename));
            return new Properties();
        }
        return Config.loadProperties(url, info);
    }
}

