/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.metadata.provider;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.opensaml.saml2.common.SAML2Helper;
import org.opensaml.saml2.metadata.provider.AbstractObservableMetadataProvider;
import org.opensaml.saml2.metadata.provider.FilterException;
import org.opensaml.saml2.metadata.provider.MetadataFilter;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.UnmarshallingException;

public class URLMetadataProvider
extends AbstractObservableMetadataProvider {
    private XMLObject cachedMetadata;
    private final Logger log = Logger.getLogger(URLMetadataProvider.class);
    private URI metadataURI;
    private boolean maintainExpiredMetadata;
    private HttpClient httpClient;
    private AuthScope authScope;
    private int maxCacheDuration;
    private DateTime mdExpirationTime;

    public URLMetadataProvider(String metadataURL, int requestTimeout) throws MetadataProviderException {
        try {
            this.metadataURI = new URI(metadataURL);
            this.maintainExpiredMetadata = true;
            HttpClientParams clientParams = new HttpClientParams();
            clientParams.setSoTimeout(requestTimeout);
            this.httpClient = new HttpClient(clientParams);
            this.authScope = new AuthScope(this.metadataURI.getHost(), this.metadataURI.getPort());
            this.maxCacheDuration = 86400000;
        }
        catch (URISyntaxException e) {
            throw new MetadataProviderException("Illegal URL syntax", e);
        }
    }

    public void initialize() throws MetadataProviderException {
        this.refreshMetadata();
    }

    public String getMetadataURI() {
        return this.metadataURI.toASCIIString();
    }

    public boolean maintainExpiredMetadata() {
        return this.maintainExpiredMetadata;
    }

    public void setMaintainExpiredMetadata(boolean maintain) {
        this.maintainExpiredMetadata = maintain;
    }

    public void setBasicCredentials(String username, String password) {
        if (username == null && password == null) {
            this.httpClient.getState().setCredentials(null, null);
        } else {
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
            this.httpClient.getState().setCredentials(this.authScope, (Credentials)credentials);
        }
    }

    public int getRequestTimeout() {
        return this.httpClient.getParams().getSoTimeout();
    }

    public void setSocketFactory(ProtocolSocketFactory newSocketFactory) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Using the custom socket factory " + newSocketFactory.getClass().getName() + " to connect to the HTTP server"));
        }
        Protocol protocol = new Protocol(this.metadataURI.getScheme(), newSocketFactory, this.metadataURI.getPort());
        this.httpClient.getHostConfiguration().setHost(this.metadataURI.getHost(), this.metadataURI.getPort(), protocol);
    }

    public int getMaxCacheDuration() {
        return this.maxCacheDuration;
    }

    public void setMaxCacheDuration(int newDuration) {
        this.maxCacheDuration = newDuration;
    }

    public void setMetadataFilter(MetadataFilter newFilter) throws MetadataProviderException {
        super.setMetadataFilter(newFilter);
        this.refreshMetadata();
    }

    public XMLObject getMetadata() throws MetadataProviderException {
        if (this.mdExpirationTime.isBeforeNow()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Cached metadata is stale, refreshing");
            }
            this.refreshMetadata();
        }
        return this.cachedMetadata;
    }

    protected void cacheMetadata(XMLObject metadata) {
        this.cachedMetadata = metadata;
    }

    protected synchronized void refreshMetadata() throws MetadataProviderException {
        if (this.mdExpirationTime != null && !this.mdExpirationTime.isBeforeNow()) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Refreshing cache of metadata from URL " + this.metadataURI + ", max cache duration set to " + this.maxCacheDuration + "ms"));
        }
        try {
            this.cachedMetadata = this.fetchMetadata();
            this.filterMetadata(this.cachedMetadata);
            this.releaseMetadataDOM(this.cachedMetadata);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Calculating expiration time");
            }
            DateTime now = new DateTime();
            this.mdExpirationTime = SAML2Helper.getEarliestExpiration(this.cachedMetadata, now.plus((long)(this.maxCacheDuration * 1000)), now);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Metadata cache expires on " + this.mdExpirationTime));
            }
            this.emitChangeEvent();
        }
        catch (IOException e) {
            String errorMsg = "Unable to read metadata from server";
            this.log.error((Object)errorMsg, (Throwable)e);
            throw new MetadataProviderException(errorMsg, e);
        }
        catch (UnmarshallingException e) {
            String errorMsg = "Unable to unmarshall metadata";
            this.log.error((Object)errorMsg, (Throwable)e);
            throw new MetadataProviderException(errorMsg, (Exception)((Object)e));
        }
        catch (FilterException e) {
            String errorMsg = "Unable to filter metadata";
            this.log.error((Object)errorMsg, (Throwable)e);
            throw new MetadataProviderException(errorMsg, e);
        }
    }

    protected XMLObject fetchMetadata() throws IOException, UnmarshallingException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Fetching metadata document from remote server");
        }
        GetMethod getMethod = new GetMethod(this.getMetadataURI());
        if (this.httpClient.getState().getCredentials(this.authScope) != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Using BASIC authentication when retrieving metadata");
            }
            getMethod.setDoAuthentication(true);
        }
        this.httpClient.executeMethod((HttpMethod)getMethod);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Retrieved the following metadata document\n" + getMethod.getResponseBodyAsString()));
        }
        XMLObject metadata = this.unmarshallMetadata(getMethod.getResponseBodyAsStream());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Unmarshalled metadata from remote server");
        }
        return metadata;
    }
}

