/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.metadata.provider;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.apache.log4j.Logger;
import org.opensaml.saml2.metadata.provider.AbstractObservableMetadataProvider;
import org.opensaml.saml2.metadata.provider.FilterException;
import org.opensaml.saml2.metadata.provider.MetadataFilter;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.UnmarshallingException;

public class FilesystemMetadataProvider
extends AbstractObservableMetadataProvider {
    private static Logger log = Logger.getLogger(FilesystemMetadataProvider.class);
    private File metadataFile;
    private boolean maintainExpiredMetadata;
    private long lastUpdate;
    private XMLObject cachedMetadata;

    public FilesystemMetadataProvider(File metadata) throws MetadataProviderException {
        if (metadata == null) {
            throw new MetadataProviderException("Give metadata file may not be null");
        }
        if (!metadata.exists()) {
            throw new MetadataProviderException("Give metadata file, " + metadata.getAbsolutePath() + " does not exist");
        }
        if (!metadata.isFile()) {
            throw new MetadataProviderException("Give metadata file, " + metadata.getAbsolutePath() + " is not a file");
        }
        if (!metadata.canRead()) {
            throw new MetadataProviderException("Give metadata file, " + metadata.getAbsolutePath() + " is not readable");
        }
        this.metadataFile = metadata;
        this.maintainExpiredMetadata = true;
    }

    public void initialize() throws MetadataProviderException {
        this.refreshMetadata();
    }

    public boolean maintainExpiredMetadata() {
        return this.maintainExpiredMetadata;
    }

    public void setMaintainExpiredMetadata(boolean maintain) {
        this.maintainExpiredMetadata = maintain;
    }

    public void setMetadataFilter(MetadataFilter newFilter) throws MetadataProviderException {
        super.setMetadataFilter(newFilter);
        this.refreshMetadata();
    }

    public XMLObject getMetadata() throws MetadataProviderException {
        if (this.lastUpdate < this.metadataFile.lastModified()) {
            this.refreshMetadata();
        }
        return this.cachedMetadata;
    }

    private synchronized void refreshMetadata() throws MetadataProviderException {
        if (this.lastUpdate >= this.metadataFile.lastModified()) {
            return;
        }
        try {
            this.cachedMetadata = this.unmarshallMetadata(new FileInputStream(this.metadataFile));
            this.filterMetadata(this.cachedMetadata);
            this.releaseMetadataDOM(this.cachedMetadata);
            this.lastUpdate = this.metadataFile.lastModified();
            this.emitChangeEvent();
        }
        catch (FileNotFoundException e) {
            String errorMsg = "Unable to read metadata file";
            log.error((Object)errorMsg, (Throwable)e);
            throw new MetadataProviderException(errorMsg, e);
        }
        catch (UnmarshallingException e) {
            String errorMsg = "Unable to unmarshall metadata";
            log.error((Object)errorMsg, (Throwable)e);
            throw new MetadataProviderException(errorMsg, (Exception)((Object)e));
        }
        catch (FilterException e) {
            String errorMsg = "Unable to filter metadata";
            log.error((Object)errorMsg, (Throwable)e);
            throw new MetadataProviderException(errorMsg, e);
        }
    }
}

