/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.binding.security;

import java.util.List;
import javax.servlet.ServletRequest;
import org.apache.log4j.Logger;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.binding.security.SAMLSecurityPolicyContext;
import org.opensaml.common.binding.security.SAMLSecurityPolicyHelper;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.RequestAbstractType;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.StatusResponseType;
import org.opensaml.ws.security.SecurityPolicyContext;
import org.opensaml.ws.security.SecurityPolicyException;
import org.opensaml.ws.security.SecurityPolicyRule;
import org.opensaml.ws.security.SecurityPolicyRuleFactory;
import org.opensaml.xml.XMLObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAML2ProtocolMessageRuleFactory
implements SecurityPolicyRuleFactory<ServletRequest> {
    private static Logger log = Logger.getLogger(SAML2ProtocolMessageRule.class);

    public SecurityPolicyRule<ServletRequest> createRuleInstance() {
        return new SAML2ProtocolMessageRule();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SAML2ProtocolMessageRule
    implements SecurityPolicyRule<ServletRequest> {
        public void evaluate(ServletRequest request, XMLObject message, SecurityPolicyContext context) throws SecurityPolicyException {
            SAMLSecurityPolicyContext samlContext = (SAMLSecurityPolicyContext)context;
            if (samlContext == null) {
                log.error((Object)"Supplied context was not an instance of SAMLSecurityPolicyContext");
                throw new IllegalArgumentException("Supplied context was not an instance of SAMLSecurityPolicyContext");
            }
            SAMLObject samlMsg = SAMLSecurityPolicyHelper.getSAMLMessage(message);
            if (samlMsg == null) {
                log.warn((Object)"Could not extract SAML message");
                return;
            }
            if (samlMsg instanceof RequestAbstractType) {
                log.debug((Object)"Extracting ID, issuer and issue instant from request");
                this.extractRequestInfo(samlContext, (RequestAbstractType)samlMsg);
            } else if (samlMsg instanceof StatusResponseType) {
                log.debug((Object)"Extracting ID, issuer and issue instant from status response");
                this.extractResponseInfo(samlContext, (StatusResponseType)samlMsg);
            } else {
                throw new SecurityPolicyException("SAML 2 message was not a request or a response");
            }
            if (samlContext.getIssuer() == null) {
                log.warn((Object)"Issuer could not be extracted from SAML message");
                return;
            }
        }

        protected void extractResponseInfo(SAMLSecurityPolicyContext samlContext, StatusResponseType statusResponse) throws SecurityPolicyException {
            List<Assertion> assertions;
            samlContext.setMessageID(statusResponse.getID());
            samlContext.setIssueInstant(statusResponse.getIssueInstant());
            String messageIssuer = null;
            if (statusResponse.getIssuer() != null) {
                messageIssuer = this.extractEntityId(statusResponse.getIssuer());
            } else if (statusResponse instanceof Response && (assertions = ((Response)statusResponse).getAssertions()) != null && assertions.size() > 0) {
                log.info((Object)"Status response message had no issuer, attempting to extract issuer from enclosed Assertion(s)");
                for (Assertion assertion : assertions) {
                    if (assertion == null || assertion.getIssuer() == null) continue;
                    String assertionIssuer = this.extractEntityId(assertion.getIssuer());
                    if (messageIssuer != null && !messageIssuer.equals(assertionIssuer)) {
                        throw new SecurityPolicyException("SAML 2 assertions, within response " + statusResponse.getID() + " contain different issuer IDs");
                    }
                    messageIssuer = assertionIssuer;
                }
            }
            samlContext.setIssuer(messageIssuer);
        }

        protected void extractRequestInfo(SAMLSecurityPolicyContext samlContext, RequestAbstractType request) throws SecurityPolicyException {
            samlContext.setMessageID(request.getID());
            samlContext.setIssueInstant(request.getIssueInstant());
            samlContext.setIssuer(this.extractEntityId(request.getIssuer()));
        }

        protected String extractEntityId(Issuer issuer) throws SecurityPolicyException {
            if (issuer != null) {
                if (issuer.getFormat() == null || issuer.getFormat().equals("urn:oasis:names:tc:SAML:2.0:nameid-format:entity")) {
                    return issuer.getValue();
                }
                throw new SecurityPolicyException("SAML 2 Issuer is not of ENTITY format type");
            }
            return null;
        }
    }
}

