/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.binding.encoding;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.opensaml.common.SAMLVersion;
import org.opensaml.common.binding.BindingException;
import org.opensaml.common.binding.artifact.SAMLArtifact;
import org.opensaml.common.binding.artifact.SAMLArtifactFactory;
import org.opensaml.common.binding.artifact.SAMLArtifactMap;
import org.opensaml.saml2.binding.encoding.AbstractSAML2HTTPMessageEncoder;
import org.opensaml.util.URLBuilder;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.Pair;

public class HTTPArtifactEncoder
extends AbstractSAML2HTTPMessageEncoder {
    private static Logger log = Logger.getLogger(HTTPArtifactEncoder.class);
    private VelocityEngine velocityEngine;
    private String velocityTemplateId;
    private byte[] artifactType;
    private SAMLArtifactFactory artifactFactory;
    private SAMLArtifactMap artifactMap;
    private ENCODING_METHOD encodingMethod;
    private SAMLArtifact artifact;

    public String getBindingURI() {
        if (this.encodingMethod == ENCODING_METHOD.FORM) {
            return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
        }
        return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect";
    }

    public VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }

    public void setVelocityEngine(VelocityEngine engine) {
        this.velocityEngine = engine;
    }

    public String getVelocityTemplateId() {
        return this.velocityTemplateId;
    }

    public void setVelocityTemplateId(String id) {
        this.velocityTemplateId = id;
    }

    public ENCODING_METHOD getEncodingMethod() {
        return this.encodingMethod;
    }

    public void setEncodingMethod(ENCODING_METHOD method) {
        this.encodingMethod = method;
    }

    public SAMLArtifactFactory getArtifactFactory() {
        return this.artifactFactory;
    }

    public void setArtifactFactory(SAMLArtifactFactory factory) {
        this.artifactFactory = factory;
    }

    public SAMLArtifactMap getArtifactMap() {
        return this.artifactMap;
    }

    public void setArtifactMap(SAMLArtifactMap map) {
        this.artifactMap = map;
    }

    public byte[] getArtifactType() {
        return this.artifactType;
    }

    public void setArtifactType(byte[] type) {
        this.artifactType = type;
    }

    public SAMLArtifact getArtifact() {
        return this.artifact;
    }

    public void encode() throws BindingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Beginning SAML 2 HTTP Artifact encoding");
        }
        HttpServletResponse response = (HttpServletResponse)this.getResponse();
        response.setCharacterEncoding("UTF-8");
        if (log.isDebugEnabled()) {
            log.debug((Object)"Generating SAML artifact and mapping SAML message to it");
        }
        this.generateArtifact();
        if (this.encodingMethod == ENCODING_METHOD.FORM) {
            this.postEncode(this.getArtifact().base64Encode());
        } else if (this.encodingMethod == ENCODING_METHOD.URL) {
            this.getEncode(this.getArtifact().base64Encode());
        }
    }

    protected void postEncode(String artifactString) throws BindingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Performing HTTP POST SAML 2 artifact encoding");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating velocity context");
        }
        VelocityContext context = new VelocityContext();
        context.put("action", (Object)this.getEndpointURL());
        context.put("SAMLArt", (Object)artifactString);
        String relayState = this.getRelayState();
        if (this.checkRelayState()) {
            context.put("RelayState", (Object)relayState);
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Performing HTTP GET SAML 2 artifact encoding");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Invoking velocity template");
            }
            this.velocityEngine.mergeTemplate(this.velocityTemplateId, "UTF-8", (Context)context, (Writer)((HttpServletResponse)this.getResponse()).getWriter());
        }
        catch (Exception e) {
            log.error((Object)"Error invoking velocity template to create POST form", (Throwable)e);
            throw new BindingException("Error creating output document", e);
        }
    }

    protected void getEncode(String artifactString) throws BindingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Performing HTTP GET SAML 2 artifact encoding");
        }
        try {
            URLBuilder urlBuilder = new URLBuilder(this.getEndpointURL());
            List params = urlBuilder.getQueryParams();
            params.add(new Pair((Object)"SAMLArt", (Object)artifactString));
            if (!DatatypeHelper.isEmpty((String)this.getRelayState())) {
                params.add(new Pair((Object)"RelayState", (Object)this.getEncodeRelayState()));
            }
            ((HttpServletResponse)this.getResponse()).sendRedirect(urlBuilder.buildURL());
        }
        catch (IOException e) {
            log.error((Object)"Unable to send HTTP redirect", (Throwable)e);
            throw new BindingException("Unable to send HTTP redirect", e);
        }
    }

    protected void generateArtifact() throws BindingException {
        SAMLArtifactFactory factory = this.getArtifactFactory();
        this.artifact = factory.buildArtifact(SAMLVersion.VERSION_20, this.getArtifactType(), this.getRelyingParty().getEntityID());
        this.artifactMap.put(this.artifact.getArtifactBytes(), this.getRelyingParty().getID(), this.getIssuer(), this.getSamlMessage());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ENCODING_METHOD {
        URL,
        FORM;

    }
}

