/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml1.binding.security;

import java.util.List;
import javax.servlet.ServletRequest;
import org.apache.log4j.Logger;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.binding.security.SAMLSecurityPolicyContext;
import org.opensaml.common.binding.security.SAMLSecurityPolicyHelper;
import org.opensaml.saml1.core.Assertion;
import org.opensaml.saml1.core.RequestAbstractType;
import org.opensaml.saml1.core.Response;
import org.opensaml.saml1.core.ResponseAbstractType;
import org.opensaml.ws.security.SecurityPolicyContext;
import org.opensaml.ws.security.SecurityPolicyException;
import org.opensaml.ws.security.SecurityPolicyRule;
import org.opensaml.ws.security.SecurityPolicyRuleFactory;
import org.opensaml.xml.XMLObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAML1ProtocolMessageRuleFactory
implements SecurityPolicyRuleFactory<ServletRequest> {
    private static Logger log = Logger.getLogger(SAML1ProtocolMessageRule.class);

    public SecurityPolicyRule<ServletRequest> createRuleInstance() {
        return new SAML1ProtocolMessageRule();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SAML1ProtocolMessageRule
    implements SecurityPolicyRule<ServletRequest> {
        public void evaluate(ServletRequest request, XMLObject message, SecurityPolicyContext context) throws SecurityPolicyException {
            SAMLSecurityPolicyContext samlContext = (SAMLSecurityPolicyContext)context;
            if (samlContext == null) {
                log.error((Object)"Supplied context was not an instance of SAMLSecurityPolicyContext");
                throw new IllegalArgumentException("Supplied context was not an instance of SAMLSecurityPolicyContext");
            }
            SAMLObject samlMsg = SAMLSecurityPolicyHelper.getSAMLMessage(message);
            if (samlMsg == null) {
                log.warn((Object)"Could not extract SAML message");
                return;
            }
            if (samlMsg instanceof RequestAbstractType) {
                log.debug((Object)"Extracting ID, issuer and issue instant from request");
                this.extractRequestInfo(samlContext, (RequestAbstractType)samlMsg);
            } else if (samlMsg instanceof ResponseAbstractType) {
                log.debug((Object)"Extracting ID, issuer and issue instant from response");
                this.extractResponseInfo(samlContext, (ResponseAbstractType)samlMsg);
            } else {
                throw new SecurityPolicyException("SAML 1.x message was not a request or a response");
            }
        }

        protected void extractResponseInfo(SAMLSecurityPolicyContext samlContext, ResponseAbstractType response) throws SecurityPolicyException {
            samlContext.setMessageID(response.getID());
            samlContext.setIssueInstant(response.getIssueInstant());
            if (response instanceof Response) {
                String issuer = null;
                List<Assertion> assertions = ((Response)response).getAssertions();
                if (assertions != null && assertions.size() > 0) {
                    log.info((Object)"Attempting to extract issuer from enclosed SAML 1.x Assertion(s)");
                    for (Assertion assertion : assertions) {
                        if (assertion == null || assertion.getIssuer() == null) continue;
                        if (issuer != null && !issuer.equals(assertion.getIssuer())) {
                            throw new SecurityPolicyException("SAML 1.x assertions, within response " + response.getID() + " contain different issuer IDs");
                        }
                        issuer = assertion.getIssuer();
                    }
                }
                samlContext.setIssuer(issuer);
            }
            if (samlContext.getIssuer() == null) {
                log.info((Object)"Issuer could not be extracted from standard SAML 1.x response message");
                return;
            }
        }

        protected void extractRequestInfo(SAMLSecurityPolicyContext samlContext, RequestAbstractType request) {
            samlContext.setMessageID(request.getID());
            samlContext.setIssueInstant(request.getIssueInstant());
        }
    }
}

