/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml1.binding.decoding;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.binding.BindingException;
import org.opensaml.common.binding.decoding.impl.AbstractHTTPMessageDecoder;
import org.opensaml.ws.security.SecurityPolicyException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.util.Base64;

public class HTTPPostDecoder
extends AbstractHTTPMessageDecoder {
    public static final String BINDING_URI = "urn:oasis:names:tc:SAML:1.0:profiles:browser-post";
    public static final String RESPONSE_PARAM = "SAMLResponse";
    public static final String TARGET_PARAM = "TARGET";
    private static Logger log = Logger.getLogger(HTTPPostDecoder.class);

    public String getBindingURI() {
        return BINDING_URI;
    }

    public void decode() throws BindingException, SecurityPolicyException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Beginning decode of request using HTTP POST binding");
        }
        this.setRelayState(((HttpServletRequest)this.getRequest()).getParameter(TARGET_PARAM));
        InputStream decodedMessage = this.getBase64DecodedMessage();
        SAMLObject samlMessage = (SAMLObject)this.unmarshallMessage(decodedMessage);
        this.evaluateSecurityPolicy((XMLObject)samlMessage);
        this.setSAMLMessage(samlMessage);
        if (log.isDebugEnabled()) {
            log.debug((Object)"HTTP request successfully decoded using SAML 2 HTTP POST binding");
        }
    }

    protected InputStream getBase64DecodedMessage() throws BindingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Getting Base64 encoded message from request");
        }
        String encodedMessage = ((HttpServletRequest)this.getRequest()).getParameter(RESPONSE_PARAM);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Base64 decoding SAML message");
        }
        byte[] decodedMessage = Base64.decode((String)encodedMessage);
        return new ByteArrayInputStream(decodedMessage);
    }
}

