/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml1.binding.artifact;

import java.util.Arrays;
import org.opensaml.saml1.binding.artifact.AbstractSAML1Artifact;
import org.opensaml.xml.util.DatatypeHelper;

public class SAML1ArtifactType0002
extends AbstractSAML1Artifact {
    public static final byte[] TYPE_CODE = new byte[]{0, 2};
    private byte[] assertionHandle;
    private String sourceLocation;

    public SAML1ArtifactType0002() {
        super(TYPE_CODE);
    }

    public SAML1ArtifactType0002(String sourceLocation) throws IllegalArgumentException {
        super(TYPE_CODE);
        byte[] assertionHandle = new byte[20];
        this.randomGen.nextBytes(assertionHandle);
        this.setAssertionHandle(assertionHandle);
        this.setSourceLocation(sourceLocation);
    }

    public SAML1ArtifactType0002(byte[] assertionHandle, String sourceLocation) throws IllegalArgumentException {
        super(TYPE_CODE);
        this.setAssertionHandle(assertionHandle);
        this.setSourceLocation(sourceLocation);
    }

    public static SAML1ArtifactType0002 parseArtifact(byte[] artifact) throws IllegalArgumentException {
        byte[] typeCode = new byte[]{artifact[0], artifact[1]};
        if (!Arrays.equals(typeCode, TYPE_CODE)) {
            throw new IllegalArgumentException("Artifact is not of appropriate type.");
        }
        byte[] assertionHandle = new byte[20];
        System.arraycopy(artifact, 2, assertionHandle, 0, 20);
        int locationLength = artifact.length - 22;
        byte[] sourceLocation = new byte[locationLength];
        System.arraycopy(artifact, 22, sourceLocation, 0, locationLength);
        return new SAML1ArtifactType0002(assertionHandle, new String(sourceLocation));
    }

    public byte[] getAssertionHandle() {
        return this.assertionHandle;
    }

    public void setAssertionHandle(byte[] assertionHandle) {
        if (assertionHandle.length != 20) {
            throw new IllegalArgumentException("Artifact assertion handle must be 20 bytes long");
        }
    }

    public String getSourceLocation() {
        return this.sourceLocation;
    }

    protected void setSourceLocation(String newLocation) throws IllegalArgumentException {
        String location = DatatypeHelper.safeTrimOrNullString((String)newLocation);
        if (location == null) {
            throw new IllegalArgumentException("Artifact source location may not be a null or empty string");
        }
        this.sourceLocation = location;
    }

    public byte[] getRemainingArtifact() {
        byte[] sourceLocation = this.getSourceLocation().getBytes();
        byte[] remainingArtifact = new byte[20 + sourceLocation.length];
        System.arraycopy(this.getAssertionHandle(), 0, remainingArtifact, 0, 20);
        System.arraycopy(sourceLocation, 0, remainingArtifact, 20, sourceLocation.length);
        return remainingArtifact;
    }
}

