/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.common.binding.security;

import javax.servlet.ServletRequest;
import javax.xml.namespace.QName;
import org.opensaml.common.binding.security.SAMLSecurityPolicy;
import org.opensaml.ws.security.SecurityPolicy;
import org.opensaml.ws.security.provider.BaseSecurityPolicyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMLSecurityPolicyFactory
extends BaseSecurityPolicyFactory<ServletRequest> {
    private QName issuerRole;
    private String issuerProtocol;
    private boolean requiredAuthenticatedIssuer = true;

    public String getIssuerProtocol() {
        return this.issuerProtocol;
    }

    public void setIssuerProtocol(String protocol) {
        this.issuerProtocol = protocol;
    }

    public QName getIssuerRole() {
        return this.issuerRole;
    }

    public void setIssuerRole(QName role) {
        this.issuerRole = role;
    }

    public boolean getRequiredAuthenticatedIssuer() {
        return this.requiredAuthenticatedIssuer;
    }

    public void setRequiredAuthenticatedIssuer(boolean required) {
        this.requiredAuthenticatedIssuer = required;
    }

    public SecurityPolicy<ServletRequest> createPolicyInstance() {
        SAMLSecurityPolicy securityPolicy = new SAMLSecurityPolicy(this.issuerRole, this.issuerProtocol, this.requiredAuthenticatedIssuer);
        securityPolicy.getPolicyRules().addAll(this.getPolicyRuleInstances());
        return securityPolicy;
    }
}

