/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.common.binding.security;

import javax.servlet.ServletRequest;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.opensaml.common.binding.security.SAMLSecurityPolicyContext;
import org.opensaml.ws.security.SecurityPolicyContext;
import org.opensaml.ws.security.SecurityPolicyException;
import org.opensaml.ws.security.SecurityPolicyRule;
import org.opensaml.ws.security.SecurityPolicyRuleFactory;
import org.opensaml.xml.XMLObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IssueInstantRuleFactory
implements SecurityPolicyRuleFactory<ServletRequest> {
    private int clockSkew;
    private int expires;

    public int getClockSkew() {
        return this.clockSkew;
    }

    public void setClockSkew(int newClockSkew) {
        this.clockSkew = newClockSkew;
    }

    public int getExpires() {
        return this.expires;
    }

    public void setExpires(int newExpires) {
        this.expires = newExpires;
    }

    public SecurityPolicyRule<ServletRequest> createRuleInstance() {
        return new IssueInstantRule(this.clockSkew, this.expires);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class IssueInstantRule
    implements SecurityPolicyRule<ServletRequest> {
        private int clockSkew;
        private int expires;

        public IssueInstantRule(int newClockSkew, int newExpires) {
            this.clockSkew = newClockSkew;
            this.expires = newExpires;
        }

        public void evaluate(ServletRequest request, XMLObject message, SecurityPolicyContext context) throws SecurityPolicyException {
            Logger log = Logger.getLogger(IssueInstantRule.class);
            SAMLSecurityPolicyContext samlContext = (SAMLSecurityPolicyContext)context;
            if (samlContext == null) {
                log.error((Object)"Supplied context was not an instance of SAMLSecurityPolicyContext");
                throw new IllegalArgumentException("Supplied context was not an instance of SAMLSecurityPolicyContext");
            }
            if (samlContext.getIssueInstant() == null) {
                log.debug((Object)"Message did not contain an issue instant, skipping evaluation");
                return;
            }
            DateTime issueInstant = samlContext.getIssueInstant();
            DateTime now = new DateTime();
            DateTime latestValid = now.plusSeconds(this.clockSkew);
            DateTime expiration = issueInstant.plusSeconds(this.clockSkew + this.expires);
            if (issueInstant.isAfter((ReadableInstant)latestValid)) {
                log.error((Object)("Message was not yet valid: message time was '" + issueInstant + "', latest valid is: '" + latestValid + "'"));
                throw new SecurityPolicyException("Message was rejected because was issued in the future");
            }
            if (expiration.isBefore((ReadableInstant)now)) {
                log.error((Object)("Message was expired: message issue time was '" + issueInstant + "', message expired at: '" + expiration + "', current time: '" + now + "'"));
                throw new SecurityPolicyException("Message was rejected due to issue instant expiration");
            }
        }
    }
}

