/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.common.binding.decoding.impl;

import java.io.InputStream;
import javax.servlet.ServletRequest;
import org.apache.log4j.Logger;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.binding.BindingException;
import org.opensaml.common.binding.decoding.MessageDecoder;
import org.opensaml.common.binding.decoding.impl.AbstractHTTPMessageDecoder;
import org.opensaml.common.binding.security.SAMLSecurityPolicy;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.ws.security.SecurityPolicyException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.parse.XMLParserException;
import org.opensaml.xml.security.trust.TrustEngine;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessageDecoder<RequestType extends ServletRequest>
implements MessageDecoder<RequestType> {
    private static Logger log = Logger.getLogger(AbstractHTTPMessageDecoder.class);
    private ParserPool parser;
    private MetadataProvider metadataProvider;
    private RequestType request;
    private SAMLObject message;
    private SAMLSecurityPolicy securityPolicy;
    private TrustEngine trustEngine;

    public ParserPool getParserPool() {
        return this.parser;
    }

    public void setParserPool(ParserPool pool) {
        this.parser = pool;
    }

    @Override
    public MetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    @Override
    public RequestType getRequest() {
        return this.request;
    }

    @Override
    public SAMLObject getSAMLMessage() {
        return this.message;
    }

    @Override
    public SAMLSecurityPolicy getSecurityPolicy() {
        return this.securityPolicy;
    }

    @Override
    public TrustEngine getTrustEngine() {
        return this.trustEngine;
    }

    @Override
    public void setMetadataProvider(MetadataProvider newProvider) {
        this.metadataProvider = newProvider;
    }

    @Override
    public void setRequest(RequestType newRequest) {
        this.request = newRequest;
    }

    protected void setSAMLMessage(SAMLObject newMessage) {
        this.message = newMessage;
    }

    @Override
    public void setSecurityPolicy(SAMLSecurityPolicy policy) {
        this.securityPolicy = policy;
    }

    @Override
    public void setTrustEngine(TrustEngine newEngine) {
        this.trustEngine = newEngine;
    }

    protected XMLObject unmarshallMessage(InputStream samlMessage) throws BindingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unmarshalling message");
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Parsing message XML into a DOM");
            }
            Document domMessage = this.parser.parse(samlMessage);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Unmarshalling DOM");
            }
            Unmarshaller unmarshaller = Configuration.getUnmarshallerFactory().getUnmarshaller(domMessage.getDocumentElement());
            return unmarshaller.unmarshall(domMessage.getDocumentElement());
        }
        catch (XMLParserException e) {
            log.error((Object)"Unable to parse message XML", (Throwable)e);
            throw new BindingException("Unable to parse message XML", (Exception)((Object)e));
        }
        catch (UnmarshallingException e) {
            log.error((Object)"Unable to unmarshall message DOM", (Throwable)e);
            throw new BindingException("Unable to unmarshaller message DOM", (Exception)((Object)e));
        }
    }

    protected void evaluateSecurityPolicy(XMLObject decodedMessage) throws SecurityPolicyException {
        SAMLSecurityPolicy policy;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Evaluating request and SAML message against security policy");
        }
        if ((policy = this.getSecurityPolicy()) != null) {
            try {
                policy.evaluate((ServletRequest)this.getRequest(), decodedMessage);
            }
            catch (SecurityPolicyException e) {
                log.error((Object)"Security policy exception thrown during message decoding", (Throwable)e);
                throw e;
            }
        }
    }
}

