/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.eval;

import opennlp.tools.util.eval.Mean;

public final class FMeasure {
    private Mean precisionScore = new Mean();
    private Mean recallScore = new Mean();

    public double getPrecisionScore() {
        return this.precisionScore.mean();
    }

    public double getRecallScore() {
        return this.recallScore.mean();
    }

    public double getFMeasure() {
        if (this.getPrecisionScore() + this.getRecallScore() > 0.0) {
            return 2.0 * (this.getPrecisionScore() * this.getRecallScore()) / (this.getPrecisionScore() + this.getRecallScore());
        }
        return -1.0;
    }

    public void updateScores(Object[] references, Object[] predictions) {
        double recall;
        double precision = FMeasure.precision(references, predictions);
        if (!Double.isNaN(precision)) {
            this.precisionScore.add(precision, references.length);
        }
        if (!Double.isNaN(recall = FMeasure.recall(references, predictions))) {
            this.recallScore.add(FMeasure.recall(references, predictions), references.length);
        }
    }

    public void mergeInto(FMeasure measure) {
        this.precisionScore.add(measure.getPrecisionScore(), measure.precisionScore.count());
        this.recallScore.add(measure.getRecallScore(), measure.recallScore.count());
    }

    public String toString() {
        return "Precision: " + Double.toString(this.getPrecisionScore()) + "\n" + "Recall: " + Double.toString(this.getRecallScore()) + "\n" + "F-Measure: " + Double.toString(this.getFMeasure());
    }

    static int countTruePositives(Object[] references, Object[] predictions) {
        int truePositives = 0;
        for (int referenceIndex = 0; referenceIndex < references.length; ++referenceIndex) {
            Object referenceName = references[referenceIndex];
            for (int predictedIndex = 0; predictedIndex < predictions.length; ++predictedIndex) {
                if (!referenceName.equals(predictions[predictedIndex])) continue;
                ++truePositives;
            }
        }
        return truePositives;
    }

    public static double precision(Object[] references, Object[] predictions) {
        if (predictions.length > 0) {
            return (double)FMeasure.countTruePositives(references, predictions) / (double)predictions.length;
        }
        return Double.NaN;
    }

    public static double recall(Object[] references, Object[] predictions) {
        if (references.length > 0) {
            return (double)FMeasure.countTruePositives(references, predictions) / (double)references.length;
        }
        return Double.NaN;
    }
}

