/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.DetokenizerParameter;
import opennlp.tools.formats.ConllXPOSSampleStreamFactory;
import opennlp.tools.formats.POSToSentenceSampleStream;
import opennlp.tools.postag.POSSample;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.tokenize.DetokenizationDictionary;
import opennlp.tools.tokenize.Detokenizer;
import opennlp.tools.tokenize.DictionaryDetokenizer;
import opennlp.tools.util.ObjectStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConllXSentenceSampleStreamFactory
implements ObjectStreamFactory<SentenceSample> {
    @Override
    public String getUsage() {
        return ArgumentParser.createUsage(Parameters.class);
    }

    @Override
    public boolean validateArguments(String[] args) {
        return ArgumentParser.validateArguments(args, Parameters.class);
    }

    @Override
    public ObjectStream<SentenceSample> create(String[] args) {
        DictionaryDetokenizer detokenizer;
        Parameters params = ArgumentParser.parse(args, Parameters.class);
        ObjectStream<POSSample> posSampleStream = new ConllXPOSSampleStreamFactory().create(params);
        try {
            detokenizer = new DictionaryDetokenizer(new DetokenizationDictionary(new FileInputStream(new File(params.getDetokenizer()))));
        }
        catch (IOException e) {
            System.err.println("Error while loading detokenizer dict: " + e.getMessage());
            throw new TerminateToolException(-1);
        }
        return new POSToSentenceSampleStream((Detokenizer)detokenizer, posSampleStream, 30);
    }

    static interface Parameters
    extends ConllXPOSSampleStreamFactory.Parameters,
    DetokenizerParameter {
    }
}

