/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.sentdetect;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import opennlp.tools.cmdline.AbstractConverterTool;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.formats.ConllXSentenceSampleStreamFactory;
import opennlp.tools.formats.NameToSentenceSampleStreamFactory;
import opennlp.tools.formats.POSToSentenceSampleStreamFactory;
import opennlp.tools.sentdetect.SentenceSample;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SentenceDetectorConverterTool
extends AbstractConverterTool<SentenceSample> {
    private static final Map<String, ObjectStreamFactory<SentenceSample>> streamFactories;

    @Override
    public String getName() {
        return "SentenceDetectorConverter";
    }

    @Override
    public String getShortDescription() {
        return "";
    }

    @Override
    protected ObjectStreamFactory<SentenceSample> createStreamFactory(String format) {
        return streamFactories.get(format);
    }

    static {
        HashMap<String, ObjectStreamFactory<SentenceSample>> mutableStreamFactories = new HashMap<String, ObjectStreamFactory<SentenceSample>>();
        mutableStreamFactories.put("conllx", new ConllXSentenceSampleStreamFactory());
        mutableStreamFactories.put("pos", new POSToSentenceSampleStreamFactory());
        mutableStreamFactories.put("namefinder", new NameToSentenceSampleStreamFactory());
        streamFactories = Collections.unmodifiableMap(mutableStreamFactories);
    }
}

