/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.chunker;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.chunker.ChunkerME;
import opennlp.tools.chunker.ChunkerModel;
import opennlp.tools.chunker.DefaultChunkerSequenceValidator;
import opennlp.tools.cmdline.CmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.chunker.ChunkerModelLoader;
import opennlp.tools.postag.POSSample;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.PlainTextByLineStream;

public class ChunkerMETool
implements CmdLineTool {
    public String getName() {
        return "ChunkerME";
    }

    public String getShortDescription() {
        return "learnable chunker";
    }

    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " model < sentences";
    }

    public void run(String[] args) {
        if (args.length != 1) {
            System.out.println(this.getHelp());
            throw new TerminateToolException(1);
        }
        ChunkerModel model = (ChunkerModel)new ChunkerModelLoader().load(new File(args[0]));
        ChunkerME chunker = new ChunkerME(model, 10, new DefaultChunkerSequenceValidator());
        PlainTextByLineStream lineStream = new PlainTextByLineStream(new InputStreamReader(System.in));
        PerformanceMonitor perfMon = new PerformanceMonitor(System.err, "sent");
        perfMon.start();
        try {
            String line;
            while ((line = (String)lineStream.read()) != null) {
                POSSample posSample;
                try {
                    posSample = POSSample.parse(line);
                }
                catch (InvalidFormatException e) {
                    System.err.println("Invalid format:");
                    System.err.println(line);
                    continue;
                }
                String[] chunks = chunker.chunk(posSample.getSentence(), posSample.getTags());
                System.out.println(new ChunkSample(posSample.getSentence(), posSample.getTags(), chunks).toString());
                perfMon.incrementCounter();
            }
        }
        catch (IOException e) {
            CmdLineUtil.handleStdinIoError(e);
        }
        perfMon.stopAndPrintFinalResult();
    }
}

