/*
 * Decompiled with CFR 0.152.
 */
package devliving.online.securedpreferencestore;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.security.KeyPairGeneratorSpec;
import android.security.keystore.KeyGenParameterSpec;
import android.support.annotation.Nullable;
import android.util.Base64;
import devliving.online.securedpreferencestore.SecuredPreferenceStore;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.x500.X500Principal;

public class EncryptionManager {
    private final int RSA_BIT_LENGTH = 2048;
    private final int AES_BIT_LENGTH = 256;
    private final int MAC_BIT_LENGTH = 256;
    private final int GCM_TAG_LENGTH = 128;
    private static final String DEFAULT_CHARSET = "UTF-8";
    private final String KEYSTORE_PROVIDER = "AndroidKeyStore";
    private final String SSL_PROVIDER = "AndroidOpenSSL";
    private final String BOUNCY_CASTLE_PROVIDER = "BC";
    private final byte[] SHIFTING_KEY;
    private final String RSA_KEY_ALIAS;
    protected final String AES_KEY_ALIAS;
    protected final String MAC_KEY_ALIAS;
    private static final String RSA_KEY_ALIAS_NAME = "rsa_key";
    private static final String AES_KEY_ALIAS_NAME = "aes_key";
    private static final String MAC_KEY_ALIAS_NAME = "mac_key";
    protected static final String OVERRIDING_KEY_ALIAS_PREFIX_NAME = "OverridingAlias";
    protected static final String DEFAULT_KEY_ALIAS_PREFIX = "sps";
    private final String DELIMITER = "]";
    private static final String KEY_ALGORITHM_AES = "AES";
    private static final String KEY_ALGORITHM_RSA = "RSA";
    private static final String BLOCK_MODE_ECB = "ECB";
    private static final String BLOCK_MODE_GCM = "GCM";
    private static final String BLOCK_MODE_CBC = "CBC";
    private static final String ENCRYPTION_PADDING_RSA_PKCS1 = "PKCS1Padding";
    private static final String ENCRYPTION_PADDING_PKCS7 = "PKCS7Padding";
    private static final String ENCRYPTION_PADDING_NONE = "NoPadding";
    private static final String MAC_ALGORITHM_HMAC_SHA256 = "HmacSHA256";
    private final String RSA_CIPHER = "RSA/ECB/PKCS1Padding";
    private final String AES_CIPHER = "AES/GCM/NoPadding";
    private final String AES_CIPHER_COMPAT = "AES/CBC/PKCS7Padding";
    private final String MAC_CIPHER = "HmacSHA256";
    protected final String IS_COMPAT_MODE_KEY_ALIAS;
    private static final String IS_COMPAT_MODE_KEY_ALIAS_NAME = "data_in_compat";
    private KeyStore mStore;
    private SecretKey aesKey;
    private SecretKey macKey;
    private RSAPublicKey publicKey;
    private RSAPrivateKey privateKey;
    private String mKeyAliasPrefix;
    private boolean isCompatMode = false;
    private Context mContext;
    SharedPreferences mPrefs;
    SecuredPreferenceStore.KeyStoreRecoveryNotifier mRecoveryHandler;

    public EncryptionManager(Context context, SharedPreferences prefStore, SecuredPreferenceStore.KeyStoreRecoveryNotifier recoveryNotifier) throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException, UnrecoverableEntryException, InvalidAlgorithmParameterException, NoSuchPaddingException, InvalidKeyException, NoSuchProviderException {
        this(context, prefStore, null, null, recoveryNotifier);
    }

    public EncryptionManager(Context context, SharedPreferences prefStore, @Nullable String keyAliasPrefix, @Nullable byte[] bitShiftingKey, SecuredPreferenceStore.KeyStoreRecoveryNotifier recoveryHandler) throws IOException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, NoSuchProviderException, NoSuchPaddingException, CertificateException, KeyStoreException, UnrecoverableEntryException, InvalidKeyException, IllegalStateException {
        this.SHIFTING_KEY = bitShiftingKey;
        keyAliasPrefix = prefStore.getString(EncryptionManager.getHashed(OVERRIDING_KEY_ALIAS_PREFIX_NAME), keyAliasPrefix);
        this.mKeyAliasPrefix = keyAliasPrefix != null ? keyAliasPrefix : DEFAULT_KEY_ALIAS_PREFIX;
        this.IS_COMPAT_MODE_KEY_ALIAS = String.format("%s_%s", this.mKeyAliasPrefix, IS_COMPAT_MODE_KEY_ALIAS_NAME);
        this.RSA_KEY_ALIAS = String.format("%s_%s", this.mKeyAliasPrefix, RSA_KEY_ALIAS_NAME);
        this.AES_KEY_ALIAS = String.format("%s_%s", this.mKeyAliasPrefix, AES_KEY_ALIAS_NAME);
        this.MAC_KEY_ALIAS = String.format("%s_%s", this.mKeyAliasPrefix, MAC_KEY_ALIAS_NAME);
        String isCompatKey = EncryptionManager.getHashed(this.IS_COMPAT_MODE_KEY_ALIAS);
        this.isCompatMode = prefStore.getBoolean(isCompatKey, Build.VERSION.SDK_INT < 23);
        this.mRecoveryHandler = recoveryHandler;
        this.mContext = context;
        this.mPrefs = prefStore;
        this.loadKeyStore();
        boolean tryAgain = false;
        try {
            this.setup(context, prefStore, bitShiftingKey);
        }
        catch (Exception ex) {
            if (this.isRecoverableError(ex)) {
                tryAgain = this.tryRecovery(ex);
            }
            throw ex;
        }
        if (tryAgain) {
            this.setup(context, prefStore, bitShiftingKey);
        }
    }

    <T extends Exception> boolean isRecoverableError(T error) {
        return error instanceof KeyStoreException || error instanceof UnrecoverableEntryException || error instanceof InvalidKeyException || error instanceof IllegalStateException || error instanceof IOException && error.getCause() != null && error.getCause() instanceof BadPaddingException;
    }

    void setup(Context context, SharedPreferences prefStore, @Nullable byte[] seed) throws NoSuchPaddingException, InvalidKeyException, NoSuchAlgorithmException, KeyStoreException, UnrecoverableEntryException, NoSuchProviderException, InvalidAlgorithmParameterException, IOException {
        boolean keyGenerated = this.generateKey(context, seed, prefStore);
        if (keyGenerated) {
            this.mPrefs.edit().putString(EncryptionManager.getHashed(OVERRIDING_KEY_ALIAS_PREFIX_NAME), this.mKeyAliasPrefix).commit();
        }
        this.loadKey(prefStore);
    }

    <T extends Exception> boolean tryRecovery(T e) {
        return this.mRecoveryHandler != null && this.mRecoveryHandler.onRecoveryRequired(e, this.mStore, this.keyAliases());
    }

    List<String> keyAliases() {
        return Arrays.asList(this.AES_KEY_ALIAS, this.RSA_KEY_ALIAS);
    }

    public EncryptedData tryEncrypt(byte[] bytes) throws NoSuchPaddingException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException, BadPaddingException, IllegalBlockSizeException, NoSuchProviderException, InvalidKeyException, KeyStoreException, UnrecoverableEntryException {
        EncryptedData result = null;
        boolean tryAgain = false;
        try {
            result = this.encrypt(bytes);
        }
        catch (Exception ex) {
            if (this.isRecoverableError(ex)) {
                tryAgain = this.tryRecovery(ex);
            }
            throw ex;
        }
        if (tryAgain) {
            this.setup(this.mContext, this.mPrefs, null);
            result = this.encrypt(bytes);
        }
        return result;
    }

    public byte[] tryDecrypt(EncryptedData data) throws NoSuchPaddingException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, KeyStoreException, UnrecoverableEntryException, NoSuchProviderException, InvalidKeyException, IOException, BadPaddingException, IllegalBlockSizeException, InvalidMacException {
        byte[] result = null;
        boolean tryAgain = false;
        try {
            result = this.decrypt(data);
        }
        catch (Exception ex) {
            if (this.isRecoverableError(ex)) {
                tryAgain = this.tryRecovery(ex);
            }
            throw ex;
        }
        if (tryAgain) {
            this.setup(this.mContext, this.mPrefs, null);
            result = this.decrypt(data);
        }
        return result;
    }

    public EncryptedData encrypt(byte[] bytes) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, IOException, BadPaddingException, NoSuchProviderException, IllegalBlockSizeException, InvalidAlgorithmParameterException {
        if (bytes != null && bytes.length > 0) {
            byte[] IV = this.getIV();
            if (this.isCompatMode) {
                return this.encryptAESCompat(bytes, IV);
            }
            return this.encryptAES(bytes, IV);
        }
        return null;
    }

    public byte[] decrypt(EncryptedData data) throws IOException, NoSuchPaddingException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException, InvalidMacException, NoSuchProviderException, InvalidKeyException {
        if (data != null && data.encryptedData != null) {
            if (this.isCompatMode) {
                return this.decryptAESCompat(data);
            }
            return this.decryptAES(data);
        }
        return null;
    }

    String encrypt(String text) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, NoSuchProviderException, BadPaddingException, KeyStoreException, UnrecoverableEntryException {
        if (text != null && text.length() > 0) {
            EncryptedData encrypted = this.tryEncrypt(text.getBytes(DEFAULT_CHARSET));
            return this.encodeEncryptedData(encrypted);
        }
        return null;
    }

    String decrypt(String text) throws IOException, NoSuchPaddingException, InvalidKeyException, NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException, InvalidMacException, NoSuchProviderException, InvalidAlgorithmParameterException, KeyStoreException, UnrecoverableEntryException {
        if (text != null && text.length() > 0) {
            EncryptedData encryptedData = this.decodeEncryptedText(text);
            byte[] decrypted = this.tryDecrypt(encryptedData);
            return new String(decrypted, 0, decrypted.length, DEFAULT_CHARSET);
        }
        return null;
    }

    public static String getHashed(String text) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] result = digest.digest(text.getBytes(DEFAULT_CHARSET));
        return EncryptionManager.toHex(result);
    }

    static String toHex(byte[] data) {
        StringBuilder sb = new StringBuilder();
        for (byte b : data) {
            sb.append(String.format("%02X", b));
        }
        return sb.toString();
    }

    public static String base64Encode(byte[] data) {
        return Base64.encodeToString((byte[])data, (int)2);
    }

    public static byte[] base64Decode(String text) {
        return Base64.decode((String)text, (int)2);
    }

    String encodeEncryptedData(EncryptedData data) {
        if (data.mac != null) {
            return EncryptionManager.base64Encode(data.IV) + "]" + EncryptionManager.base64Encode(data.encryptedData) + "]" + EncryptionManager.base64Encode(data.mac);
        }
        return EncryptionManager.base64Encode(data.IV) + "]" + EncryptionManager.base64Encode(data.encryptedData);
    }

    EncryptedData decodeEncryptedText(String text) {
        EncryptedData result = new EncryptedData();
        String[] parts = text.split("]");
        result.IV = EncryptionManager.base64Decode(parts[0]);
        result.encryptedData = EncryptionManager.base64Decode(parts[1]);
        if (parts.length > 2) {
            result.mac = EncryptionManager.base64Decode(parts[2]);
        }
        return result;
    }

    void loadKeyStore() throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        this.mStore = KeyStore.getInstance("AndroidKeyStore");
        this.mStore.load(null);
    }

    byte[] getIV() throws UnsupportedEncodingException {
        byte[] iv = !this.isCompatMode ? new byte[12] : new byte[16];
        SecureRandom rng = new SecureRandom();
        rng.nextBytes(iv);
        return iv;
    }

    @TargetApi(value=19)
    EncryptedData encryptAES(byte[] bytes, byte[] IV) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, UnsupportedEncodingException {
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(1, (Key)this.aesKey, new GCMParameterSpec(128, IV));
        EncryptedData result = new EncryptedData();
        result.IV = cipher.getIV();
        result.encryptedData = cipher.doFinal(bytes);
        return result;
    }

    @TargetApi(value=19)
    byte[] decryptAES(EncryptedData encryptedData) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, UnsupportedEncodingException {
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(2, (Key)this.aesKey, new GCMParameterSpec(128, encryptedData.IV));
        return cipher.doFinal(encryptedData.encryptedData);
    }

    EncryptedData encryptAESCompat(byte[] bytes, byte[] IV) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, UnsupportedEncodingException, InvalidAlgorithmParameterException {
        Cipher c = Cipher.getInstance("AES/CBC/PKCS7Padding", "BC");
        c.init(1, (Key)this.aesKey, new IvParameterSpec(IV));
        EncryptedData result = new EncryptedData();
        result.IV = c.getIV();
        result.encryptedData = c.doFinal(bytes);
        result.mac = this.computeMac(result.getDataForMacComputation());
        return result;
    }

    byte[] decryptAESCompat(EncryptedData encryptedData) throws UnsupportedEncodingException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, NoSuchPaddingException, InvalidAlgorithmParameterException, BadPaddingException, IllegalBlockSizeException, InvalidMacException {
        if (this.verifyMac(encryptedData.mac, encryptedData.getDataForMacComputation())) {
            Cipher c = Cipher.getInstance("AES/CBC/PKCS7Padding", "BC");
            c.init(2, (Key)this.aesKey, new IvParameterSpec(encryptedData.IV));
            return c.doFinal(encryptedData.encryptedData);
        }
        throw new InvalidMacException();
    }

    void loadKey(SharedPreferences prefStore) throws KeyStoreException, UnrecoverableEntryException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, InvalidKeyException, IOException {
        if (!this.isCompatMode) {
            if (this.mStore.containsAlias(this.AES_KEY_ALIAS) && this.mStore.entryInstanceOf(this.AES_KEY_ALIAS, KeyStore.SecretKeyEntry.class)) {
                KeyStore.SecretKeyEntry entry = (KeyStore.SecretKeyEntry)this.mStore.getEntry(this.AES_KEY_ALIAS, null);
                this.aesKey = entry.getSecretKey();
            }
        } else {
            this.aesKey = this.getFallbackAESKey(prefStore);
            this.macKey = this.getMacKey(prefStore);
        }
    }

    boolean generateKey(Context context, @Nullable byte[] seed, SharedPreferences prefStore) throws KeyStoreException, NoSuchProviderException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, UnrecoverableEntryException, NoSuchPaddingException, InvalidKeyException, IOException {
        boolean keyGenerated = false;
        if (!this.isCompatMode) {
            keyGenerated = this.generateAESKey(seed);
        } else {
            keyGenerated = this.generateRSAKeys(context, seed);
            this.loadRSAKeys();
            keyGenerated = this.generateFallbackAESKey(prefStore, seed) || keyGenerated;
            keyGenerated = this.generateMacKey(prefStore, seed) || keyGenerated;
        }
        return keyGenerated;
    }

    @TargetApi(value=23)
    boolean generateAESKey(@Nullable byte[] seed) throws KeyStoreException, NoSuchProviderException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (!this.mStore.containsAlias(this.AES_KEY_ALIAS)) {
            KeyGenerator keyGen = KeyGenerator.getInstance(KEY_ALGORITHM_AES, "AndroidKeyStore");
            KeyGenParameterSpec spec = new KeyGenParameterSpec.Builder(this.AES_KEY_ALIAS, 3).setCertificateSubject(new X500Principal("CN = Secured Preference Store, O = Devliving Online")).setCertificateSerialNumber(BigInteger.ONE).setKeySize(256).setBlockModes(new String[]{BLOCK_MODE_GCM}).setEncryptionPaddings(new String[]{ENCRYPTION_PADDING_NONE}).setRandomizedEncryptionRequired(false).build();
            if (seed != null && seed.length > 0) {
                SecureRandom random = new SecureRandom(seed);
                keyGen.init((AlgorithmParameterSpec)spec, random);
            } else {
                keyGen.init((AlgorithmParameterSpec)spec);
            }
            keyGen.generateKey();
            return true;
        }
        return false;
    }

    boolean generateFallbackAESKey(SharedPreferences prefStore, @Nullable byte[] seed) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, KeyStoreException, NoSuchProviderException, UnrecoverableEntryException {
        String key = EncryptionManager.getHashed(this.AES_KEY_ALIAS);
        if (!prefStore.contains(key)) {
            KeyGenerator keyGen = KeyGenerator.getInstance(KEY_ALGORITHM_AES);
            if (seed != null && seed.length > 0) {
                SecureRandom random = new SecureRandom(seed);
                keyGen.init(256, random);
            } else {
                keyGen.init(256);
            }
            SecretKey sKey = keyGen.generateKey();
            byte[] shiftedEncodedKey = this.xorWithKey(sKey.getEncoded(), this.SHIFTING_KEY);
            byte[] encryptedData = this.RSAEncrypt(shiftedEncodedKey);
            String AESKey = EncryptionManager.base64Encode(encryptedData);
            boolean result = prefStore.edit().putString(key, AESKey).commit();
            String isCompatKey = EncryptionManager.getHashed(this.IS_COMPAT_MODE_KEY_ALIAS);
            prefStore.edit().putBoolean(isCompatKey, true).apply();
            return result;
        }
        return false;
    }

    boolean generateMacKey(SharedPreferences prefStore, @Nullable byte[] seed) throws NoSuchPaddingException, InvalidKeyException, NoSuchAlgorithmException, KeyStoreException, NoSuchProviderException, UnrecoverableEntryException, IOException {
        String key = EncryptionManager.getHashed(this.MAC_KEY_ALIAS);
        if (!prefStore.contains(key)) {
            byte[] randomBytes = new byte[32];
            SecureRandom rng = seed != null && seed.length > 0 ? new SecureRandom(seed) : new SecureRandom();
            rng.nextBytes(randomBytes);
            byte[] encryptedKey = this.RSAEncrypt(randomBytes);
            String macKey = EncryptionManager.base64Encode(encryptedKey);
            return prefStore.edit().putString(key, macKey).commit();
        }
        return false;
    }

    private byte[] xorWithKey(byte[] a, byte[] key) {
        if (key == null || key.length == 0) {
            return a;
        }
        byte[] out = new byte[a.length];
        for (int i = 0; i < a.length; ++i) {
            out[i] = (byte)(a[i] ^ key[i % key.length]);
        }
        return out;
    }

    SecretKey getFallbackAESKey(SharedPreferences prefStore) throws IOException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, NoSuchPaddingException {
        String key = EncryptionManager.getHashed(this.AES_KEY_ALIAS);
        String base64Value = prefStore.getString(key, null);
        if (base64Value != null) {
            byte[] encryptedData = EncryptionManager.base64Decode(base64Value);
            byte[] shiftedEncodedKey = this.RSADecrypt(encryptedData);
            byte[] keyData = this.xorWithKey(shiftedEncodedKey, this.SHIFTING_KEY);
            return new SecretKeySpec(keyData, KEY_ALGORITHM_AES);
        }
        return null;
    }

    SecretKey getMacKey(SharedPreferences prefStore) throws IOException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, NoSuchPaddingException {
        String key = EncryptionManager.getHashed(this.MAC_KEY_ALIAS);
        String base64 = prefStore.getString(key, null);
        if (base64 != null) {
            byte[] encryptedKey = EncryptionManager.base64Decode(base64);
            byte[] keyData = this.RSADecrypt(encryptedKey);
            return new SecretKeySpec(keyData, MAC_ALGORITHM_HMAC_SHA256);
        }
        return null;
    }

    void loadRSAKeys() throws KeyStoreException, UnrecoverableEntryException, NoSuchAlgorithmException {
        if (this.mStore.containsAlias(this.RSA_KEY_ALIAS) && this.mStore.entryInstanceOf(this.RSA_KEY_ALIAS, KeyStore.PrivateKeyEntry.class)) {
            KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)this.mStore.getEntry(this.RSA_KEY_ALIAS, null);
            this.publicKey = (RSAPublicKey)entry.getCertificate().getPublicKey();
            this.privateKey = (RSAPrivateKey)entry.getPrivateKey();
        }
    }

    boolean generateRSAKeys(Context context, @Nullable byte[] seed) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, KeyStoreException {
        if (!this.mStore.containsAlias(this.RSA_KEY_ALIAS)) {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance(KEY_ALGORITHM_RSA, "AndroidKeyStore");
            Calendar start = Calendar.getInstance();
            start.add(11, -26);
            Calendar end = Calendar.getInstance();
            end.add(1, 100);
            KeyPairGeneratorSpec spec = Build.VERSION.SDK_INT >= 19 ? new KeyPairGeneratorSpec.Builder(context).setAlias(this.RSA_KEY_ALIAS).setKeySize(2048).setKeyType(KEY_ALGORITHM_RSA).setSerialNumber(BigInteger.ONE).setSubject(new X500Principal("CN = Secured Preference Store, O = Devliving Online")).setStartDate(start.getTime()).setEndDate(end.getTime()).build() : new KeyPairGeneratorSpec.Builder(context).setAlias(this.RSA_KEY_ALIAS).setSerialNumber(BigInteger.ONE).setSubject(new X500Principal("CN = Secured Preference Store, O = Devliving Online")).setStartDate(start.getTime()).setEndDate(end.getTime()).build();
            if (seed != null && seed.length > 0) {
                SecureRandom random = new SecureRandom(seed);
                keyGen.initialize((AlgorithmParameterSpec)spec, random);
            } else {
                keyGen.initialize((AlgorithmParameterSpec)spec);
            }
            keyGen.generateKeyPair();
            return true;
        }
        return false;
    }

    byte[] computeMac(byte[] data) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac HmacSha256 = Mac.getInstance(MAC_ALGORITHM_HMAC_SHA256);
        HmacSha256.init(this.macKey);
        return HmacSha256.doFinal(data);
    }

    boolean verifyMac(byte[] mac, byte[] data) throws InvalidKeyException, NoSuchAlgorithmException {
        if (mac != null && data != null) {
            byte[] actualMac = this.computeMac(data);
            if (actualMac.length != mac.length) {
                return false;
            }
            int result = 0;
            for (int i = 0; i < actualMac.length; ++i) {
                result |= actualMac[i] ^ mac[i];
            }
            return result == 0;
        }
        return false;
    }

    byte[] RSAEncrypt(byte[] bytes) throws KeyStoreException, UnrecoverableEntryException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, IOException {
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding", "AndroidOpenSSL");
        cipher.init(1, this.publicKey);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        CipherOutputStream cipherOutputStream = new CipherOutputStream(outputStream, cipher);
        cipherOutputStream.write(bytes);
        cipherOutputStream.close();
        return outputStream.toByteArray();
    }

    byte[] RSADecrypt(byte[] bytes) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, IOException {
        int nextByte;
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding", "AndroidOpenSSL");
        cipher.init(2, this.privateKey);
        CipherInputStream cipherInputStream = new CipherInputStream(new ByteArrayInputStream(bytes), cipher);
        ArrayList<Byte> values = new ArrayList<Byte>();
        while ((nextByte = cipherInputStream.read()) != -1) {
            values.add((byte)nextByte);
        }
        byte[] dbytes = new byte[values.size()];
        for (int i = 0; i < dbytes.length; ++i) {
            dbytes[i] = (Byte)values.get(i);
        }
        cipherInputStream.close();
        return dbytes;
    }

    public class InvalidMacException
    extends GeneralSecurityException {
        public InvalidMacException() {
            super("Invalid Mac, failed to verify integrity.");
        }
    }

    public static class EncryptedData {
        byte[] IV;
        byte[] encryptedData;
        byte[] mac;

        public EncryptedData() {
            this.IV = null;
            this.encryptedData = null;
            this.mac = null;
        }

        public EncryptedData(byte[] IV, byte[] encryptedData, byte[] mac) {
            this.IV = IV;
            this.encryptedData = encryptedData;
            this.mac = mac;
        }

        public byte[] getIV() {
            return this.IV;
        }

        public void setIV(byte[] IV) {
            this.IV = IV;
        }

        public byte[] getEncryptedData() {
            return this.encryptedData;
        }

        public void setEncryptedData(byte[] encryptedData) {
            this.encryptedData = encryptedData;
        }

        public byte[] getMac() {
            return this.mac;
        }

        public void setMac(byte[] mac) {
            this.mac = mac;
        }

        byte[] getDataForMacComputation() {
            byte[] combinedData = new byte[this.IV.length + this.encryptedData.length];
            System.arraycopy(this.IV, 0, combinedData, 0, this.IV.length);
            System.arraycopy(this.encryptedData, 0, combinedData, this.IV.length, this.encryptedData.length);
            return combinedData;
        }
    }
}

