/*
 * Decompiled with CFR 0.152.
 */
package devliving.online.securedpreferencestore;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import devliving.online.securedpreferencestore.EncryptionManager;
import devliving.online.securedpreferencestore.RecoveryHandler;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.NoSuchPaddingException;

public class SecuredPreferenceStore
implements SharedPreferences {
    private final String PREF_FILE_NAME = "SPS_file";
    private SharedPreferences mPrefs;
    private EncryptionManager mEncryptionManager;
    private static RecoveryHandler mRecoveryHandler;
    private static SecuredPreferenceStore mInstance;

    private SecuredPreferenceStore(Context appContext) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, UnrecoverableEntryException, NoSuchProviderException, InvalidAlgorithmParameterException, IOException, NoSuchPaddingException, InvalidKeyException {
        Log.d((String)"SECURE-PREFERENCE", (String)"Creating store instance");
        this.mPrefs = appContext.getSharedPreferences("SPS_file", 0);
        this.mEncryptionManager = new EncryptionManager(appContext, this.mPrefs, new KeyStoreRecoveryNotifier(){

            @Override
            public void onRecoveryRequired(Exception e, KeyStore keyStore, List<String> keyAliases) {
                if (mRecoveryHandler == null) {
                    throw new RuntimeException(e);
                }
                mRecoveryHandler.recover(e, keyStore, keyAliases, SecuredPreferenceStore.this.mPrefs);
            }
        });
    }

    public static void setRecoveryHandler(RecoveryHandler recoveryHandler) {
        mRecoveryHandler = recoveryHandler;
    }

    public static synchronized SecuredPreferenceStore getSharedInstance(Context appContext) throws IOException, CertificateException, NoSuchAlgorithmException, InvalidKeyException, UnrecoverableEntryException, InvalidAlgorithmParameterException, NoSuchPaddingException, NoSuchProviderException, KeyStoreException {
        if (mInstance == null) {
            mInstance = new SecuredPreferenceStore(appContext);
        }
        return mInstance;
    }

    public EncryptionManager getEncryptionManager() {
        return this.mEncryptionManager;
    }

    public Map<String, String> getAll() {
        Map all = this.mPrefs.getAll();
        HashMap<String, String> dAll = new HashMap<String, String>(all.size());
        if (all.size() > 0) {
            for (String key : all.keySet()) {
                try {
                    dAll.put(key, this.mEncryptionManager.decrypt((String)all.get(key)));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return dAll;
    }

    public String getString(String s, String s1) {
        try {
            String key = EncryptionManager.getHashed(s);
            String value = this.mPrefs.getString(key, null);
            if (value != null) {
                return this.mEncryptionManager.decrypt(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return s1;
    }

    public Set<String> getStringSet(String s, Set<String> set) {
        try {
            String key = EncryptionManager.getHashed(s);
            Set eSet = this.mPrefs.getStringSet(key, null);
            if (eSet != null) {
                HashSet<String> dSet = new HashSet<String>(eSet.size());
                for (String val : eSet) {
                    dSet.add(this.mEncryptionManager.decrypt(val));
                }
                return dSet;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return set;
    }

    public int getInt(String s, int i) {
        String value = this.getString(s, null);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return i;
    }

    public long getLong(String s, long l) {
        String value = this.getString(s, null);
        if (value != null) {
            return Long.parseLong(value);
        }
        return l;
    }

    public float getFloat(String s, float v) {
        String value = this.getString(s, null);
        if (value != null) {
            return Float.parseFloat(value);
        }
        return v;
    }

    public boolean getBoolean(String s, boolean b) {
        String value = this.getString(s, null);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return b;
    }

    public byte[] getBytes(String s) {
        String val = this.getString(s, null);
        if (val != null) {
            return EncryptionManager.base64Decode(val);
        }
        return null;
    }

    public boolean contains(String s) {
        try {
            String key = EncryptionManager.getHashed(s);
            return this.mPrefs.contains(key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Editor edit() {
        return new Editor();
    }

    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener onSharedPreferenceChangeListener) {
        if (this.mPrefs != null) {
            this.mPrefs.registerOnSharedPreferenceChangeListener(onSharedPreferenceChangeListener);
        }
    }

    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener onSharedPreferenceChangeListener) {
        if (this.mPrefs != null) {
            this.mPrefs.unregisterOnSharedPreferenceChangeListener(onSharedPreferenceChangeListener);
        }
    }

    public static interface KeyStoreRecoveryNotifier {
        public void onRecoveryRequired(Exception var1, KeyStore var2, List<String> var3);
    }

    public class Editor
    implements SharedPreferences.Editor {
        SharedPreferences.Editor mEditor;

        public Editor() {
            this.mEditor = SecuredPreferenceStore.this.mPrefs.edit();
        }

        public SharedPreferences.Editor putString(String s, String s1) {
            try {
                String key = EncryptionManager.getHashed(s);
                String value = SecuredPreferenceStore.this.mEncryptionManager.encrypt(s1);
                this.mEditor.putString(key, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return this;
        }

        public SharedPreferences.Editor putStringSet(String s, Set<String> set) {
            try {
                String key = EncryptionManager.getHashed(s);
                HashSet<String> eSet = new HashSet<String>(set.size());
                for (String val : set) {
                    eSet.add(SecuredPreferenceStore.this.mEncryptionManager.encrypt(val));
                }
                this.mEditor.putStringSet(key, eSet);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return this;
        }

        public SharedPreferences.Editor putInt(String s, int i) {
            String val = Integer.toString(i);
            return this.putString(s, val);
        }

        public SharedPreferences.Editor putLong(String s, long l) {
            String val = Long.toString(l);
            return this.putString(s, val);
        }

        public SharedPreferences.Editor putFloat(String s, float v) {
            String val = Float.toString(v);
            return this.putString(s, val);
        }

        public SharedPreferences.Editor putBoolean(String s, boolean b) {
            String val = Boolean.toString(b);
            return this.putString(s, val);
        }

        public SharedPreferences.Editor putBytes(String s, byte[] bytes) {
            if (bytes != null) {
                String val = EncryptionManager.base64Encode(bytes);
                return this.putString(s, val);
            }
            return this.remove(s);
        }

        public SharedPreferences.Editor remove(String s) {
            try {
                String key = EncryptionManager.getHashed(s);
                this.mEditor.remove(key);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return this;
        }

        public SharedPreferences.Editor clear() {
            this.mEditor.clear();
            return this;
        }

        public boolean commit() {
            return this.mEditor.commit();
        }

        public void apply() {
            this.mEditor.apply();
        }
    }
}

