/*
 * Decompiled with CFR 0.152.
 */
package devliving.online.securedpreferencestore;

import android.content.SharedPreferences;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class RecoveryHandler {
    protected abstract void recover(Exception var1, KeyStore var2, List<String> var3, SharedPreferences var4);

    void clearKeyStore(KeyStore keyStore, List<String> aliases) throws KeyStoreException {
        if (keyStore != null && aliases != null) {
            for (String alias : aliases) {
                if (!keyStore.containsAlias(alias)) continue;
                keyStore.deleteEntry(alias);
            }
        }
    }

    void clearKeystore(KeyStore keyStore) throws KeyStoreException {
        if (keyStore != null) {
            ArrayList<String> aliases = Collections.list(keyStore.aliases());
            for (String alias : aliases) {
                if (!keyStore.containsAlias(alias)) continue;
                keyStore.deleteEntry(alias);
            }
        }
    }

    void clearPreferences(SharedPreferences preferences) {
        if (preferences != null) {
            preferences.edit().clear().apply();
        }
    }

    public static interface RecoveryCallback {
        public void onRecoveryDone();

        public void onRecoveryFailed(Exception var1);
    }
}

