/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import one.util.streamex.StreamExInternals;

public class Joining
extends StreamExInternals.CancellableCollector<CharSequence, Accumulator, String> {
    private static final int CUT_ANYWHERE = 0;
    private static final int CUT_CODEPOINT = 1;
    private static final int CUT_GRAPHEME = 2;
    private static final int CUT_WORD = 3;
    private static final int CUT_BEFORE_DELIMITER = 4;
    private static final int CUT_AFTER_DELIMITER = 5;
    private static final int LENGTH_CHARS = 0;
    private static final int LENGTH_CODEPOINTS = 1;
    private static final int LENGTH_GRAPHEMES = 2;
    private static final int LENGTH_ELEMENTS = 3;
    private final String delimiter;
    private final String ellipsis;
    private final String prefix;
    private final String suffix;
    private final int cutStrategy;
    private final int lenStrategy;
    private final int maxLength;
    private int limit;
    private int delimCount = -1;

    private Joining(String delimiter, String ellipsis, String prefix, String suffix, int cutStrategy, int lenStrategy, int maxLength) {
        this.delimiter = delimiter;
        this.ellipsis = ellipsis;
        this.prefix = prefix;
        this.suffix = suffix;
        this.cutStrategy = cutStrategy;
        this.lenStrategy = lenStrategy;
        this.maxLength = maxLength;
    }

    private void init() {
        if (this.delimCount == -1) {
            this.limit = this.maxLength - this.length(this.prefix, false) - this.length(this.suffix, false);
            this.delimCount = this.length(this.delimiter, false);
        }
    }

    private int length(CharSequence s, boolean content) {
        switch (this.lenStrategy) {
            case 0: {
                return s.length();
            }
            case 1: {
                if (s instanceof String) {
                    return ((String)s).codePointCount(0, s.length());
                }
                return (int)s.codePoints().count();
            }
            case 2: {
                BreakIterator bi = BreakIterator.getCharacterInstance();
                bi.setText(s.toString());
                int count = 0;
                int end = bi.next();
                while (end != -1) {
                    ++count;
                    end = bi.next();
                }
                return count;
            }
            case 3: {
                return content ? 1 : 0;
            }
        }
        throw new InternalError();
    }

    private static int copy(char[] buf, int pos, String str) {
        str.getChars(0, str.length(), buf, pos);
        return pos + str.length();
    }

    private int copyCut(char[] buf, int pos, String str, int limit, int cutStrategy) {
        BreakIterator bi;
        if (limit <= 0) {
            return pos;
        }
        int endPos = str.length();
        block0 : switch (this.lenStrategy) {
            case 0: {
                if (limit >= str.length()) break;
                endPos = limit;
                break;
            }
            case 1: {
                if (limit >= str.codePointCount(0, str.length())) break;
                endPos = str.offsetByCodePoints(0, limit);
                break;
            }
            case 2: {
                int end;
                bi = BreakIterator.getCharacterInstance();
                bi.setText(str);
                int count = limit;
                while ((end = bi.next()) != -1) {
                    if (--count != 0) continue;
                    endPos = end;
                    break block0;
                }
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        if (endPos < str.length()) {
            switch (cutStrategy) {
                case 4: 
                case 5: {
                    endPos = 0;
                    break;
                }
                case 3: {
                    bi = BreakIterator.getWordInstance();
                    bi.setText(str);
                    endPos = bi.preceding(endPos + 1);
                    break;
                }
                case 2: {
                    bi = BreakIterator.getCharacterInstance();
                    bi.setText(str);
                    endPos = bi.preceding(endPos + 1);
                    break;
                }
                case 0: {
                    break;
                }
                case 1: {
                    if (!Character.isHighSurrogate(str.charAt(endPos - 1)) || !Character.isLowSurrogate(str.charAt(endPos))) break;
                    --endPos;
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        }
        str.getChars(0, endPos, buf, pos);
        return pos + endPos;
    }

    private String finisherNoOverflow(Accumulator acc) {
        char[] buf = new char[acc.chars + this.prefix.length() + this.suffix.length()];
        int size = acc.data.size();
        int pos = Joining.copy(buf, 0, this.prefix);
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                pos = Joining.copy(buf, pos, this.delimiter);
            }
            pos = Joining.copy(buf, pos, acc.data.get(i).toString());
        }
        Joining.copy(buf, pos, this.suffix);
        return new String(buf);
    }

    private Joining withLimit(int lenStrategy, int maxLength) {
        StreamExInternals.checkNonNegative("Length", maxLength);
        return new Joining(this.delimiter, this.ellipsis, this.prefix, this.suffix, this.cutStrategy, lenStrategy, maxLength);
    }

    private Joining withCut(int cutStrategy) {
        return new Joining(this.delimiter, this.ellipsis, this.prefix, this.suffix, cutStrategy, this.lenStrategy, this.maxLength);
    }

    public static Joining with(CharSequence delimiter) {
        return new Joining(delimiter.toString(), "...", "", "", 2, 0, -1);
    }

    public Joining wrap(CharSequence prefix, CharSequence suffix) {
        return new Joining(this.delimiter, this.ellipsis, prefix.toString().concat(this.prefix), this.suffix.concat(suffix.toString()), this.cutStrategy, this.lenStrategy, this.maxLength);
    }

    public Joining ellipsis(CharSequence ellipsis) {
        return new Joining(this.delimiter, ellipsis.toString(), this.prefix, this.suffix, this.cutStrategy, this.lenStrategy, this.maxLength);
    }

    public Joining maxChars(int limit) {
        return this.withLimit(0, limit);
    }

    public Joining maxCodePoints(int limit) {
        return this.withLimit(1, limit);
    }

    public Joining maxGraphemes(int limit) {
        return this.withLimit(2, limit);
    }

    public Joining maxElements(int limit) {
        return this.withLimit(3, limit);
    }

    public Joining cutAnywhere() {
        return this.withCut(0);
    }

    public Joining cutAtCodePoint() {
        return this.withCut(1);
    }

    public Joining cutAtGrapheme() {
        return this.withCut(2);
    }

    public Joining cutAtWord() {
        return this.withCut(3);
    }

    public Joining cutBeforeDelimiter() {
        return this.withCut(4);
    }

    public Joining cutAfterDelimiter() {
        return this.withCut(5);
    }

    @Override
    public Supplier<Accumulator> supplier() {
        return Accumulator::new;
    }

    @Override
    public BiConsumer<Accumulator, CharSequence> accumulator() {
        if (this.maxLength == -1) {
            return (acc, str) -> {
                if (!acc.data.isEmpty()) {
                    acc.chars += this.delimiter.length();
                }
                acc.chars += str.length();
                acc.data.add((CharSequence)str);
            };
        }
        this.init();
        return (acc, str) -> {
            if (acc.count <= this.limit) {
                if (!acc.data.isEmpty()) {
                    acc.chars += this.delimiter.length();
                    acc.count += this.delimCount;
                }
                acc.chars += str.length();
                acc.count += this.length((CharSequence)str, true);
                acc.data.add((CharSequence)str);
            }
        };
    }

    @Override
    public BinaryOperator<Accumulator> combiner() {
        if (this.maxLength == -1) {
            return (acc1, acc2) -> {
                if (acc1.data.isEmpty()) {
                    return acc2;
                }
                if (acc2.data.isEmpty()) {
                    return acc1;
                }
                acc1.chars += this.delimiter.length() + acc2.chars;
                acc1.data.addAll(acc2.data);
                return acc1;
            };
        }
        this.init();
        BiConsumer<Accumulator, CharSequence> accumulator = this.accumulator();
        return (acc1, acc2) -> {
            if (acc1.data.isEmpty()) {
                return acc2;
            }
            if (acc2.data.isEmpty()) {
                return acc1;
            }
            int len = acc1.count + acc2.count + this.delimCount;
            if (len <= this.limit) {
                acc1.count = len;
                acc1.chars += this.delimiter.length() + acc2.chars;
                acc1.data.addAll(acc2.data);
            } else {
                for (CharSequence s : acc2.data) {
                    if (acc1.count > this.limit) break;
                    accumulator.accept((Accumulator)acc1, s);
                }
            }
            return acc1;
        };
    }

    @Override
    public Function<Accumulator, String> finisher() {
        if (this.maxLength == -1) {
            return this::finisherNoOverflow;
        }
        this.init();
        if (this.limit <= 0 && this.lenStrategy != 3) {
            char[] buf = new char[this.prefix.length() + this.suffix.length()];
            int pos = this.copyCut(buf, 0, this.prefix, this.maxLength, this.cutStrategy);
            pos = this.copyCut(buf, pos, this.suffix, this.maxLength - this.length(this.prefix, false), this.cutStrategy);
            String result = new String(buf, 0, pos);
            return acc -> result;
        }
        return acc -> {
            if (acc.count <= this.limit) {
                return this.finisherNoOverflow((Accumulator)acc);
            }
            char[] buf = new char[acc.chars + this.prefix.length() + this.suffix.length()];
            int size = acc.data.size();
            int pos = Joining.copy(buf, 0, this.prefix);
            int ellipsisCount = this.length(this.ellipsis, false);
            int rest = this.limit - ellipsisCount;
            if (rest < 0) {
                pos = this.copyCut(buf, pos, this.ellipsis, this.limit, 0);
            } else {
                for (int i = 0; i < size; ++i) {
                    String s = acc.data.get(i).toString();
                    int count = this.length(s, true);
                    if (i > 0) {
                        if (this.cutStrategy == 4 && this.delimCount + count > rest) break;
                        if (this.delimCount > rest) {
                            pos = this.copyCut(buf, pos, this.delimiter, rest, this.cutStrategy);
                            break;
                        }
                        rest -= this.delimCount;
                        pos = Joining.copy(buf, pos, this.delimiter);
                    }
                    if (this.cutStrategy == 5 && this.delimCount + count > rest) break;
                    if (count > rest) {
                        pos = this.copyCut(buf, pos, s, rest, this.cutStrategy);
                        break;
                    }
                    pos = Joining.copy(buf, pos, s);
                    rest -= count;
                }
                pos = Joining.copy(buf, pos, this.ellipsis);
            }
            pos = Joining.copy(buf, pos, this.suffix);
            return new String(buf, 0, pos);
        };
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        this.init();
        if (this.limit <= 0) {
            return Collections.singleton(Collector.Characteristics.UNORDERED);
        }
        return Collections.emptySet();
    }

    @Override
    Predicate<Accumulator> finished() {
        if (this.maxLength == -1) {
            return null;
        }
        this.init();
        if (this.limit <= 0 && this.lenStrategy != 3) {
            return acc -> true;
        }
        return acc -> acc.count > this.limit;
    }

    static final class Accumulator {
        final List<CharSequence> data = new ArrayList<CharSequence>();
        int chars = 0;
        int count = 0;

        Accumulator() {
        }
    }
}

