/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.util.Spliterator;
import java.util.function.Consumer;

class CharSpliterator
implements Spliterator<String> {
    private final CharSequence source;
    private final char delimiter;
    private int pos;
    private final int fence;
    private int nEmpty;
    private String next;
    private final boolean trimEmpty;

    CharSpliterator(CharSequence source, char delimiter, boolean trimEmpty) {
        this(source, delimiter, 0, source.length(), trimEmpty, 0, null);
    }

    private CharSpliterator(CharSequence source, char delimiter, int pos, int fence, boolean trimEmpty, int nEmpty, String next) {
        this.source = source;
        this.delimiter = delimiter;
        this.pos = pos;
        this.fence = fence;
        this.trimEmpty = trimEmpty;
        this.nEmpty = nEmpty;
        this.next = next;
    }

    private int next(int pos) {
        if (pos == this.fence) {
            return pos;
        }
        if (this.source instanceof String) {
            int nextPos = ((String)this.source).indexOf(this.delimiter, pos);
            return nextPos == -1 ? this.fence : nextPos;
        }
        while (pos < this.fence) {
            if (this.source.charAt(pos) == this.delimiter) {
                return pos;
            }
            ++pos;
        }
        return this.fence;
    }

    @Override
    public boolean tryAdvance(Consumer<? super String> action) {
        if (this.nEmpty > 0) {
            --this.nEmpty;
            action.accept("");
            return true;
        }
        if (this.next != null) {
            action.accept(this.next);
            this.next = null;
            return true;
        }
        if (this.pos > this.fence) {
            return false;
        }
        int nextPos = this.next(this.pos);
        if (this.trimEmpty) {
            while (nextPos == this.pos && nextPos != this.fence) {
                ++this.nEmpty;
                nextPos = this.next(++this.pos);
            }
        }
        String str = this.source.subSequence(this.pos, nextPos).toString();
        this.pos = nextPos + 1;
        if (this.trimEmpty && nextPos == this.fence && str.isEmpty()) {
            this.nEmpty = 0;
            return false;
        }
        if (this.nEmpty > 0) {
            this.next = str;
            --this.nEmpty;
            action.accept("");
        } else {
            action.accept(str);
        }
        return true;
    }

    @Override
    public Spliterator<String> trySplit() {
        CharSpliterator prefix;
        int mid = this.pos + this.fence >>> 1;
        int nextPos = this.next(mid);
        if (nextPos == this.fence) {
            return null;
        }
        if (this.trimEmpty && nextPos == mid) {
            while (nextPos < this.fence && this.source.charAt(nextPos) == this.delimiter) {
                ++nextPos;
            }
            if (nextPos == this.fence) {
                prefix = new CharSpliterator(this.source, this.delimiter, this.pos, mid, true, this.nEmpty, this.next);
                this.nEmpty = 0;
                this.pos = nextPos + 1;
            } else {
                prefix = new CharSpliterator(this.source, this.delimiter, this.pos, mid, false, this.nEmpty, this.next);
                this.nEmpty = nextPos - mid - 1;
                this.pos = nextPos;
            }
        } else {
            prefix = new CharSpliterator(this.source, this.delimiter, this.pos, nextPos, false, this.nEmpty, this.next);
            this.nEmpty = 0;
            this.pos = nextPos + 1;
        }
        this.next = null;
        return prefix;
    }

    @Override
    public long estimateSize() {
        return this.pos > this.fence ? 0L : (long)(this.fence - this.pos);
    }

    @Override
    public int characteristics() {
        return 272;
    }
}

