/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoublePredicate;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongPredicate;
import java.util.function.ObjDoubleConsumer;
import java.util.function.ObjIntConsumer;
import java.util.function.ObjLongConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import one.util.streamex.DoubleStreamEx;
import one.util.streamex.EntryStream;
import one.util.streamex.IntStreamEx;
import one.util.streamex.LongStreamEx;
import one.util.streamex.StreamEx;

class StreamFactory {
    static final StreamFactory DEFAULT = new StreamFactory();

    StreamFactory() {
    }

    public <T> StreamEx<T> newStreamEx(Stream<T> src) {
        return new StreamEx<T>(src);
    }

    public <K, V> EntryStream<K, V> newEntryStream(Stream<Map.Entry<K, V>> src) {
        return new EntryStream<K, V>(src);
    }

    public LongStreamEx newLongStreamEx(LongStream src) {
        return new LongStreamEx(src);
    }

    public IntStreamEx newIntStreamEx(IntStream src) {
        return new IntStreamEx(src);
    }

    public DoubleStreamEx newDoubleStreamEx(DoubleStream src) {
        return new DoubleStreamEx(src);
    }

    static StreamFactory forCustomPool(ForkJoinPool fjp) {
        return new CustomPoolStreamFactory(fjp);
    }

    static final class CustomDoubleStreamEx
    extends DoubleStreamEx {
        private final CustomPoolStreamFactory strategy;

        CustomDoubleStreamEx(DoubleStream stream, CustomPoolStreamFactory strategy) {
            super(stream);
            this.strategy = strategy;
        }

        @Override
        StreamFactory strategy() {
            return this.strategy;
        }

        @Override
        public void forEach(DoubleConsumer action) {
            this.strategy.terminate(() -> {
                this.stream.forEach(action);
                return null;
            });
        }

        @Override
        public void forEachOrdered(DoubleConsumer action) {
            this.strategy.terminate(() -> {
                this.stream.forEachOrdered(action);
                return null;
            });
        }

        @Override
        public double[] toArray() {
            return this.strategy.terminate(this.stream::toArray);
        }

        @Override
        public double reduce(double identity, DoubleBinaryOperator op) {
            return this.strategy.terminate(() -> this.stream.reduce(identity, op));
        }

        @Override
        public OptionalDouble reduce(DoubleBinaryOperator op) {
            return this.strategy.terminate(op, this.stream::reduce);
        }

        @Override
        public <R> R collect(Supplier<R> supplier, ObjDoubleConsumer<R> accumulator, BiConsumer<R, R> combiner) {
            return (R)this.strategy.terminate(() -> this.stream.collect(supplier, accumulator, combiner));
        }

        @Override
        public double sum() {
            return this.strategy.terminate(this.stream::sum);
        }

        @Override
        public long count() {
            return this.strategy.terminate(this.stream::count);
        }

        @Override
        public OptionalDouble average() {
            return this.strategy.terminate(this.stream::average);
        }

        @Override
        public boolean anyMatch(DoublePredicate predicate) {
            return this.strategy.terminate(predicate, this.stream::anyMatch);
        }

        @Override
        public boolean allMatch(DoublePredicate predicate) {
            return this.strategy.terminate(predicate, this.stream::allMatch);
        }

        @Override
        public OptionalDouble findFirst() {
            return this.strategy.terminate(this.stream::findFirst);
        }

        @Override
        public OptionalDouble findAny() {
            return this.strategy.terminate(this.stream::findAny);
        }
    }

    static final class CustomLongStreamEx
    extends LongStreamEx {
        private final CustomPoolStreamFactory strategy;

        CustomLongStreamEx(LongStream stream, CustomPoolStreamFactory strategy) {
            super(stream);
            this.strategy = strategy;
        }

        @Override
        StreamFactory strategy() {
            return this.strategy;
        }

        @Override
        public void forEach(LongConsumer action) {
            this.strategy.terminate(() -> {
                this.stream.forEach(action);
                return null;
            });
        }

        @Override
        public void forEachOrdered(LongConsumer action) {
            this.strategy.terminate(() -> {
                this.stream.forEachOrdered(action);
                return null;
            });
        }

        @Override
        public long[] toArray() {
            return this.strategy.terminate(this.stream::toArray);
        }

        @Override
        public long reduce(long identity, LongBinaryOperator op) {
            return this.strategy.terminate(() -> this.stream.reduce(identity, op));
        }

        @Override
        public OptionalLong reduce(LongBinaryOperator op) {
            return this.strategy.terminate(op, this.stream::reduce);
        }

        @Override
        public <R> R collect(Supplier<R> supplier, ObjLongConsumer<R> accumulator, BiConsumer<R, R> combiner) {
            return (R)this.strategy.terminate(() -> this.stream.collect(supplier, accumulator, combiner));
        }

        @Override
        public long count() {
            return this.strategy.terminate(this.stream::count);
        }

        @Override
        public OptionalDouble average() {
            return this.strategy.terminate(this.stream::average);
        }

        @Override
        public boolean anyMatch(LongPredicate predicate) {
            return this.strategy.terminate(predicate, this.stream::anyMatch);
        }

        @Override
        public boolean allMatch(LongPredicate predicate) {
            return this.strategy.terminate(predicate, this.stream::allMatch);
        }

        @Override
        public OptionalLong findFirst() {
            return this.strategy.terminate(this.stream::findFirst);
        }

        @Override
        public OptionalLong findAny() {
            return this.strategy.terminate(this.stream::findAny);
        }
    }

    static final class CustomIntStreamEx
    extends IntStreamEx {
        private final CustomPoolStreamFactory strategy;

        CustomIntStreamEx(IntStream stream, CustomPoolStreamFactory strategy) {
            super(stream);
            this.strategy = strategy;
        }

        @Override
        StreamFactory strategy() {
            return this.strategy;
        }

        @Override
        public void forEach(IntConsumer action) {
            this.strategy.terminate(() -> {
                this.stream.forEach(action);
                return null;
            });
        }

        @Override
        public void forEachOrdered(IntConsumer action) {
            this.strategy.terminate(() -> {
                this.stream.forEachOrdered(action);
                return null;
            });
        }

        @Override
        public int[] toArray() {
            return this.strategy.terminate(this.stream::toArray);
        }

        @Override
        public int reduce(int identity, IntBinaryOperator op) {
            return this.strategy.terminate(() -> this.stream.reduce(identity, op));
        }

        @Override
        public OptionalInt reduce(IntBinaryOperator op) {
            return this.strategy.terminate(op, this.stream::reduce);
        }

        @Override
        public <R> R collect(Supplier<R> supplier, ObjIntConsumer<R> accumulator, BiConsumer<R, R> combiner) {
            return (R)this.strategy.terminate(() -> this.stream.collect(supplier, accumulator, combiner));
        }

        @Override
        public long count() {
            return this.strategy.terminate(this.stream::count);
        }

        @Override
        public OptionalDouble average() {
            return this.strategy.terminate(this.stream::average);
        }

        @Override
        public boolean anyMatch(IntPredicate predicate) {
            return this.strategy.terminate(predicate, this.stream::anyMatch);
        }

        @Override
        public boolean allMatch(IntPredicate predicate) {
            return this.strategy.terminate(predicate, this.stream::allMatch);
        }

        @Override
        public OptionalInt findFirst() {
            return this.strategy.terminate(this.stream::findFirst);
        }

        @Override
        public OptionalInt findAny() {
            return this.strategy.terminate(this.stream::findAny);
        }
    }

    static final class CustomStreamEx<T>
    extends StreamEx<T> {
        private final CustomPoolStreamFactory strategy;

        CustomStreamEx(Stream<T> stream, CustomPoolStreamFactory strategy) {
            super(stream);
            this.strategy = strategy;
        }

        @Override
        StreamFactory strategy() {
            return this.strategy;
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            this.strategy.terminate(() -> {
                this.stream.forEach(action);
                return null;
            });
        }

        @Override
        public void forEachOrdered(Consumer<? super T> action) {
            this.strategy.terminate(() -> {
                this.stream.forEachOrdered(action);
                return null;
            });
        }

        @Override
        public <A> A[] toArray(IntFunction<A[]> generator) {
            return this.strategy.terminate(generator, this.stream::toArray);
        }

        @Override
        public <R> R toListAndThen(Function<List<T>, R> finisher) {
            return (R)this.strategy.terminate(finisher, x$0 -> super.toListAndThen((Function)x$0));
        }

        @Override
        public T reduce(T identity, BinaryOperator<T> accumulator) {
            return (T)this.strategy.terminate(() -> this.stream.reduce(identity, accumulator));
        }

        @Override
        public Optional<T> reduce(BinaryOperator<T> accumulator) {
            return this.strategy.terminate(accumulator, this.stream::reduce);
        }

        @Override
        public <U> U reduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
            return (U)this.strategy.terminate(() -> this.stream.reduce(identity, accumulator, combiner));
        }

        @Override
        public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
            return (R)this.strategy.terminate(() -> this.stream.collect(supplier, accumulator, combiner));
        }

        @Override
        <R, A> R rawCollect(Collector<? super T, A, R> collector) {
            return (R)this.strategy.terminate(collector, this.stream::collect);
        }

        @Override
        public long count() {
            return this.strategy.terminate(this.stream::count);
        }

        @Override
        public boolean anyMatch(Predicate<? super T> predicate) {
            return this.strategy.terminate(predicate, this.stream::anyMatch);
        }

        @Override
        public boolean allMatch(Predicate<? super T> predicate) {
            return this.strategy.terminate(predicate, this.stream::allMatch);
        }

        @Override
        public Optional<T> findFirst() {
            return this.strategy.terminate(this.stream::findFirst);
        }

        @Override
        public Optional<T> findAny() {
            return this.strategy.terminate(this.stream::findAny);
        }
    }

    static final class CustomEntryStream<K, V>
    extends EntryStream<K, V> {
        private final CustomPoolStreamFactory strategy;

        CustomEntryStream(Stream<Map.Entry<K, V>> stream, CustomPoolStreamFactory strategy) {
            super(stream);
            this.strategy = strategy;
        }

        @Override
        StreamFactory strategy() {
            return this.strategy;
        }

        @Override
        public void forEach(Consumer<? super Map.Entry<K, V>> action) {
            this.strategy.terminate(() -> {
                this.stream.forEach(action);
                return null;
            });
        }

        @Override
        public void forEachOrdered(Consumer<? super Map.Entry<K, V>> action) {
            this.strategy.terminate(() -> {
                this.stream.forEachOrdered(action);
                return null;
            });
        }

        @Override
        public <A> A[] toArray(IntFunction<A[]> generator) {
            return this.strategy.terminate(generator, this.stream::toArray);
        }

        @Override
        public <R> R toListAndThen(Function<List<Map.Entry<K, V>>, R> finisher) {
            return (R)this.strategy.terminate(finisher, x$0 -> super.toListAndThen((Function)x$0));
        }

        @Override
        public Map.Entry<K, V> reduce(Map.Entry<K, V> identity, BinaryOperator<Map.Entry<K, V>> accumulator) {
            return this.strategy.terminate(() -> this.stream.reduce(identity, accumulator));
        }

        @Override
        public Optional<Map.Entry<K, V>> reduce(BinaryOperator<Map.Entry<K, V>> accumulator) {
            return this.strategy.terminate(accumulator, this.stream::reduce);
        }

        @Override
        public <U> U reduce(U identity, BiFunction<U, ? super Map.Entry<K, V>, U> accumulator, BinaryOperator<U> combiner) {
            return (U)this.strategy.terminate(() -> this.stream.reduce(identity, accumulator, combiner));
        }

        @Override
        public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super Map.Entry<K, V>> accumulator, BiConsumer<R, R> combiner) {
            return (R)this.strategy.terminate(() -> this.stream.collect(supplier, accumulator, combiner));
        }

        @Override
        <R, A> R rawCollect(Collector<? super Map.Entry<K, V>, A, R> collector) {
            return (R)this.strategy.terminate(collector, this.stream::collect);
        }

        @Override
        public long count() {
            return this.strategy.terminate(this.stream::count);
        }

        @Override
        public boolean anyMatch(Predicate<? super Map.Entry<K, V>> predicate) {
            return this.strategy.terminate(predicate, this.stream::anyMatch);
        }

        @Override
        public boolean allMatch(Predicate<? super Map.Entry<K, V>> predicate) {
            return this.strategy.terminate(predicate, this.stream::allMatch);
        }

        @Override
        public Optional<Map.Entry<K, V>> findFirst() {
            return this.strategy.terminate(this.stream::findFirst);
        }

        @Override
        public Optional<Map.Entry<K, V>> findAny() {
            return this.strategy.terminate(this.stream::findAny);
        }
    }

    static final class CustomPoolStreamFactory
    extends StreamFactory {
        private final ForkJoinPool fjp;

        public CustomPoolStreamFactory(ForkJoinPool fjp) {
            this.fjp = fjp;
        }

        @Override
        public <T> StreamEx<T> newStreamEx(Stream<T> src) {
            return new CustomStreamEx<T>(src, this);
        }

        @Override
        public <K, V> EntryStream<K, V> newEntryStream(Stream<Map.Entry<K, V>> src) {
            return new CustomEntryStream<K, V>(src, this);
        }

        @Override
        public LongStreamEx newLongStreamEx(LongStream src) {
            return new CustomLongStreamEx(src, this);
        }

        @Override
        public IntStreamEx newIntStreamEx(IntStream src) {
            return new CustomIntStreamEx(src, this);
        }

        @Override
        public DoubleStreamEx newDoubleStreamEx(DoubleStream src) {
            return new CustomDoubleStreamEx(src, this);
        }

        public <T> T terminate(Supplier<T> terminalOperation) {
            return (T)((ForkJoinTask)this.fjp.submit(terminalOperation::get)).join();
        }

        public <T, U> T terminate(U value, Function<U, T> terminalOperation) {
            return (T)((ForkJoinTask)this.fjp.submit(() -> terminalOperation.apply(value))).join();
        }
    }
}

