/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.nio.ByteOrder;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.DoublePredicate;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.LongPredicate;
import java.util.function.ObjDoubleConsumer;
import java.util.function.ObjIntConsumer;
import java.util.function.ObjLongConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import one.util.streamex.AbstractStreamEx;
import one.util.streamex.DoubleCollector;
import one.util.streamex.IntCollector;
import one.util.streamex.LongCollector;
import one.util.streamex.MergingCollector;

final class StreamExInternals {
    static final boolean IS_JDK9 = System.getProperty("java.version", "").compareTo("1.9") >= 0;
    static final MethodHandle[][] JDK9_METHODS = IS_JDK9 ? StreamExInternals.initJdk9Methods() : (MethodHandle[][])null;
    static final int INITIAL_SIZE = 128;
    static final Function<int[], Integer> UNBOX_INT = box -> box[0];
    static final Function<long[], Long> UNBOX_LONG = box -> box[0];
    static final Function<double[], Double> UNBOX_DOUBLE = box -> box[0];
    static final Object NONE = new Object();
    static final Set<Collector.Characteristics> NO_CHARACTERISTICS = EnumSet.noneOf(Collector.Characteristics.class);
    static final Set<Collector.Characteristics> UNORDERED_CHARACTERISTICS = EnumSet.of(Collector.Characteristics.UNORDERED);
    static final Set<Collector.Characteristics> UNORDERED_ID_CHARACTERISTICS = EnumSet.of(Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH);
    static final Set<Collector.Characteristics> ID_CHARACTERISTICS = EnumSet.of(Collector.Characteristics.IDENTITY_FINISH);
    static final int IDX_STREAM = 0;
    static final int IDX_INT_STREAM = 1;
    static final int IDX_LONG_STREAM = 2;
    static final int IDX_DOUBLE_STREAM = 3;
    static final int IDX_TAKE_WHILE = 0;
    static final int IDX_DROP_WHILE = 1;

    StreamExInternals() {
    }

    static MethodHandle[][] initJdk9Methods() {
        MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        MethodType[] types = new MethodType[]{MethodType.methodType(Stream.class, Predicate.class), MethodType.methodType(IntStream.class, IntPredicate.class), MethodType.methodType(LongStream.class, LongPredicate.class), MethodType.methodType(DoubleStream.class, DoublePredicate.class)};
        MethodHandle[][] methods = new MethodHandle[types.length][];
        try {
            int i = 0;
            for (MethodType type : types) {
                methods[i++] = new MethodHandle[]{lookup.findVirtual((Class<?>)type.returnType(), "takeWhile", type), lookup.findVirtual((Class<?>)type.returnType(), "dropWhile", type)};
            }
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            return null;
        }
        return methods;
    }

    static <T> T copy(T src, T dest, int size) {
        System.arraycopy(src, 0, dest, 0, size);
        return dest;
    }

    static ObjIntConsumer<StringBuilder> joinAccumulatorInt(CharSequence delimiter) {
        return (sb, i) -> (sb.length() > 0 ? sb.append(delimiter) : sb).append(i);
    }

    static ObjLongConsumer<StringBuilder> joinAccumulatorLong(CharSequence delimiter) {
        return (sb, i) -> (sb.length() > 0 ? sb.append(delimiter) : sb).append(i);
    }

    static ObjDoubleConsumer<StringBuilder> joinAccumulatorDouble(CharSequence delimiter) {
        return (sb, i) -> (sb.length() > 0 ? sb.append(delimiter) : sb).append(i);
    }

    static <T> BinaryOperator<T> selectFirst() {
        return (u, v) -> u;
    }

    static int checkLength(int a, int b) {
        if (a != b) {
            throw new IllegalArgumentException("Length differs: " + a + " != " + b);
        }
        return a;
    }

    static void rangeCheck(int arrayLength, int startInclusive, int endExclusive) {
        if (startInclusive > endExclusive) {
            throw new ArrayIndexOutOfBoundsException("startInclusive(" + startInclusive + ") > endExclusive(" + endExclusive + ")");
        }
        if (startInclusive < 0) {
            throw new ArrayIndexOutOfBoundsException(startInclusive);
        }
        if (endExclusive > arrayLength) {
            throw new ArrayIndexOutOfBoundsException(endExclusive);
        }
    }

    static <T> Stream<T> flatTraverse(Stream<T> src, Function<T, Stream<T>> streamProvider) {
        return src.flatMap(t -> {
            Stream result = (Stream)streamProvider.apply(t);
            return result == null ? Stream.of(t) : Stream.concat(Stream.of(t), StreamExInternals.flatTraverse(result, streamProvider));
        });
    }

    static <T> Stream<T> unwrap(Stream<T> stream) {
        return stream instanceof AbstractStreamEx ? ((AbstractStreamEx)stream).stream : stream;
    }

    static <A> Predicate<A> finished(Collector<?, A, ?> collector) {
        if (collector instanceof CancellableCollector) {
            return ((CancellableCollector)collector).finished();
        }
        return null;
    }

    static <T> T none() {
        return (T)NONE;
    }

    static class ArrayCollection
    extends AbstractCollection<Object> {
        private final Object[] arr;

        ArrayCollection(Object[] arr) {
            this.arr = arr;
        }

        @Override
        public Iterator<Object> iterator() {
            return Arrays.asList(this.arr).iterator();
        }

        @Override
        public int size() {
            return this.arr.length;
        }

        @Override
        public Object[] toArray() {
            return this.arr;
        }
    }

    static class CancelException
    extends Error {
        CancelException() {
            super(null, null, false, false);
        }
    }

    static final class AverageLong {
        long hi;
        long lo;
        long cnt;

        AverageLong() {
        }

        public void accept(long val) {
            ++this.cnt;
            int cmp = Long.compareUnsigned(this.lo, this.lo += val);
            if (val > 0L) {
                if (cmp > 0) {
                    ++this.hi;
                }
            } else if (cmp < 0) {
                --this.hi;
            }
        }

        public AverageLong combine(AverageLong other) {
            this.cnt += other.cnt;
            this.hi += other.hi;
            if (Long.compareUnsigned(this.lo += other.lo, this.lo) > 0) {
                ++this.hi;
            }
            return this;
        }

        public OptionalDouble result() {
            if (this.cnt == 0L) {
                return OptionalDouble.empty();
            }
            if (this.hi == 0L && this.lo >= 0L || this.hi == -1L && this.lo < 0L) {
                return OptionalDouble.of((double)this.lo / (double)this.cnt);
            }
            return OptionalDouble.of(new BigDecimal(new BigInteger(java.nio.ByteBuffer.allocate(16).order(ByteOrder.BIG_ENDIAN).putLong(this.hi).putLong(this.lo).array())).divide(BigDecimal.valueOf(this.cnt), MathContext.DECIMAL64).doubleValue());
        }
    }

    static final class PrimitiveBox {
        int i;
        double d;
        long l;
        boolean b;
        static final BiConsumer<PrimitiveBox, PrimitiveBox> MAX_LONG = (box1, box2) -> {
            if (box2.b && (!box1.b || box1.l < box2.l)) {
                box1.from((PrimitiveBox)box2);
            }
        };
        static final BiConsumer<PrimitiveBox, PrimitiveBox> MIN_LONG = (box1, box2) -> {
            if (box2.b && (!box1.b || box1.l > box2.l)) {
                box1.from((PrimitiveBox)box2);
            }
        };
        static final BiConsumer<PrimitiveBox, PrimitiveBox> MAX_INT = (box1, box2) -> {
            if (box2.b && (!box1.b || box1.i < box2.i)) {
                box1.from((PrimitiveBox)box2);
            }
        };
        static final BiConsumer<PrimitiveBox, PrimitiveBox> MIN_INT = (box1, box2) -> {
            if (box2.b && (!box1.b || box1.i > box2.i)) {
                box1.from((PrimitiveBox)box2);
            }
        };
        static final BiConsumer<PrimitiveBox, PrimitiveBox> MAX_DOUBLE = (box1, box2) -> {
            if (box2.b && (!box1.b || Double.compare(box1.d, box2.d) < 0)) {
                box1.from((PrimitiveBox)box2);
            }
        };
        static final BiConsumer<PrimitiveBox, PrimitiveBox> MIN_DOUBLE = (box1, box2) -> {
            if (box2.b && (!box1.b || Double.compare(box1.d, box2.d) > 0)) {
                box1.from((PrimitiveBox)box2);
            }
        };

        PrimitiveBox() {
        }

        OptionalInt asInt() {
            return this.b ? OptionalInt.of(this.i) : OptionalInt.empty();
        }

        OptionalLong asLong() {
            return this.b ? OptionalLong.of(this.l) : OptionalLong.empty();
        }

        OptionalDouble asDouble() {
            return this.b ? OptionalDouble.of(this.d) : OptionalDouble.empty();
        }

        public void from(PrimitiveBox box) {
            this.b = box.b;
            this.i = box.i;
            this.d = box.d;
            this.l = box.l;
        }
    }

    static final class ObjDoubleBox<A>
    extends Box<A> {
        double b;

        ObjDoubleBox(A a, double b) {
            super(a);
            this.b = b;
        }
    }

    static final class ObjLongBox<A>
    extends Box<A>
    implements Map.Entry<A, Long> {
        long b;

        ObjLongBox(A a, long b) {
            super(a);
            this.b = b;
        }

        @Override
        public A getKey() {
            return (A)this.a;
        }

        @Override
        public Long getValue() {
            return this.b;
        }

        @Override
        public Long setValue(Long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            return Long.hashCode(this.b) ^ (this.a == null ? 0 : this.a.hashCode());
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.getValue().equals(e.getValue()) && Objects.equals(this.a, e.getKey());
        }

        public String toString() {
            return this.a + "=" + this.b;
        }
    }

    static final class ObjIntBox<A>
    extends Box<A>
    implements Map.Entry<Integer, A> {
        int b;

        ObjIntBox(A a, int b) {
            super(a);
            this.b = b;
        }

        @Override
        public Integer getKey() {
            return this.b;
        }

        @Override
        public A getValue() {
            return (A)this.a;
        }

        @Override
        public A setValue(A value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            return Integer.hashCode(this.b) ^ (this.a == null ? 0 : this.a.hashCode());
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.getKey().equals(e.getKey()) && Objects.equals(this.a, e.getValue());
        }

        public String toString() {
            return this.b + "=" + this.a;
        }
    }

    static final class PairBox<A, B>
    extends Box<A> {
        B b;

        PairBox(A a, B b) {
            super(a);
            this.b = b;
        }

        static <T> PairBox<T, T> single(T a) {
            return new PairBox<T, T>(a, a);
        }

        public int hashCode() {
            return this.b == null ? 0 : this.b.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != PairBox.class) {
                return false;
            }
            return Objects.equals(this.b, ((PairBox)obj).b);
        }
    }

    static class Box<A> {
        A a;

        Box(A obj) {
            this.a = obj;
        }

        static <A, R> PartialCollector<Box<A>, R> partialCollector(Collector<?, A, R> c) {
            Supplier supplier = c.supplier();
            BinaryOperator combiner = c.combiner();
            Function finisher = c.finisher();
            return new PartialCollector<Box, Object>(() -> new Box(supplier.get()), (box1, box2) -> {
                box1.a = combiner.apply(box1.a, box2.a);
            }, box -> finisher.apply(box.a), NO_CHARACTERISTICS);
        }

        static <A> Optional<A> asOptional(Box<A> box) {
            return box == null ? Optional.empty() : Optional.of(box.a);
        }
    }

    static final class DoubleCollectorImpl<A, R>
    extends BaseCollector<Double, A, R>
    implements DoubleCollector<A, R> {
        private final ObjDoubleConsumer<A> doubleAccumulator;

        public DoubleCollectorImpl(Supplier<A> supplier, ObjDoubleConsumer<A> doubleAccumulator, BiConsumer<A, A> merger, Function<A, R> finisher, Set<Collector.Characteristics> characteristics) {
            super(supplier, merger, finisher, characteristics);
            this.doubleAccumulator = doubleAccumulator;
        }

        @Override
        public ObjDoubleConsumer<A> doubleAccumulator() {
            return this.doubleAccumulator;
        }
    }

    static final class LongCollectorImpl<A, R>
    extends BaseCollector<Long, A, R>
    implements LongCollector<A, R> {
        private final ObjLongConsumer<A> longAccumulator;

        public LongCollectorImpl(Supplier<A> supplier, ObjLongConsumer<A> longAccumulator, BiConsumer<A, A> merger, Function<A, R> finisher, Set<Collector.Characteristics> characteristics) {
            super(supplier, merger, finisher, characteristics);
            this.longAccumulator = longAccumulator;
        }

        @Override
        public ObjLongConsumer<A> longAccumulator() {
            return this.longAccumulator;
        }
    }

    static final class IntCollectorImpl<A, R>
    extends BaseCollector<Integer, A, R>
    implements IntCollector<A, R> {
        private final ObjIntConsumer<A> intAccumulator;

        public IntCollectorImpl(Supplier<A> supplier, ObjIntConsumer<A> intAccumulator, BiConsumer<A, A> merger, Function<A, R> finisher, Set<Collector.Characteristics> characteristics) {
            super(supplier, merger, finisher, characteristics);
            this.intAccumulator = intAccumulator;
        }

        @Override
        public ObjIntConsumer<A> intAccumulator() {
            return this.intAccumulator;
        }
    }

    static final class CancellableCollectorImpl<T, A, R>
    extends CancellableCollector<T, A, R> {
        private final Supplier<A> supplier;
        private final BiConsumer<A, T> accumulator;
        private final BinaryOperator<A> combiner;
        private final Function<A, R> finisher;
        private final Predicate<A> finished;
        private final Set<Collector.Characteristics> characteristics;

        public CancellableCollectorImpl(Supplier<A> supplier, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner, Function<A, R> finisher, Predicate<A> finished, Set<Collector.Characteristics> characteristics) {
            this.supplier = supplier;
            this.accumulator = accumulator;
            this.combiner = combiner;
            this.finisher = finisher;
            this.finished = finished;
            this.characteristics = characteristics;
        }

        @Override
        public Supplier<A> supplier() {
            return this.supplier;
        }

        @Override
        public BiConsumer<A, T> accumulator() {
            return this.accumulator;
        }

        @Override
        public BinaryOperator<A> combiner() {
            return this.combiner;
        }

        @Override
        public Function<A, R> finisher() {
            return this.finisher;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return this.characteristics;
        }

        @Override
        Predicate<A> finished() {
            return this.finished;
        }
    }

    static abstract class CancellableCollector<T, A, R>
    implements Collector<T, A, R> {
        CancellableCollector() {
        }

        abstract Predicate<A> finished();
    }

    static final class PartialCollector<A, R>
    extends BaseCollector<Object, A, R> {
        PartialCollector(Supplier<A> supplier, BiConsumer<A, A> merger, Function<A, R> finisher, Set<Collector.Characteristics> characteristics) {
            super(supplier, merger, finisher, characteristics);
        }

        @Override
        public BiConsumer<A, Object> accumulator() {
            throw new UnsupportedOperationException();
        }

        IntCollector<A, R> asInt(ObjIntConsumer<A> intAccumulator) {
            return new IntCollectorImpl(this.supplier, intAccumulator, this.merger, this.finisher, this.characteristics);
        }

        LongCollector<A, R> asLong(ObjLongConsumer<A> longAccumulator) {
            return new LongCollectorImpl(this.supplier, longAccumulator, this.merger, this.finisher, this.characteristics);
        }

        DoubleCollector<A, R> asDouble(ObjDoubleConsumer<A> doubleAccumulator) {
            return new DoubleCollectorImpl(this.supplier, doubleAccumulator, this.merger, this.finisher, this.characteristics);
        }

        <T> Collector<T, A, R> asRef(BiConsumer<A, T> accumulator) {
            return Collector.of(this.supplier, accumulator, this.combiner(), this.finisher, this.characteristics.toArray(new Collector.Characteristics[this.characteristics.size()]));
        }

        <T> Collector<T, A, R> asCancellable(BiConsumer<A, T> accumulator, Predicate<A> finished) {
            return new CancellableCollectorImpl(this.supplier, accumulator, this.combiner(), this.finisher, finished, this.characteristics);
        }

        static PartialCollector<int[], Integer> intSum() {
            return new PartialCollector<int[], Integer>(() -> new int[1], (box1, box2) -> {
                box1[0] = box1[0] + box2[0];
            }, UNBOX_INT, UNORDERED_CHARACTERISTICS);
        }

        static PartialCollector<long[], Long> longSum() {
            return new PartialCollector<long[], Long>(() -> new long[1], (box1, box2) -> {
                box1[0] = box1[0] + box2[0];
            }, UNBOX_LONG, UNORDERED_CHARACTERISTICS);
        }

        static PartialCollector<ObjIntBox<BitSet>, boolean[]> booleanArray() {
            return new PartialCollector<ObjIntBox<BitSet>, boolean[]>(() -> new ObjIntBox<BitSet>(new BitSet(), 0), (box1, box2) -> {
                ((BitSet)box2.a).stream().forEach(i -> ((BitSet)objIntBox.a).set(i + objIntBox.b));
                box1.b = StrictMath.addExact(box1.b, box2.b);
            }, box -> {
                boolean[] res = new boolean[box.b];
                ((BitSet)box.a).stream().forEach(i -> {
                    blArray[i] = true;
                });
                return res;
            }, NO_CHARACTERISTICS);
        }

        static <K, D, A, M extends Map<K, D>> PartialCollector<Map<K, A>, M> grouping(Supplier<M> mapFactory, Collector<?, A, D> downstream) {
            BinaryOperator downstreamMerger = downstream.combiner();
            BiConsumer<Map, Map> merger = (map1, map2) -> {
                for (Map.Entry e : map2.entrySet()) {
                    map1.merge(e.getKey(), e.getValue(), downstreamMerger);
                }
            };
            if (downstream.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH)) {
                return new PartialCollector(mapFactory, merger, Function.identity(), ID_CHARACTERISTICS);
            }
            Function downstreamFinisher = downstream.finisher();
            return new PartialCollector<Map, Map>(mapFactory, merger, map -> {
                map.replaceAll((k, v) -> downstreamFinisher.apply(v));
                return map;
            }, NO_CHARACTERISTICS);
        }

        static PartialCollector<StringBuilder, String> joining(CharSequence delimiter, CharSequence prefix, CharSequence suffix, boolean hasPS) {
            BiConsumer<StringBuilder, StringBuilder> merger = (sb1, sb2) -> {
                if (sb2.length() > 0) {
                    if (sb1.length() > 0) {
                        sb1.append(delimiter);
                    }
                    sb1.append((CharSequence)sb2);
                }
            };
            Supplier<StringBuilder> supplier = StringBuilder::new;
            if (hasPS) {
                return new PartialCollector<StringBuilder, String>(supplier, merger, sb -> "" + prefix + sb + suffix, NO_CHARACTERISTICS);
            }
            return new PartialCollector<StringBuilder, String>(supplier, merger, StringBuilder::toString, NO_CHARACTERISTICS);
        }
    }

    static abstract class BaseCollector<T, A, R>
    implements MergingCollector<T, A, R> {
        final Supplier<A> supplier;
        final BiConsumer<A, A> merger;
        final Function<A, R> finisher;
        final Set<Collector.Characteristics> characteristics;

        BaseCollector(Supplier<A> supplier, BiConsumer<A, A> merger, Function<A, R> finisher, Set<Collector.Characteristics> characteristics) {
            this.supplier = supplier;
            this.merger = merger;
            this.finisher = finisher;
            this.characteristics = characteristics;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return this.characteristics;
        }

        @Override
        public Supplier<A> supplier() {
            return this.supplier;
        }

        @Override
        public Function<A, R> finisher() {
            return this.finisher;
        }

        @Override
        public BiConsumer<A, A> merger() {
            return this.merger;
        }
    }

    static final class BooleanMap<T>
    extends AbstractMap<Boolean, T> {
        T trueValue;
        T falseValue;

        BooleanMap(T trueValue, T falseValue) {
            this.trueValue = trueValue;
            this.falseValue = falseValue;
        }

        @Override
        public boolean containsKey(Object key) {
            return key instanceof Boolean;
        }

        @Override
        public T get(Object key) {
            if (Boolean.TRUE.equals(key)) {
                return this.trueValue;
            }
            if (Boolean.FALSE.equals(key)) {
                return this.falseValue;
            }
            return null;
        }

        @Override
        public Set<Map.Entry<Boolean, T>> entrySet() {
            return new AbstractSet<Map.Entry<Boolean, T>>(){

                @Override
                public Iterator<Map.Entry<Boolean, T>> iterator() {
                    return Arrays.asList(new AbstractMap.SimpleEntry(Boolean.TRUE, trueValue), new AbstractMap.SimpleEntry(Boolean.FALSE, falseValue)).iterator();
                }

                @Override
                public int size() {
                    return 2;
                }
            };
        }

        @Override
        public int size() {
            return 2;
        }

        static <A, R> PartialCollector<BooleanMap<A>, Map<Boolean, R>> partialCollector(Collector<?, A, R> downstream) {
            Supplier downstreamSupplier = downstream.supplier();
            Supplier<BooleanMap> supplier = () -> new BooleanMap(downstreamSupplier.get(), downstreamSupplier.get());
            BinaryOperator downstreamCombiner = downstream.combiner();
            BiConsumer<BooleanMap, BooleanMap> merger = (left, right) -> {
                left.trueValue = downstreamCombiner.apply(left.trueValue, right.trueValue);
                left.falseValue = downstreamCombiner.apply(left.falseValue, right.falseValue);
            };
            if (downstream.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH)) {
                return new PartialCollector<BooleanMap<A>, Map<Boolean, R>>(supplier, merger, Function.identity(), ID_CHARACTERISTICS);
            }
            Function downstreamFinisher = downstream.finisher();
            return new PartialCollector<BooleanMap<A>, Map<Boolean, R>>(supplier, merger, par -> new BooleanMap(downstreamFinisher.apply(par.trueValue), downstreamFinisher.apply(par.falseValue)), NO_CHARACTERISTICS);
        }
    }

    static final class DoubleBuffer {
        int size = 0;
        double[] data;

        DoubleBuffer() {
            this.data = new double[128];
        }

        DoubleBuffer(int size) {
            this.data = new double[size];
        }

        void add(double n) {
            if (this.data.length == this.size) {
                this.data = StreamExInternals.copy(this.data, new double[this.data.length * 2], this.size);
            }
            this.data[this.size++] = n;
        }

        void addAll(DoubleBuffer buf) {
            if (this.data.length < buf.size + this.size) {
                this.data = StreamExInternals.copy(this.data, new double[buf.size + this.size], this.size);
            }
            System.arraycopy(buf.data, 0, this.data, this.size, buf.size);
            this.size += buf.size;
        }

        double[] toArray() {
            return this.data.length == this.size ? this.data : Arrays.copyOfRange(this.data, 0, this.size);
        }
    }

    static final class LongBuffer {
        int size = 0;
        long[] data;

        LongBuffer() {
            this.data = new long[128];
        }

        LongBuffer(int size) {
            this.data = new long[size];
        }

        void add(long n) {
            if (this.data.length == this.size) {
                this.data = StreamExInternals.copy(this.data, new long[this.data.length * 2], this.size);
            }
            this.data[this.size++] = n;
        }

        void addAll(LongBuffer buf) {
            if (this.data.length < buf.size + this.size) {
                this.data = StreamExInternals.copy(this.data, new long[buf.size + this.size], this.size);
            }
            System.arraycopy(buf.data, 0, this.data, this.size, buf.size);
            this.size += buf.size;
        }

        long[] toArray() {
            return this.data.length == this.size ? this.data : Arrays.copyOfRange(this.data, 0, this.size);
        }
    }

    static final class IntBuffer {
        int size = 0;
        int[] data;

        IntBuffer() {
            this.data = new int[128];
        }

        IntBuffer(int size) {
            this.data = new int[size];
        }

        void add(int n) {
            if (this.data.length == this.size) {
                this.data = StreamExInternals.copy(this.data, new int[this.data.length * 2], this.size);
            }
            this.data[this.size++] = n;
        }

        void addAll(IntBuffer buf) {
            if (this.data.length < buf.size + this.size) {
                this.data = StreamExInternals.copy(this.data, new int[buf.size + this.size], this.size);
            }
            System.arraycopy(buf.data, 0, this.data, this.size, buf.size);
            this.size += buf.size;
        }

        int[] toArray() {
            return this.data.length == this.size ? this.data : Arrays.copyOfRange(this.data, 0, this.size);
        }
    }

    static final class FloatBuffer {
        int size = 0;
        float[] data;

        FloatBuffer() {
            this.data = new float[128];
        }

        FloatBuffer(int size) {
            this.data = new float[size];
        }

        void add(double n) {
            if (this.data.length == this.size) {
                this.data = StreamExInternals.copy(this.data, new float[this.data.length * 2], this.size);
            }
            this.data[this.size++] = (float)n;
        }

        void addUnsafe(double n) {
            this.data[this.size++] = (float)n;
        }

        void addAll(FloatBuffer buf) {
            if (this.data.length < buf.size + this.size) {
                this.data = StreamExInternals.copy(this.data, new float[buf.size + this.size], this.size);
            }
            System.arraycopy(buf.data, 0, this.data, this.size, buf.size);
            this.size += buf.size;
        }

        float[] toArray() {
            return this.data.length == this.size ? this.data : Arrays.copyOfRange(this.data, 0, this.size);
        }
    }

    static final class ShortBuffer {
        int size = 0;
        short[] data;

        ShortBuffer() {
            this.data = new short[128];
        }

        ShortBuffer(int size) {
            this.data = new short[size];
        }

        void add(int n) {
            if (this.data.length == this.size) {
                this.data = StreamExInternals.copy(this.data, new short[this.data.length * 2], this.size);
            }
            this.data[this.size++] = (short)n;
        }

        void addUnsafe(int n) {
            this.data[this.size++] = (short)n;
        }

        void addAll(ShortBuffer buf) {
            if (this.data.length < buf.size + this.size) {
                this.data = StreamExInternals.copy(this.data, new short[buf.size + this.size], this.size);
            }
            System.arraycopy(buf.data, 0, this.data, this.size, buf.size);
            this.size += buf.size;
        }

        short[] toArray() {
            return this.data.length == this.size ? this.data : Arrays.copyOfRange(this.data, 0, this.size);
        }
    }

    static final class CharBuffer {
        int size = 0;
        char[] data;

        CharBuffer() {
            this.data = new char[128];
        }

        CharBuffer(int size) {
            this.data = new char[size];
        }

        void add(int n) {
            if (this.data.length == this.size) {
                this.data = StreamExInternals.copy(this.data, new char[this.data.length * 2], this.size);
            }
            this.data[this.size++] = (char)n;
        }

        void addUnsafe(int n) {
            this.data[this.size++] = (char)n;
        }

        void addAll(CharBuffer buf) {
            if (this.data.length < buf.size + this.size) {
                this.data = StreamExInternals.copy(this.data, new char[buf.size + this.size], this.size);
            }
            System.arraycopy(buf.data, 0, this.data, this.size, buf.size);
            this.size += buf.size;
        }

        char[] toArray() {
            return this.data.length == this.size ? this.data : Arrays.copyOfRange(this.data, 0, this.size);
        }
    }

    static final class ByteBuffer {
        int size = 0;
        byte[] data;

        ByteBuffer() {
            this.data = new byte[128];
        }

        ByteBuffer(int size) {
            this.data = new byte[size];
        }

        void add(int n) {
            if (this.data.length == this.size) {
                this.data = StreamExInternals.copy(this.data, new byte[this.data.length * 2], this.size);
            }
            this.data[this.size++] = (byte)n;
        }

        void addUnsafe(int n) {
            this.data[this.size++] = (byte)n;
        }

        void addAll(ByteBuffer buf) {
            if (this.data.length < buf.size + this.size) {
                this.data = StreamExInternals.copy(this.data, new byte[buf.size + this.size], this.size);
            }
            System.arraycopy(buf.data, 0, this.data, this.size, buf.size);
            this.size += buf.size;
        }

        byte[] toArray() {
            return this.data.length == this.size ? this.data : Arrays.copyOfRange(this.data, 0, this.size);
        }
    }
}

