/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import one.util.streamex.StreamExInternals;

abstract class PairSpliterator<T, S extends Spliterator<T>, R, SS extends PairSpliterator<T, S, R, SS>>
implements Spliterator<R>,
Cloneable {
    private static Sink<?> EMPTY = new Sink(null);
    private final Object lock = new Object();
    S source;
    Sink<T> left = EMPTY;
    Sink<T> right = EMPTY;

    PairSpliterator(S source) {
        this.source = source;
    }

    @Override
    public long estimateSize() {
        long size = this.source.estimateSize();
        if (size == Long.MAX_VALUE || size == 0L) {
            return size;
        }
        return size - 1L;
    }

    @Override
    public int characteristics() {
        return this.source.characteristics() & ((this.left == EMPTY && this.right == EMPTY ? 64 : 0) | 0x1000 | 0x400 | 0x10);
    }

    public SS trySplit() {
        Spliterator prefixSource = this.source.trySplit();
        if (prefixSource == null) {
            return null;
        }
        try {
            PairSpliterator clone = (PairSpliterator)this.clone();
            Sink left = new Sink(this.lock);
            Sink right = new Sink(this.lock);
            clone.source = prefixSource;
            right.other = left;
            clone.right = right.other;
            left.other = right;
            this.left = left.other;
            return (SS)clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    void finish(BiConsumer<T, T> fn, T cur) {
        Sink<T> r = this.right;
        Sink<T> l = this.left;
        this.left = null;
        this.right = null;
        if (l != null) {
            l.connect(r, fn);
        } else if (r != null) {
            r.push(cur, fn, true);
        }
    }

    static final class PSOfDouble
    extends PairSpliterator<Double, Spliterator.OfDouble, Double, PSOfDouble>
    implements Spliterator.OfDouble,
    DoubleConsumer {
        private final DoubleBinaryOperator mapper;
        private double cur;

        public PSOfDouble(DoubleBinaryOperator mapper, Spliterator.OfDouble source) {
            super(source);
            this.mapper = mapper;
        }

        @Override
        public void accept(double t) {
            this.cur = t;
        }

        private BiConsumer<Double, Double> fn(DoubleConsumer action) {
            return (a, b) -> action.accept(this.mapper.applyAsDouble((double)a, (double)b));
        }

        @Override
        public boolean tryAdvance(DoubleConsumer action) {
            Sink l = this.left;
            Sink r = this.right;
            if (l != null) {
                this.left = null;
                if (!((Spliterator.OfDouble)this.source).tryAdvance(this)) {
                    this.right = null;
                    return l.connect(r, this.fn(action));
                }
                if (l.push(this.cur, this.fn(action), false)) {
                    return true;
                }
            }
            double prev = this.cur;
            if (!((Spliterator.OfDouble)this.source).tryAdvance(this)) {
                this.right = null;
                return r != null && r.push(prev, this.fn(action), true);
            }
            action.accept(this.mapper.applyAsDouble(prev, this.cur));
            return true;
        }

        @Override
        public void forEachRemaining(DoubleConsumer action) {
            BiConsumer<Double, Double> fn = this.fn(action);
            ((Spliterator.OfDouble)this.source).forEachRemaining((double next) -> {
                if (this.left != null) {
                    this.cur = next;
                    this.left.push(this.cur, fn, false);
                    this.left = null;
                } else {
                    this.cur = next;
                    action.accept(this.mapper.applyAsDouble(this.cur, this.cur));
                }
            });
            this.finish(fn, this.cur);
        }
    }

    static final class PSOfLong
    extends PairSpliterator<Long, Spliterator.OfLong, Long, PSOfLong>
    implements Spliterator.OfLong,
    LongConsumer {
        private final LongBinaryOperator mapper;
        private long cur;

        public PSOfLong(LongBinaryOperator mapper, Spliterator.OfLong source) {
            super(source);
            this.mapper = mapper;
        }

        @Override
        public void accept(long t) {
            this.cur = t;
        }

        private BiConsumer<Long, Long> fn(LongConsumer action) {
            return (a, b) -> action.accept(this.mapper.applyAsLong((long)a, (long)b));
        }

        @Override
        public boolean tryAdvance(LongConsumer action) {
            Sink l = this.left;
            Sink r = this.right;
            if (l != null) {
                this.left = null;
                if (!((Spliterator.OfLong)this.source).tryAdvance(this)) {
                    this.right = null;
                    return l.connect(r, this.fn(action));
                }
                if (l.push(this.cur, this.fn(action), false)) {
                    return true;
                }
            }
            long prev = this.cur;
            if (!((Spliterator.OfLong)this.source).tryAdvance(this)) {
                this.right = null;
                return r != null && r.push(prev, this.fn(action), true);
            }
            action.accept(this.mapper.applyAsLong(prev, this.cur));
            return true;
        }

        @Override
        public void forEachRemaining(LongConsumer action) {
            BiConsumer<Long, Long> fn = this.fn(action);
            ((Spliterator.OfLong)this.source).forEachRemaining((long next) -> {
                if (this.left != null) {
                    this.cur = next;
                    this.left.push(this.cur, fn, false);
                    this.left = null;
                } else {
                    this.cur = next;
                    action.accept(this.mapper.applyAsLong(this.cur, this.cur));
                }
            });
            this.finish(fn, this.cur);
        }
    }

    static final class PSOfInt
    extends PairSpliterator<Integer, Spliterator.OfInt, Integer, PSOfInt>
    implements Spliterator.OfInt,
    IntConsumer {
        private final IntBinaryOperator mapper;
        private int cur;

        public PSOfInt(IntBinaryOperator mapper, Spliterator.OfInt source) {
            super(source);
            this.mapper = mapper;
        }

        @Override
        public void accept(int t) {
            this.cur = t;
        }

        private BiConsumer<Integer, Integer> fn(IntConsumer action) {
            return (a, b) -> action.accept(this.mapper.applyAsInt((int)a, (int)b));
        }

        @Override
        public boolean tryAdvance(IntConsumer action) {
            Sink l = this.left;
            Sink r = this.right;
            if (l != null) {
                this.left = null;
                if (!((Spliterator.OfInt)this.source).tryAdvance(this)) {
                    this.right = null;
                    return l.connect(r, this.fn(action));
                }
                if (l.push(this.cur, this.fn(action), false)) {
                    return true;
                }
            }
            int prev = this.cur;
            if (!((Spliterator.OfInt)this.source).tryAdvance(this)) {
                this.right = null;
                return r != null && r.push(prev, this.fn(action), true);
            }
            action.accept(this.mapper.applyAsInt(prev, this.cur));
            return true;
        }

        @Override
        public void forEachRemaining(IntConsumer action) {
            BiConsumer<Integer, Integer> fn = this.fn(action);
            ((Spliterator.OfInt)this.source).forEachRemaining((int next) -> {
                if (this.left != null) {
                    this.cur = next;
                    this.left.push(this.cur, fn, false);
                    this.left = null;
                } else {
                    this.cur = next;
                    action.accept(this.mapper.applyAsInt(this.cur, this.cur));
                }
            });
            this.finish(fn, this.cur);
        }
    }

    static final class PSOfRef<T, R>
    extends PairSpliterator<T, Spliterator<T>, R, PSOfRef<T, R>>
    implements Consumer<T> {
        private final BiFunction<? super T, ? super T, ? extends R> mapper;
        private T cur;

        public PSOfRef(BiFunction<? super T, ? super T, ? extends R> mapper, Spliterator<T> source) {
            super(source);
            this.mapper = mapper;
        }

        @Override
        public void accept(T t) {
            this.cur = t;
        }

        private BiConsumer<T, T> fn(Consumer<? super R> action) {
            return (a, b) -> action.accept((R)this.mapper.apply(a, b));
        }

        @Override
        public boolean tryAdvance(Consumer<? super R> action) {
            Sink l = this.left;
            Sink r = this.right;
            if (l != null) {
                this.left = null;
                if (!this.source.tryAdvance(this)) {
                    this.right = null;
                    return l.connect(r, this.fn(action));
                }
                if (l.push(this.cur, this.fn(action), false)) {
                    return true;
                }
            }
            T prev = this.cur;
            if (!this.source.tryAdvance(this)) {
                this.right = null;
                return r != null && r.push(prev, this.fn(action), true);
            }
            action.accept(this.mapper.apply(prev, this.cur));
            return true;
        }

        @Override
        public void forEachRemaining(Consumer<? super R> action) {
            BiConsumer<T, T> fn = this.fn(action);
            this.source.forEachRemaining((? super T next) -> {
                if (this.left != null) {
                    this.cur = next;
                    this.left.push(this.cur, fn, false);
                    this.left = null;
                } else {
                    this.cur = next;
                    action.accept((R)this.mapper.apply(this.cur, this.cur));
                }
            });
            this.finish(fn, this.cur);
        }
    }

    private static final class Sink<T> {
        Sink<T> other;
        private T payload = StreamExInternals.none();
        private final Object lock;

        Sink(Object lock) {
            this.lock = lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean push(T payload, BiConsumer<T, T> fn, boolean isLeft) {
            T otherPayload;
            if (this.lock == null) {
                return false;
            }
            Object object = this.lock;
            synchronized (object) {
                Sink<T> that = this.other;
                if (that == null) {
                    return false;
                }
                otherPayload = that.payload;
                if (otherPayload == StreamExInternals.NONE) {
                    this.payload = payload;
                    return false;
                }
                this.other = null;
                that.clear();
            }
            if (isLeft) {
                fn.accept(payload, otherPayload);
            } else {
                fn.accept(otherPayload, payload);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean connect(Sink<T> right, BiConsumer<T, T> fn) {
            T b;
            T a;
            if (this.lock == null) {
                return false;
            }
            Object object = this.lock;
            synchronized (object) {
                Sink<T> leftLeft = this.other;
                Sink<T> rightRight = right.other;
                if (leftLeft == null || rightRight == null) {
                    if (rightRight != null) {
                        rightRight.clear();
                    }
                    if (leftLeft != null) {
                        leftLeft.clear();
                    }
                    return false;
                }
                rightRight.other = leftLeft;
                leftLeft.other = rightRight;
                if (leftLeft.payload == StreamExInternals.NONE || rightRight.payload == StreamExInternals.NONE) {
                    return false;
                }
                a = leftLeft.payload;
                b = rightRight.payload;
                leftLeft.clear();
                rightRight.clear();
            }
            fn.accept(a, b);
            return true;
        }

        void clear() {
            this.other = null;
            this.payload = StreamExInternals.none();
        }
    }
}

