/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.Spliterator;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ForkJoinPool;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import one.util.streamex.AbstractStreamEx;
import one.util.streamex.PairPermutationSpliterator;
import one.util.streamex.RangeBasedSpliterator;
import one.util.streamex.StreamEx;
import one.util.streamex.StreamExInternals;
import one.util.streamex.StreamFactory;
import one.util.streamex.UnknownSizeSpliterator;

public class EntryStream<K, V>
extends AbstractStreamEx<Map.Entry<K, V>, EntryStream<K, V>> {
    EntryStream(Stream<? extends Map.Entry<K, V>> stream) {
        super(stream);
    }

    @Override
    EntryStream<K, V> supply(Stream<Map.Entry<K, V>> stream) {
        return this.strategy().newEntryStream(stream);
    }

    static <K, V> Consumer<? super Map.Entry<K, V>> toConsumer(BiConsumer<? super K, ? super V> action) {
        return entry -> action.accept((Object)entry.getKey(), (Object)entry.getValue());
    }

    <M extends Map<K, V>> Consumer<? super Map.Entry<K, V>> toMapConsumer(M map) {
        return entry -> this.addToMap(map, entry.getKey(), Objects.requireNonNull(entry.getValue()));
    }

    static <K, V> Stream<Map.Entry<K, V>> withValue(Stream<? extends K> s, V value) {
        return s == null ? null : s.map((? super T key) -> new AbstractMap.SimpleImmutableEntry<Object, Object>(key, value));
    }

    static <K, V> Stream<Map.Entry<K, V>> withKey(K key, Stream<? extends V> s) {
        return s == null ? null : s.map((? super T value) -> new AbstractMap.SimpleImmutableEntry<Object, Object>(key, value));
    }

    static <K, V, R> Function<? super Map.Entry<K, V>, ? extends R> toFunction(BiFunction<? super K, ? super V, ? extends R> mapper) {
        return entry -> mapper.apply((Object)entry.getKey(), (Object)entry.getValue());
    }

    @Override
    public EntryStream<K, V> sequential() {
        return StreamFactory.DEFAULT.newEntryStream((Stream)this.stream.sequential());
    }

    @Override
    public EntryStream<K, V> parallel() {
        return StreamFactory.DEFAULT.newEntryStream((Stream)this.stream.parallel());
    }

    public EntryStream<K, V> parallel(ForkJoinPool fjp) {
        return StreamFactory.forCustomPool(fjp).newEntryStream((Stream)this.stream.parallel());
    }

    public StreamEx<String> join(CharSequence delimiter) {
        return this.map((T entry) -> "" + entry.getKey() + delimiter + entry.getValue());
    }

    public StreamEx<String> join(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return this.map((T entry) -> new StringBuilder(prefix).append(entry.getKey()).append(delimiter).append(entry.getValue()).append(suffix).toString());
    }

    public <KK> EntryStream<KK, V> flatMapKeys(Function<? super K, ? extends Stream<? extends KK>> mapper) {
        return this.strategy().newEntryStream(this.stream.flatMap((? super T e) -> EntryStream.withValue((Stream)mapper.apply((Object)e.getKey()), e.getValue())));
    }

    public <KK> EntryStream<KK, V> flatMapToKey(BiFunction<? super K, ? super V, ? extends Stream<? extends KK>> mapper) {
        return this.strategy().newEntryStream(this.stream.flatMap((? super T e) -> EntryStream.withValue((Stream)mapper.apply((Object)e.getKey(), (Object)e.getValue()), e.getValue())));
    }

    public <VV> EntryStream<K, VV> flatMapValues(Function<? super V, ? extends Stream<? extends VV>> mapper) {
        return this.strategy().newEntryStream(this.stream.flatMap((? super T e) -> EntryStream.withKey(e.getKey(), (Stream)mapper.apply((Object)e.getValue()))));
    }

    public <VV> EntryStream<K, VV> flatMapToValue(BiFunction<? super K, ? super V, ? extends Stream<? extends VV>> mapper) {
        return this.strategy().newEntryStream(this.stream.flatMap((? super T e) -> EntryStream.withKey(e.getKey(), (Stream)mapper.apply((Object)e.getKey(), (Object)e.getValue()))));
    }

    public <R> StreamEx<R> flatMapKeyValue(BiFunction<? super K, ? super V, ? extends Stream<? extends R>> mapper) {
        return this.flatMap(EntryStream.toFunction(mapper));
    }

    public EntryStream<K, V> append(Map<K, V> map) {
        return (EntryStream)this.append(map.entrySet().stream());
    }

    public EntryStream<K, V> append(K key, V value) {
        return (EntryStream)this.append(Stream.of(new AbstractMap.SimpleImmutableEntry<K, V>(key, value)));
    }

    public EntryStream<K, V> append(K k1, V v1, K k2, V v2) {
        return (EntryStream)this.append(Stream.of(new AbstractMap.SimpleImmutableEntry<K, V>(k1, v1), new AbstractMap.SimpleImmutableEntry<K, V>(k2, v2)));
    }

    public EntryStream<K, V> append(K k1, V v1, K k2, V v2, K k3, V v3) {
        return (EntryStream)this.append(Stream.of(new AbstractMap.SimpleImmutableEntry<K, V>(k1, v1), new AbstractMap.SimpleImmutableEntry<K, V>(k2, v2), new AbstractMap.SimpleImmutableEntry<K, V>(k3, v3)));
    }

    public EntryStream<K, V> prepend(Map<K, V> map) {
        return (EntryStream)this.append(map.entrySet().stream());
    }

    public EntryStream<K, V> prepend(K key, V value) {
        return (EntryStream)this.prepend(Stream.of(new AbstractMap.SimpleImmutableEntry<K, V>(key, value)));
    }

    public EntryStream<K, V> prepend(K k1, V v1, K k2, V v2) {
        return (EntryStream)this.prepend(Stream.of(new AbstractMap.SimpleImmutableEntry<K, V>(k1, v1), new AbstractMap.SimpleImmutableEntry<K, V>(k2, v2)));
    }

    public EntryStream<K, V> prepend(K k1, V v1, K k2, V v2, K k3, V v3) {
        return (EntryStream)this.prepend(Stream.of(new AbstractMap.SimpleImmutableEntry<K, V>(k1, v1), new AbstractMap.SimpleImmutableEntry<K, V>(k2, v2), new AbstractMap.SimpleImmutableEntry<K, V>(k3, v3)));
    }

    public EntryStream<K, V> distinctKeys() {
        return (EntryStream)this.distinct(Map.Entry::getKey);
    }

    public EntryStream<K, V> distinctValues() {
        return (EntryStream)this.distinct(Map.Entry::getValue);
    }

    public <KK> EntryStream<KK, V> mapKeys(Function<? super K, ? extends KK> keyMapper) {
        return this.strategy().newEntryStream(this.stream.map((? super T e) -> new AbstractMap.SimpleImmutableEntry(keyMapper.apply((Object)e.getKey()), e.getValue())));
    }

    public <VV> EntryStream<K, VV> mapValues(Function<? super V, ? extends VV> valueMapper) {
        return this.strategy().newEntryStream(this.stream.map((? super T e) -> new AbstractMap.SimpleImmutableEntry(e.getKey(), valueMapper.apply((Object)e.getValue()))));
    }

    public <R> StreamEx<R> mapKeyValue(BiFunction<? super K, ? super V, ? extends R> mapper) {
        return this.map(EntryStream.toFunction(mapper));
    }

    public <KK> EntryStream<KK, V> mapToKey(BiFunction<? super K, ? super V, ? extends KK> keyMapper) {
        return this.strategy().newEntryStream(this.stream.map((? super T e) -> new AbstractMap.SimpleImmutableEntry(keyMapper.apply((Object)e.getKey(), (Object)e.getValue()), e.getValue())));
    }

    public <VV> EntryStream<K, VV> mapToValue(BiFunction<? super K, ? super V, ? extends VV> valueMapper) {
        return this.strategy().newEntryStream(this.stream.map((? super T e) -> new AbstractMap.SimpleImmutableEntry(e.getKey(), valueMapper.apply((Object)e.getKey(), (Object)e.getValue()))));
    }

    public EntryStream<V, K> invert() {
        return this.strategy().newEntryStream(this.stream.map((? super T e) -> new AbstractMap.SimpleImmutableEntry(e.getValue(), e.getKey())));
    }

    public EntryStream<K, V> filterKeys(Predicate<? super K> keyPredicate) {
        return (EntryStream)this.filter((T e) -> keyPredicate.test((Object)e.getKey()));
    }

    public EntryStream<K, V> filterValues(Predicate<? super V> valuePredicate) {
        return (EntryStream)this.filter((T e) -> valuePredicate.test((Object)e.getValue()));
    }

    public EntryStream<K, V> filterKeyValue(BiPredicate<? super K, ? super V> predicate) {
        return (EntryStream)this.filter((T e) -> predicate.test((Object)e.getKey(), (Object)e.getValue()));
    }

    public EntryStream<K, V> removeKeys(Predicate<? super K> keyPredicate) {
        return this.filterKeys(keyPredicate.negate());
    }

    public EntryStream<K, V> removeValues(Predicate<? super V> valuePredicate) {
        return this.filterValues(valuePredicate.negate());
    }

    public EntryStream<K, V> nonNullKeys() {
        return (EntryStream)this.filter((T e) -> e.getKey() != null);
    }

    public EntryStream<K, V> nonNullValues() {
        return (EntryStream)this.filter((T e) -> e.getValue() != null);
    }

    public <KK> EntryStream<KK, V> selectKeys(Class<KK> clazz) {
        return (EntryStream)this.filter((T e) -> clazz.isInstance(e.getKey()));
    }

    public <VV> EntryStream<K, VV> selectValues(Class<VV> clazz) {
        return (EntryStream)this.filter((T e) -> clazz.isInstance(e.getValue()));
    }

    public EntryStream<K, V> peekKeys(Consumer<? super K> keyAction) {
        return (EntryStream)this.peek((T e) -> keyAction.accept((Object)e.getKey()));
    }

    public EntryStream<K, V> peekValues(Consumer<? super V> valueAction) {
        return (EntryStream)this.peek((T e) -> valueAction.accept((Object)e.getValue()));
    }

    public EntryStream<K, V> peekKeyValue(BiConsumer<? super K, ? super V> action) {
        return (EntryStream)this.peek(EntryStream.toConsumer(action));
    }

    public StreamEx<K> keys() {
        return this.map(Map.Entry::getKey);
    }

    public StreamEx<V> values() {
        return this.map(Map.Entry::getValue);
    }

    public Map<K, V> toMap() {
        AbstractMap map = this.stream.isParallel() ? new ConcurrentHashMap() : new HashMap();
        this.forEach(this.toMapConsumer(map));
        return map;
    }

    public Map<K, V> toMap(BinaryOperator<V> mergeFunction) {
        Function<Map.Entry, Object> keyMapper = Map.Entry::getKey;
        Function<Map.Entry, Object> valueMapper = Map.Entry::getValue;
        return (Map)this.collect(Collectors.toMap(keyMapper, valueMapper, mergeFunction, HashMap::new));
    }

    public <M extends Map<K, V>> M toCustomMap(Supplier<M> mapSupplier) {
        Map map = (Map)mapSupplier.get();
        if (this.stream.isParallel() && !(map instanceof ConcurrentMap)) {
            return (M)((Map)this.collect(mapSupplier, (T m, U t) -> this.addToMap(m, t.getKey(), Objects.requireNonNull(t.getValue())), (T m1, U m2) -> m2.forEach((? super K k, ? super V v) -> this.addToMap(m1, k, v))));
        }
        this.forEach(this.toMapConsumer(map));
        return (M)map;
    }

    public <M extends Map<K, V>> M toCustomMap(BinaryOperator<V> mergeFunction, Supplier<M> mapSupplier) {
        Function<Map.Entry, Object> keyMapper = Map.Entry::getKey;
        Function<Map.Entry, Object> valueMapper = Map.Entry::getValue;
        return (M)((Map)this.collect(Collectors.toMap(keyMapper, valueMapper, mergeFunction, mapSupplier)));
    }

    public SortedMap<K, V> toSortedMap() {
        AbstractMap map = this.stream.isParallel() ? new ConcurrentSkipListMap() : new TreeMap();
        this.forEach(this.toMapConsumer(map));
        return map;
    }

    public SortedMap<K, V> toSortedMap(BinaryOperator<V> mergeFunction) {
        return (SortedMap)this.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, mergeFunction, TreeMap::new));
    }

    public Map<K, List<V>> grouping() {
        return this.grouping(Collectors.toList());
    }

    public <M extends Map<K, List<V>>> M grouping(Supplier<M> mapSupplier) {
        return this.grouping(mapSupplier, Collectors.toList());
    }

    public <A, D> Map<K, D> grouping(Collector<? super V, A, D> downstream) {
        Function<Map.Entry, Object> keyMapper = Map.Entry::getKey;
        Collector<Map.Entry, ?, D> mapping = Collectors.mapping(Map.Entry::getValue, downstream);
        if (this.stream.isParallel() && downstream.characteristics().contains((Object)Collector.Characteristics.UNORDERED)) {
            return (Map)this.collect(Collectors.groupingByConcurrent(keyMapper, mapping));
        }
        return (Map)this.collect(Collectors.groupingBy(keyMapper, mapping));
    }

    public <A, D, M extends Map<K, D>> M grouping(Supplier<M> mapSupplier, Collector<? super V, A, D> downstream) {
        Function<Map.Entry, Object> keyMapper = Map.Entry::getKey;
        Collector<Map.Entry, ?, D> mapping = Collectors.mapping(Map.Entry::getValue, downstream);
        if (this.stream.isParallel() && downstream.characteristics().contains((Object)Collector.Characteristics.UNORDERED) && mapSupplier.get() instanceof ConcurrentMap) {
            return (M)((Map)this.collect(Collectors.groupingByConcurrent(keyMapper, mapSupplier, mapping)));
        }
        return (M)((Map)this.collect(Collectors.groupingBy(keyMapper, mapSupplier, mapping)));
    }

    public <C extends Collection<V>> Map<K, C> groupingTo(Supplier<C> collectionFactory) {
        return this.grouping(Collectors.toCollection(collectionFactory));
    }

    public <C extends Collection<V>, M extends Map<K, C>> M groupingTo(Supplier<M> mapSupplier, Supplier<C> collectionFactory) {
        return this.grouping(mapSupplier, Collectors.toCollection(collectionFactory));
    }

    public void forKeyValue(BiConsumer<? super K, ? super V> action) {
        this.forEach(EntryStream.toConsumer(action));
    }

    public static <K, V> EntryStream<K, V> empty() {
        return EntryStream.of(Stream.empty());
    }

    public static <K, V> EntryStream<K, V> of(Stream<? extends Map.Entry<K, V>> stream) {
        return new EntryStream<K, V>(StreamExInternals.unwrap(stream));
    }

    public static <K, V> EntryStream<K, V> of(Spliterator<? extends Map.Entry<K, V>> spliterator) {
        return EntryStream.of(StreamSupport.stream(spliterator, false));
    }

    public static <K, V> EntryStream<K, V> of(Iterator<? extends Map.Entry<K, V>> iterator) {
        return EntryStream.of(new UnknownSizeSpliterator.USOfRef<Map.Entry<K, V>>(iterator));
    }

    public static <K, V> EntryStream<K, V> of(Map<K, V> map) {
        return EntryStream.of(map.entrySet().stream());
    }

    public static <V> EntryStream<Integer, V> of(List<V> list) {
        return EntryStream.of(new RangeBasedSpliterator.AsEntry<V>(list));
    }

    public static <V> EntryStream<Integer, V> of(V[] array) {
        return EntryStream.of(Arrays.asList(array));
    }

    public static <K, V> EntryStream<K, V> of(K key, V value) {
        return EntryStream.of(Stream.of(new AbstractMap.SimpleImmutableEntry<K, V>(key, value)));
    }

    public static <K, V> EntryStream<K, V> of(K k1, V v1, K k2, V v2) {
        return EntryStream.of(Stream.of(new AbstractMap.SimpleImmutableEntry<K, V>(k1, v1), new AbstractMap.SimpleImmutableEntry<K, V>(k2, v2)));
    }

    public static <K, V> EntryStream<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        return EntryStream.of(Stream.of(new AbstractMap.SimpleImmutableEntry<K, V>(k1, v1), new AbstractMap.SimpleImmutableEntry<K, V>(k2, v2), new AbstractMap.SimpleImmutableEntry<K, V>(k3, v3)));
    }

    public static <K, V> EntryStream<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        return EntryStream.of(Stream.of(new AbstractMap.SimpleImmutableEntry<K, V>(k1, v1), new AbstractMap.SimpleImmutableEntry<K, V>(k2, v2), new AbstractMap.SimpleImmutableEntry<K, V>(k3, v3), new AbstractMap.SimpleImmutableEntry<K, V>(k4, v4)));
    }

    public static <K, V> EntryStream<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        return EntryStream.of(Stream.of(new AbstractMap.SimpleImmutableEntry<K, V>(k1, v1), new AbstractMap.SimpleImmutableEntry<K, V>(k2, v2), new AbstractMap.SimpleImmutableEntry<K, V>(k3, v3), new AbstractMap.SimpleImmutableEntry<K, V>(k4, v4), new AbstractMap.SimpleImmutableEntry<K, V>(k5, v5)));
    }

    public static <K, V> EntryStream<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6) {
        return EntryStream.of(Stream.of(new AbstractMap.SimpleImmutableEntry<K, V>(k1, v1), new AbstractMap.SimpleImmutableEntry<K, V>(k2, v2), new AbstractMap.SimpleImmutableEntry<K, V>(k3, v3), new AbstractMap.SimpleImmutableEntry<K, V>(k4, v4), new AbstractMap.SimpleImmutableEntry<K, V>(k5, v5), new AbstractMap.SimpleImmutableEntry<K, V>(k6, v6)));
    }

    public static <K, V> EntryStream<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7) {
        return EntryStream.of(Stream.of(new AbstractMap.SimpleImmutableEntry<K, V>(k1, v1), new AbstractMap.SimpleImmutableEntry<K, V>(k2, v2), new AbstractMap.SimpleImmutableEntry<K, V>(k3, v3), new AbstractMap.SimpleImmutableEntry<K, V>(k4, v4), new AbstractMap.SimpleImmutableEntry<K, V>(k5, v5), new AbstractMap.SimpleImmutableEntry<K, V>(k6, v6), new AbstractMap.SimpleImmutableEntry<K, V>(k7, v7)));
    }

    public static <K, V> EntryStream<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8) {
        return EntryStream.of(Stream.of(new AbstractMap.SimpleImmutableEntry<K, V>(k1, v1), new AbstractMap.SimpleImmutableEntry<K, V>(k2, v2), new AbstractMap.SimpleImmutableEntry<K, V>(k3, v3), new AbstractMap.SimpleImmutableEntry<K, V>(k4, v4), new AbstractMap.SimpleImmutableEntry<K, V>(k5, v5), new AbstractMap.SimpleImmutableEntry<K, V>(k6, v6), new AbstractMap.SimpleImmutableEntry<K, V>(k7, v7), new AbstractMap.SimpleImmutableEntry<K, V>(k8, v8)));
    }

    public static <K, V> EntryStream<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9) {
        return EntryStream.of(Stream.of(new AbstractMap.SimpleImmutableEntry<K, V>(k1, v1), new AbstractMap.SimpleImmutableEntry<K, V>(k2, v2), new AbstractMap.SimpleImmutableEntry<K, V>(k3, v3), new AbstractMap.SimpleImmutableEntry<K, V>(k4, v4), new AbstractMap.SimpleImmutableEntry<K, V>(k5, v5), new AbstractMap.SimpleImmutableEntry<K, V>(k6, v6), new AbstractMap.SimpleImmutableEntry<K, V>(k7, v7), new AbstractMap.SimpleImmutableEntry<K, V>(k8, v8), new AbstractMap.SimpleImmutableEntry<K, V>(k9, v9)));
    }

    public static <K, V> EntryStream<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10) {
        return EntryStream.of(Stream.of(new AbstractMap.SimpleImmutableEntry<K, V>(k1, v1), new AbstractMap.SimpleImmutableEntry<K, V>(k2, v2), new AbstractMap.SimpleImmutableEntry<K, V>(k3, v3), new AbstractMap.SimpleImmutableEntry<K, V>(k4, v4), new AbstractMap.SimpleImmutableEntry<K, V>(k5, v5), new AbstractMap.SimpleImmutableEntry<K, V>(k6, v6), new AbstractMap.SimpleImmutableEntry<K, V>(k7, v7), new AbstractMap.SimpleImmutableEntry<K, V>(k8, v8), new AbstractMap.SimpleImmutableEntry<K, V>(k9, v9), new AbstractMap.SimpleImmutableEntry<K, V>(k10, v10)));
    }

    public static <K, V> EntryStream<K, V> zip(List<K> keys, List<V> values) {
        return EntryStream.of(new RangeBasedSpliterator.ZipRef<Object, Object, AbstractMap.SimpleImmutableEntry>(0, StreamExInternals.checkLength(keys.size(), values.size()), AbstractMap.SimpleImmutableEntry::new, keys, values));
    }

    public static <K, V> EntryStream<K, V> zip(K[] keys, V[] values) {
        return EntryStream.zip(Arrays.asList(keys), Arrays.asList(values));
    }

    public static <T> EntryStream<T, T> ofPairs(List<T> list) {
        return EntryStream.of(new PairPermutationSpliterator<Object, AbstractMap.SimpleImmutableEntry>(list, AbstractMap.SimpleImmutableEntry::new));
    }

    public static <T> EntryStream<T, T> ofPairs(T[] array) {
        return EntryStream.ofPairs(Arrays.asList(array));
    }

    static <T> Stream<Map.Entry<Integer, T>> flatTraverse(Stream<Map.Entry<Integer, T>> src, BiFunction<Integer, T, Stream<T>> streamProvider) {
        return src.flatMap((? super T entry) -> {
            Integer depth = (Integer)entry.getKey();
            Stream result = (Stream)streamProvider.apply(depth, entry.getValue());
            return result == null ? Stream.of(entry) : Stream.concat(Stream.of(entry), EntryStream.flatTraverse(result.map((? super T t) -> new StreamExInternals.ObjIntBox<Object>(t, depth + 1)), streamProvider));
        });
    }

    public static <T> EntryStream<Integer, T> ofTree(T root, BiFunction<Integer, T, Stream<T>> mapper) {
        Stream<Object> rootStream = mapper.apply(0, (Integer)root);
        Stream<StreamExInternals.ObjIntBox<T>> base = Stream.of(new StreamExInternals.ObjIntBox<T>(root, 0));
        return rootStream == null ? EntryStream.of(base) : (EntryStream)EntryStream.of(EntryStream.flatTraverse(rootStream.map((? super T t) -> new StreamExInternals.ObjIntBox<Object>(t, 1)), mapper)).prepend(base);
    }

    public static <T, TT extends T> EntryStream<Integer, T> ofTree(T root, Class<TT> collectionClass, BiFunction<Integer, TT, Stream<T>> mapper) {
        return EntryStream.ofTree(root, (d, t) -> collectionClass.isInstance(t) ? (Stream)mapper.apply((Integer)d, (Object)t) : null);
    }
}

