/*
 * Decompiled with CFR 0.152.
 */
package one.microproject.testmeter.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import one.microproject.testmeter.TestScenarioProducer;
import one.microproject.testmeter.dto.RunnerContext;
import one.microproject.testmeter.dto.RunnerResult;
import one.microproject.testmeter.dto.ScenarioContext;
import one.microproject.testmeter.dto.ScenarioRequest;
import one.microproject.testmeter.dto.ScenarioResult;
import one.microproject.testmeter.impl.ResultCache;
import one.microproject.testmeter.impl.ScenarioInitException;
import one.microproject.testmeter.impl.TestScenarioTask;
import org.junit.jupiter.params.provider.Arguments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScenarioRunner<T, R>
implements ResultCache<T, R> {
    private static final Logger LOG = LoggerFactory.getLogger(ScenarioRunner.class);
    private final int runnerIndex;
    private final ExecutorService executorService;
    private final Map<Integer, ScenarioContext<T, R>> scenarios;
    private final TestScenarioProducer<T, R> scenarioProducer;
    private final int nThreads;
    private final int repeat;
    private long started;
    private long duration;

    public ScenarioRunner(int runnerIndex, int nThreads, int repeat, TestScenarioProducer<T, R> scenarioProducer) {
        this.runnerIndex = runnerIndex;
        this.nThreads = nThreads;
        this.repeat = repeat;
        this.executorService = Executors.newFixedThreadPool(nThreads);
        this.scenarios = new ConcurrentHashMap<Integer, ScenarioContext<T, R>>();
        this.scenarioProducer = scenarioProducer;
    }

    public void execTests() throws InterruptedException {
        this.started = System.nanoTime();
        for (int i = 0; i < this.nThreads * this.repeat; ++i) {
            try {
                RunnerContext context = new RunnerContext(this.runnerIndex, i);
                TestScenarioTask<T, R> testScenarioTask = new TestScenarioTask<T, R>(this, this.scenarioProducer.createRequest(context), this.scenarioProducer.createScenario(context));
                this.executorService.submit(testScenarioTask);
                continue;
            }
            catch (ScenarioInitException e) {
                this.onInitFailed(i, e);
            }
        }
        this.executorService.shutdown();
        while (!this.executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
            LOG.debug("waiting for executor shutdown ...");
        }
        this.duration = (System.nanoTime() - this.started) / 1000000L;
    }

    public Stream<Arguments> getParameters() {
        ArrayList argumentsList = new ArrayList();
        this.scenarios.values().forEach(c -> argumentsList.add(Arguments.of((Object[])new Object[]{c.getScenarioRequest(), c.getScenarioResult()})));
        return argumentsList.stream();
    }

    public Collection<ScenarioContext<T, R>> getResults() {
        return this.scenarios.values();
    }

    public RunnerResult getRunnerResult() {
        return new RunnerResult(this.runnerIndex, this.nThreads, this.repeat, this.started / 1000000L, this.duration);
    }

    @Override
    public void onInitFailed(int i, Throwable t) {
        this.onStarted(new ScenarioRequest<Object>(i, null));
        this.onResult(new ScenarioResult<Object>(i, false, "INIT ERROR: " + t.getMessage(), System.nanoTime() / 1000000L, 0L, null));
    }

    @Override
    public void onStarted(ScenarioRequest<T> request) {
        ScenarioContext scenarioContext = new ScenarioContext(request);
        this.scenarios.put(request.getId(), scenarioContext);
    }

    @Override
    public void onResult(ScenarioResult<R> result) {
        ScenarioContext<T, R> scenarioContext = this.scenarios.get(result.getId());
        if (scenarioContext != null) {
            scenarioContext.setScenarioResult(result);
        }
    }
}

