/*
 * Decompiled with CFR 0.152.
 */
package one.microproject.testmeter;

import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITTestUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ITTestUtils.class);
    public static final int IAM_SERVER_PORT = 8080;
    public static final String IAM_SERVICE_PROPERTY = "iamservice.url";
    public static final String IAM_ADMIN_PASSWORD_PROPERTY = "admin.pwd";
    public static final String IAM_CLIENT_SECRET_PROPERTY = "client.secret";

    private ITTestUtils() {
    }

    public static URL getDefaultIamServerURL() throws MalformedURLException {
        return new URL("http://localhost:8080");
    }

    public static String getGlobalAdminPassword() {
        String adminPassword = System.getProperty(IAM_ADMIN_PASSWORD_PROPERTY);
        if (adminPassword != null && !"".equals(adminPassword)) {
            return adminPassword;
        }
        LOG.info("using default IAM Admin password");
        return "secret";
    }

    public static String getGlobalAdminClientSecret() {
        String clientSecret = System.getProperty(IAM_CLIENT_SECRET_PROPERTY);
        if (clientSecret != null && !"".equals(clientSecret)) {
            return clientSecret;
        }
        LOG.info("using default IAM Client secret");
        return "top-secret";
    }

    public static URL getIAMServiceURL() throws MalformedURLException {
        try {
            String iamServerURL = System.getProperty(IAM_SERVICE_PROPERTY);
            if (iamServerURL != null) {
                return new URL(iamServerURL);
            }
        }
        catch (MalformedURLException e) {
            LOG.debug("ERROR: ", (Throwable)e);
        }
        LOG.info("using default IAM-Service URL");
        return ITTestUtils.getDefaultIamServerURL();
    }

    public static Float scenariosPerSecond(long count, long duration) {
        return Float.valueOf((float)count / ((float)duration / 1000.0f));
    }

    public static Float successRatePercent(long total, long success) {
        return Float.valueOf((float)success / (float)total * 100.0f);
    }
}

