/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.otm.swizzle;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.accesslayer.CollectionProxy;
import org.apache.ojb.broker.cache.ObjectCache;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.otm.swizzle.Swizzling;

public class CopySwizzling
implements Swizzling {
    static /* synthetic */ Class class$java$util$Collection;

    public Object swizzle(Object newObj, Object oldObj, PersistenceBroker pb, ObjectCache cache) {
        Identity newRelOid;
        Object oldRelObj;
        Object newRelObj;
        PersistentField field;
        if (newObj == null) {
            return null;
        }
        if (oldObj == null) {
            return newObj;
        }
        if (!newObj.getClass().equals(oldObj.getClass())) {
            System.err.println("Cannot swizzle objects of different classes: " + newObj.getClass() + " and " + oldObj.getClass());
            return newObj;
        }
        ClassDescriptor mif = pb.getClassDescriptor(newObj.getClass());
        FieldDescriptor[] fieldDescs = mif.getFieldDescriptions();
        for (int i = 0; i < fieldDescs.length; ++i) {
            FieldDescriptor fd = fieldDescs[i];
            PersistentField f = fd.getPersistentField();
            f.set(oldObj, f.get(newObj));
        }
        Iterator iter = mif.getObjectReferenceDescriptors().iterator();
        while (iter.hasNext()) {
            ObjectReferenceDescriptor rds = (ObjectReferenceDescriptor)iter.next();
            field = rds.getPersistentField();
            newRelObj = field.get(newObj);
            oldRelObj = field.get(oldObj);
            if (newRelObj == null && oldRelObj != null) {
                field.set(oldObj, null);
                continue;
            }
            if (newRelObj == null) continue;
            newRelOid = new Identity(newRelObj, pb);
            if (oldRelObj != null && newRelOid.equals(new Identity(oldRelObj, pb))) continue;
            oldRelObj = cache.lookup(newRelOid);
            if (oldRelObj == null) {
                oldRelObj = newRelObj;
            }
            field.set(oldObj, oldRelObj);
        }
        Iterator collections = mif.getCollectionDescriptors().iterator();
        while (collections.hasNext()) {
            CollectionDescriptor collectionDescriptor;
            if ((class$java$util$Collection == null ? CopySwizzling.class$("java.util.Collection") : class$java$util$Collection).isAssignableFrom((field = (collectionDescriptor = (CollectionDescriptor)collections.next()).getPersistentField()).getType())) {
                Collection newCol = (Collection)field.get(newObj);
                if (newCol == null || newCol instanceof CollectionProxy && !((CollectionProxy)newCol).isLoaded()) {
                    field.set(oldObj, newCol);
                    continue;
                }
                Collection oldCol = (Collection)field.get(oldObj);
                if (oldCol == null) {
                    if (newCol instanceof CollectionProxy) {
                        CollectionProxy cp = (CollectionProxy)newCol;
                        oldCol = new CollectionProxy(pb.getPBKey(), cp.getData().getClass(), null);
                        oldCol.clear();
                    } else {
                        try {
                            oldCol = (Collection)newCol.getClass().newInstance();
                        }
                        catch (Exception ex) {
                            System.err.println("Cannot instantiate collection field which is neither Collection nor array: " + field);
                            ex.printStackTrace();
                            return newObj;
                        }
                    }
                    field.set(oldObj, oldCol);
                } else {
                    oldCol.clear();
                }
                Iterator it = newCol.iterator();
                while (it.hasNext()) {
                    newRelObj = it.next();
                    newRelOid = new Identity(newRelObj, pb);
                    oldRelObj = cache.lookup(newRelOid);
                    if (oldRelObj == null) {
                        oldRelObj = newRelObj;
                    }
                    oldCol.add(oldRelObj);
                }
                continue;
            }
            if (field.getType().isArray()) {
                Object newArray = field.get(newObj);
                int length = Array.getLength(newArray);
                Object oldArray = Array.newInstance(field.getType().getComponentType(), length);
                for (int i = 0; i < length; ++i) {
                    newRelObj = Array.get(newArray, i);
                    newRelOid = new Identity(newRelObj, pb);
                    oldRelObj = cache.lookup(newRelOid);
                    if (oldRelObj == null) {
                        oldRelObj = newRelObj;
                    }
                    Array.set(oldArray, i, oldRelObj);
                }
                field.set(oldObj, oldArray);
                continue;
            }
            System.err.println("Cannot swizzle collection field: " + field);
            return newObj;
        }
        return oldObj;
    }

    public boolean isSameInstance(Object swizzledObject, Object object) {
        return swizzledObject == object;
    }

    public Object getRealTarget(Object swizzledObject) {
        return swizzledObject;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

