/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.otm.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.accesslayer.OJBIterator;
import org.apache.ojb.broker.cache.ObjectCache;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.ReportQuery;
import org.apache.ojb.broker.util.ProxyHelper;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.configuration.Configurator;
import org.apache.ojb.odmg.oql.EnhancedOQLQuery;
import org.apache.ojb.odmg.oql.OQLQueryImpl;
import org.apache.ojb.otm.EditingContext;
import org.apache.ojb.otm.OTMConnection;
import org.apache.ojb.otm.copy.ObjectCopyStrategy;
import org.apache.ojb.otm.core.ConcreteEditingContext;
import org.apache.ojb.otm.core.LockingPassthruException;
import org.apache.ojb.otm.core.Transaction;
import org.apache.ojb.otm.core.TransactionException;
import org.apache.ojb.otm.core.TransactionNotInProgressException;
import org.apache.ojb.otm.lock.LockingException;
import org.odmg.ODMGRuntimeException;
import org.odmg.OQLQuery;
import org.odmg.QueryException;

public abstract class BaseConnection
implements OTMConnection {
    private PersistenceBroker _pb;
    private Transaction _tx;
    private ConcreteEditingContext _editingContext;
    private Configurator m_configurator;

    public BaseConnection(PBKey pbKey) {
        this._pb = PersistenceBrokerFactory.createPersistenceBroker(pbKey);
        this.m_configurator = PersistenceBrokerFactory.getConfigurator();
    }

    public void close() {
        this._pb.close();
        this._pb = null;
    }

    public boolean isClosed() {
        if (this._pb == null) {
            return true;
        }
        return this._pb.isClosed();
    }

    public PersistenceBroker getKernelBroker() {
        return this._pb;
    }

    public void setTransaction(Transaction transaction) {
        if (transaction == null) {
            this._editingContext = null;
        } else {
            if (this._tx != null) {
                throw new IllegalStateException("OTMConnection is already bound to the transacaction " + this._tx);
            }
            this._editingContext = new ConcreteEditingContext(transaction, this._pb);
        }
        this._tx = transaction;
    }

    public Transaction getTransaction() {
        return this._tx;
    }

    public Object getObjectByIdentity(Identity oid, int lock) throws LockingException {
        this.checkTransaction("getObjectByIdentity");
        Object object = this._editingContext.lookup(oid);
        if (!(object != null && ProxyHelper.isMaterialized(object) || (object = this._pb.getObjectByIdentity(oid)) == null || lock == 2 && this._tx.getKit().isImplicitLockingUsed())) {
            ObjectCopyStrategy copyStrategy = this._tx.getKit().getCopyStrategy(oid);
            object = copyStrategy.copy(object);
        }
        if (object != null) {
            this._editingContext.insert(oid, object, lock);
        }
        return object;
    }

    private void checkTransaction(String methodBeingCalled) {
        if (null == this._tx) {
            throw new TransactionNotInProgressException(methodBeingCalled + " requires a valid transaction. Please make sure you have created a new transaction, and called begin() on it.");
        }
        if (!this._tx.isInProgress()) {
            throw new TransactionNotInProgressException(methodBeingCalled + " cannot be called before transaction begin() is called");
        }
    }

    public Object getObjectByIdentity(Identity oid) throws LockingException {
        return this.getObjectByIdentity(oid, 1);
    }

    public Iterator getIteratorByQuery(Query query) {
        return this.getIteratorByQuery(query, 1);
    }

    public Iterator getIteratorByQuery(Query query, int lock) {
        this.checkTransaction("getIteratorByQuery");
        return new OTMIterator((OJBIterator)this._pb.getIteratorByQuery(query), lock, null);
    }

    public Iterator getIteratorByOQLQuery(OQLQuery query) {
        return this.getIteratorByOQLQuery(query, 1);
    }

    public Iterator getIteratorByOQLQuery(OQLQuery query, int lock) {
        this.checkTransaction("getIteratorByOQLQuery");
        if (query instanceof OTMOQLQueryImpl) {
            OTMOQLQueryImpl q = (OTMOQLQueryImpl)query;
            return new OTMIterator((OJBIterator)this._pb.getIteratorByQuery(q.getQuery()), lock, q);
        }
        throw new IllegalArgumentException("The OQLQuery where created not via OTM API");
    }

    public Collection getCollectionByQuery(Query query, int lock) {
        this.checkTransaction("getCollectionByQuery");
        Collection col = this._pb.getCollectionByQuery(query);
        Iterator it = col.iterator();
        while (it.hasNext()) {
            this.insertObject(it.next(), lock);
        }
        return col;
    }

    public Collection getCollectionByQuery(Query query) {
        return this.getCollectionByQuery(query, 1);
    }

    public Identity getIdentity(Object object) {
        return new Identity(object, this._pb);
    }

    public ClassDescriptor getDescriptorFor(Class clazz) {
        return this._pb.getClassDescriptor(clazz);
    }

    public void invalidate(Identity oid) throws LockingException {
        if (null == this._tx) {
            throw new TransactionNotInProgressException("invalidate requires a valid transaction. Please make sure you have created a new transaction, and called begin() on it.");
        }
        this._editingContext.insert(oid, null, 2);
        this._pb.serviceObjectCache().remove(oid);
    }

    public ObjectCache serviceObjectCache() {
        return this._pb.serviceObjectCache();
    }

    public void invalidateAll() throws LockingException {
        this._pb.serviceObjectCache().clear();
    }

    public void lockForWrite(Object object) throws LockingException {
        this.checkTransaction("lockForWrite");
        Identity oid = new Identity(object, this._pb);
        this._editingContext.insert(oid, object, 2);
    }

    public void makePersistent(Object object) throws LockingException {
        this.checkTransaction("makePersistent");
        Identity oid = new Identity(object, this._pb);
        this.getObjectByIdentity(oid, 2);
        this._editingContext.insert(oid, object, 2);
    }

    public void deletePersistent(Object object) throws LockingException {
        this.checkTransaction("deletePersistent");
        Identity oid = new Identity(object, this._pb);
        object = this.getObjectByIdentity(oid, 2);
        if (object != null) {
            this._editingContext.deletePersistent(oid, object);
        }
    }

    public EditingContext getEditingContext() {
        return this._editingContext;
    }

    public EnhancedOQLQuery newOQLQuery() {
        return this.newOQLQuery(1);
    }

    public EnhancedOQLQuery newOQLQuery(int lock) {
        this.checkTransaction("newOQLQuery");
        OTMOQLQueryImpl query = new OTMOQLQueryImpl(this._pb.getPBKey(), lock);
        try {
            this.m_configurator.configure(query);
        }
        catch (ConfigurationException e) {
            throw new ODMGRuntimeException("Error in configuration of OQLQueryImpl instance: " + e.getMessage());
        }
        return query;
    }

    public int getCount(Query query) {
        this.checkTransaction("getCount");
        return this._pb.getCount(query);
    }

    private Object insertObject(Object object, int lock) {
        boolean needToCopy = lock != 2 || !this._tx.getKit().isImplicitLockingUsed();
        Identity oid = this.getIdentity(object);
        Object ctxObject = this._editingContext.lookup(oid);
        if (ctxObject != null) {
            object = ctxObject;
        } else if (needToCopy) {
            ObjectCopyStrategy copyStrategy = this._tx.getKit().getCopyStrategy(oid);
            object = copyStrategy.copy(object);
        }
        try {
            this._editingContext.insert(oid, object, lock);
        }
        catch (LockingException ex) {
            throw new LockingPassthruException(ex);
        }
        return object;
    }

    public abstract void transactionBegin() throws TransactionException;

    public abstract void transactionPrepare() throws TransactionException;

    public abstract void transactionCommit() throws TransactionException;

    public abstract void transactionRollback() throws TransactionException;

    private class OTMOQLQueryImpl
    extends OQLQueryImpl {
        int _lock;

        public OTMOQLQueryImpl(PBKey key, int lock) {
            super(key);
            this._lock = lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object execute() throws QueryException {
            ArrayList<Object> result = new ArrayList<Object>();
            Iterator iter = null;
            Query query = this.getQuery();
            try {
                if (!(query instanceof ReportQuery)) {
                    Collection res0 = BaseConnection.this._pb.getCollectionByQuery(query);
                    iter = res0.iterator();
                    while (iter.hasNext()) {
                        result.add(BaseConnection.this.insertObject(iter.next(), this._lock));
                    }
                } else {
                    iter = BaseConnection.this._pb.getReportQueryIteratorByQuery(query);
                    block3: while (iter.hasNext()) {
                        Object[] res = (Object[])iter.next();
                        if (res.length == 1) {
                            if (res[0] == null) continue;
                            result.add(res[0]);
                            continue;
                        }
                        for (int i = 0; i < res.length; ++i) {
                            if (res[i] == null) continue;
                            result.add(res);
                            continue block3;
                        }
                    }
                }
                this.resetBindIterator();
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (iter != null && iter instanceof OJBIterator) {
                    ((OJBIterator)iter).releaseDbResources();
                }
                throw throwable;
            }
            if (iter != null && iter instanceof OJBIterator) {
                ((OJBIterator)iter).releaseDbResources();
            }
            return result;
        }

        void resetBindIterator() {
            ListIterator it = this.getBindIterator();
            while (it.hasPrevious()) {
                it.previous();
            }
        }
    }

    private class OTMIterator
    implements OJBIterator {
        private final OJBIterator _it;
        private final int _lock;
        private final OTMOQLQueryImpl _oqlQuery;

        OTMIterator(OJBIterator it, int lock, OTMOQLQueryImpl oqlQuery) {
            this._it = it;
            this._lock = lock;
            this._oqlQuery = oqlQuery;
        }

        public boolean hasNext() {
            boolean res = this._it.hasNext();
            if (!res) {
                this.done();
            }
            return res;
        }

        public Object next() {
            Object object = this._it.next();
            object = BaseConnection.this.insertObject(object, this._lock);
            return object;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void done() {
            this.releaseDbResources();
            if (this._oqlQuery != null) {
                this._oqlQuery.resetBindIterator();
            }
        }

        protected void finalize() {
            this.done();
        }

        public boolean absolute(int row) throws PersistenceBrokerException {
            return this._it.absolute(row);
        }

        public int fullSize() throws PersistenceBrokerException {
            return this._it.fullSize();
        }

        public boolean relative(int row) throws PersistenceBrokerException {
            return this._it.relative(row);
        }

        public void releaseDbResources() {
            this._it.releaseDbResources();
        }

        public int size() throws PersistenceBrokerException {
            return this._it.size();
        }
    }
}

