/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.states;

import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.odmg.ObjectEnvelope;
import org.apache.ojb.odmg.states.ModificationState;
import org.apache.ojb.odmg.states.StateNewDelete;
import org.apache.ojb.odmg.states.StateOldClean;

public class StateOldDelete
extends ModificationState {
    private static StateOldDelete _instance = new StateOldDelete();

    private StateOldDelete() {
    }

    public static StateOldDelete getInstance() {
        return _instance;
    }

    public ModificationState markClean() {
        return StateOldClean.getInstance();
    }

    public ModificationState markDelete() {
        return this;
    }

    public ModificationState markDirty() {
        return this;
    }

    public ModificationState markNew() {
        return StateNewDelete.getInstance();
    }

    public ModificationState markOld() {
        return this;
    }

    public boolean needsDelete() {
        return true;
    }

    public void checkpoint(ObjectEnvelope mod, PersistenceBroker broker) throws PersistenceBrokerException {
        broker.delete(mod.getObject());
    }

    public void commit(ObjectEnvelope mod, PersistenceBroker broker) throws PersistenceBrokerException {
        broker.delete(mod.getObject());
        this.removeFromCache(mod.getObject(), broker);
    }

    public void rollback(ObjectEnvelope mod, PersistenceBroker broker) {
        this.removeFromCache(mod.getObject(), broker);
    }
}

