/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.locking;

import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.util.ProxyHelper;
import org.apache.ojb.odmg.TxManagerFactory;
import org.apache.ojb.odmg.locking.LockStrategy;
import org.apache.ojb.odmg.locking.ReadCommittedStrategy;
import org.apache.ojb.odmg.locking.ReadUncommittedStrategy;
import org.apache.ojb.odmg.locking.RepeatableReadStrategy;
import org.apache.ojb.odmg.locking.SerializableStrategy;

public class LockStrategyFactory {
    private static LockStrategy readUncommitedStrategy = new ReadUncommittedStrategy();
    private static LockStrategy readCommitedStrategy = new ReadCommittedStrategy();
    private static LockStrategy readRepeatableStrategy = new RepeatableReadStrategy();
    private static LockStrategy serializableStrategy = new SerializableStrategy();

    private LockStrategyFactory() {
    }

    public static LockStrategy getStrategyFor(Object obj) {
        int isolationLevel = LockStrategyFactory.getIsolationLevel(obj);
        switch (isolationLevel) {
            case 0: {
                return readUncommitedStrategy;
            }
            case 1: {
                return readCommitedStrategy;
            }
            case 2: {
                return readRepeatableStrategy;
            }
            case 3: {
                return serializableStrategy;
            }
        }
        return readUncommitedStrategy;
    }

    public static int getIsolationLevel(Object obj) {
        Class c = ProxyHelper.getRealClass(obj);
        int isolationLevel = 0;
        try {
            ClassDescriptor cld = TxManagerFactory.instance().getCurrentTransaction().getBroker().getClassDescriptor(c);
            isolationLevel = cld.getIsolationLevel();
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            // empty catch block
        }
        return isolationLevel;
    }
}

