/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.collections;

import java.io.Serializable;
import java.util.Map;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentFieldFactory;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.PBCapsule;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.TxManagerFactory;
import org.apache.ojb.odmg.collections.DMapImpl;

public class DMapEntry
implements Map.Entry,
Serializable {
    private static final long serialVersionUID = 4382757889982004339L;
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$collections$DMapEntry == null ? (class$org$apache$ojb$odmg$collections$DMapEntry = DMapEntry.class$("org.apache.ojb.odmg.collections.DMapEntry")) : class$org$apache$ojb$odmg$collections$DMapEntry);
    private int id;
    private int dmapId;
    private Identity keyOID;
    private Object keyRealSubject;
    private Identity valueOID;
    private Object valueRealSubject;
    private PBKey pbKey;
    static /* synthetic */ Class class$org$apache$ojb$odmg$collections$DMapEntry;

    public DMapEntry() {
    }

    public DMapEntry(PBKey key) {
        this.pbKey = key;
    }

    public DMapEntry(int id, int mapId, Identity keyOID, Identity valueOID) {
        this.id = id;
        this.dmapId = mapId;
        this.keyOID = keyOID;
        this.valueOID = valueOID;
    }

    public DMapEntry(DMapImpl map, Object key, Object value) {
        this.pbKey = map.getPBKey();
        if (!PersistentFieldFactory.usesAccessorsAndMutators()) {
            this.id = this.generateNewId();
        }
        this.dmapId = map.getId();
        this.keyRealSubject = key;
        PersistenceBroker broker = PersistenceBrokerFactory.defaultPersistenceBroker();
        this.keyOID = new Identity(key, broker);
        this.valueRealSubject = value;
        this.valueOID = new Identity(value, broker);
        broker.close();
    }

    protected int generateNewId() {
        PBCapsule capsule = new PBCapsule(null, TxManagerFactory.instance().getTransaction());
        try {
            int result;
            PersistenceBroker broker = capsule.getBroker();
            FieldDescriptor fld = broker.getClassDescriptor(this.getClass()).getAutoIncrementFields()[0];
            Integer val = (Integer)broker.serviceSequenceManager().getUniqueValue(fld);
            int n = result = val.intValue();
            return n;
        }
        catch (Exception e) {
            LoggerFactory.getDefaultLogger().error("DMapEntry: Generation of new id failed", e);
            throw new PersistenceBrokerException(e);
        }
        finally {
            capsule.destroy();
        }
    }

    public Object getKey() {
        if (this.keyRealSubject == null) {
            try {
                PBCapsule capsule = new PBCapsule(this.pbKey, TxManagerFactory.instance().getTransaction());
                this.keyRealSubject = capsule.getBroker().getObjectByIdentity(this.keyOID);
                capsule.destroy();
            }
            catch (Exception e) {
                this.log.error("Could not materialize key with keyOID " + this.keyOID, e);
            }
        }
        return this.keyRealSubject;
    }

    public Object getValue() {
        if (this.valueRealSubject == null) {
            try {
                PBCapsule capsule = new PBCapsule(this.pbKey, TxManagerFactory.instance().getTransaction());
                this.valueRealSubject = capsule.getBroker().getObjectByIdentity(this.valueOID);
                capsule.destroy();
            }
            catch (Exception e) {
                this.log.error("Could not materialize value with valueOID " + this.valueOID, e);
            }
        }
        return this.valueRealSubject;
    }

    public Object setValue(Object obj) {
        TransactionImpl tx = TxManagerFactory.instance().getTransaction();
        if (tx != null) {
            tx.lock(this, 4);
        }
        this.valueRealSubject = obj;
        PersistenceBroker broker = PersistenceBrokerFactory.defaultPersistenceBroker();
        this.valueOID = new Identity(obj, broker);
        broker.close();
        return obj;
    }

    public int getDmapId() {
        return this.dmapId;
    }

    public void setDmapId(int dmapId) {
        this.dmapId = dmapId;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Identity getKeyOID() {
        return this.keyOID;
    }

    public void setKeyOID(Identity keyOID) {
        this.keyOID = keyOID;
    }

    public Identity getValueOID() {
        return this.valueOID;
    }

    public void setValueOID(Identity valueOID) {
        this.valueOID = valueOID;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

