/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.collections;

import java.util.ListIterator;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.TxManagerFactory;
import org.apache.ojb.odmg.collections.DListEntry_2;
import org.apache.ojb.odmg.collections.DListImpl_2;

class DListIterator_2
implements ListIterator {
    protected ListIterator iter;
    private DListImpl_2 dlist;
    private DListEntry_2 currentEntry = null;

    public DListIterator_2(DListImpl_2 list) {
        this.dlist = list;
        this.iter = list.getElements().listIterator();
    }

    public DListIterator_2(DListImpl_2 list, int index) {
        this.dlist = list;
        this.iter = list.getElements().listIterator(index);
    }

    public void add(Object obj) {
        DListEntry_2 entry = new DListEntry_2(this.dlist, obj);
        entry.setPosition(this.nextIndex() - 1);
        this.iter.add(entry);
        TransactionImpl tx = TxManagerFactory.instance().getTransaction();
        if (tx != null) {
            tx.lock(entry, 4);
            entry.prepareForPersistency(tx.getBroker());
        }
    }

    public boolean hasNext() {
        return this.iter.hasNext();
    }

    public boolean hasPrevious() {
        return this.iter.hasPrevious();
    }

    public Object next() {
        this.currentEntry = (DListEntry_2)this.iter.next();
        return this.currentEntry.getRealSubject();
    }

    public int nextIndex() {
        return this.iter.nextIndex();
    }

    public Object previous() {
        this.currentEntry = (DListEntry_2)this.iter.previous();
        return this.currentEntry.getRealSubject();
    }

    public int previousIndex() {
        return this.iter.previousIndex();
    }

    public void remove() {
        this.iter.remove();
        TransactionImpl tx = TxManagerFactory.instance().getTransaction();
        if (tx != null) {
            tx.markDelete(this.currentEntry);
        }
        this.currentEntry = null;
    }

    public void set(Object o) {
        throw new UnsupportedOperationException("Method is not supported");
    }
}

