/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.IndirectionHandler;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.util.ObjectModification;
import org.apache.ojb.broker.util.ProxyHelper;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.TransactionAware;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.states.ModificationState;
import org.apache.ojb.odmg.states.StateNewDirty;
import org.apache.ojb.odmg.states.StateOldClean;
import org.apache.ojb.odmg.states.StateOldDirty;
import org.odmg.ClassNotPersistenceCapableException;
import org.odmg.ODMGRuntimeException;

public class ObjectEnvelope
implements ObjectModification,
Serializable {
    static final long serialVersionUID = -829177767933340522L;
    private ModificationState modificationState = null;
    private Identity oid;
    private Boolean hasChanged;
    private transient Object myObj;
    private transient Map beforeImage;
    private transient TransactionImpl tx;

    public ObjectEnvelope(Object obj, TransactionImpl aTx) {
        this.tx = aTx;
        this.myObj = ProxyHelper.getRealObject(obj);
        this.refreshObjectImage();
        this.prepareInitialState();
    }

    public void close() {
        this.myObj = null;
        this.beforeImage = null;
        this.tx = null;
    }

    public void refreshObjectImage() {
        try {
            this.hasChanged = null;
            this.oid = new Identity(this.myObj, this.tx.getBroker());
            this.beforeImage = this.getMap();
        }
        catch (Exception ex) {
            this.beforeImage = null;
            this.oid = null;
            throw new ClassNotPersistenceCapableException(ex.toString());
        }
    }

    public Identity getIdentity() {
        return this.oid;
    }

    public Object getObject() {
        return this.myObj;
    }

    public void beforeCommit() {
        if (this.myObj instanceof TransactionAware) {
            TransactionAware ta = (TransactionAware)this.myObj;
            ta.beforeCommit();
        }
    }

    public void afterCommit() {
        if (this.myObj instanceof TransactionAware) {
            TransactionAware ta = (TransactionAware)this.myObj;
            ta.afterCommit();
        }
    }

    public void beforeAbort() {
        if (this.myObj instanceof TransactionAware) {
            TransactionAware ta = (TransactionAware)this.myObj;
            ta.beforeAbort();
        }
    }

    public void afterAbort() {
        if (this.myObj instanceof TransactionAware) {
            TransactionAware ta = (TransactionAware)this.myObj;
            ta.afterAbort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getMap() throws PersistenceBrokerException {
        HashMap<Object, Object> fieldValues = new HashMap<Object, Object>();
        ClassDescriptor mif = this.tx.getBroker().getClassDescriptor(this.getObject().getClass());
        FieldDescriptor[] fieldDescs = mif.getFieldDescriptions();
        for (int i = 0; i < fieldDescs.length; ++i) {
            FieldDescriptor fd = fieldDescs[i];
            PersistentField f = fd.getPersistentField();
            fieldValues.put(fd.getColumnName(), f.get(this.myObj));
        }
        Iterator iter = mif.getObjectReferenceDescriptors().iterator();
        ObjectReferenceDescriptor rds = null;
        Object temp = null;
        while (iter.hasNext()) {
            rds = (ObjectReferenceDescriptor)iter.next();
            Object object = this.myObj;
            synchronized (object) {
                temp = rds.getPersistentField().get(this.myObj);
            }
            IndirectionHandler handler = ProxyHelper.getIndirectionHandler(temp);
            if (handler != null) {
                fieldValues.put(rds, handler.getIdentity());
                continue;
            }
            fieldValues.put(rds, temp);
        }
        Iterator collections = mif.getCollectionDescriptors().iterator();
        CollectionDescriptor collectionDescriptor = null;
        while (collections.hasNext()) {
            collectionDescriptor = (CollectionDescriptor)collections.next();
            Object collectionOrArray = collectionDescriptor.getPersistentField().get(this.myObj);
            if (collectionOrArray == null) continue;
            int referencesId = 0;
            referencesId = collectionOrArray instanceof Collection ? ((Collection)collectionOrArray).size() : (collectionOrArray.getClass().isArray() ? Array.getLength(collectionOrArray) : collectionOrArray.hashCode());
            fieldValues.put(collectionDescriptor, new Integer(referencesId));
        }
        return fieldValues;
    }

    public ModificationState getModificationState() {
        return this.modificationState;
    }

    public boolean needsInsert() {
        return this.getModificationState().needsInsert();
    }

    public boolean needsUpdate() {
        return this.getModificationState().needsUpdate();
    }

    public boolean needsDelete() {
        return this.getModificationState().needsDelete();
    }

    private void prepareInitialState() {
        boolean needsInsert;
        ModificationState initialState = null;
        try {
            needsInsert = this.tx.getBroker().serviceObjectCache().lookup(this.oid) == null && !this.tx.getBroker().serviceBrokerHelper().doesExist(this.tx.getBroker().getClassDescriptor(this.myObj.getClass()), this.oid, this.myObj);
        }
        catch (PersistenceBrokerException ex) {
            LoggerFactory.getDefaultLogger().error("ObjectEnvelope: ", (Throwable)((Object)ex));
            throw new ODMGRuntimeException("Unexpected error while check existence of " + this.myObj + ", exception was " + (Object)((Object)ex));
        }
        initialState = needsInsert ? StateNewDirty.getInstance() : (this.tx.isDeleted(this.oid) ? StateOldDirty.getInstance() : StateOldClean.getInstance());
        this.modificationState = initialState;
    }

    public void setModificationState(ModificationState newModificationState) {
        if (newModificationState != this.modificationState) {
            if (LoggerFactory.getDefaultLogger().isDebugEnabled()) {
                LoggerFactory.getDefaultLogger().debug("transition: " + new Identity(this.myObj, this.tx.getBroker()) + " (" + this.modificationState + " --> " + newModificationState + ")");
            }
            this.modificationState = newModificationState;
        }
    }

    public String toString() {
        String obj = null;
        obj = this.myObj == null ? "null" : new Identity(this.myObj, this.tx.getBroker()).toString();
        return obj + "(" + this.modificationState + ")";
    }

    public boolean hasChanged() {
        if (this.hasChanged == null) {
            Map currentImage = null;
            try {
                currentImage = this.getMap();
            }
            catch (Exception e) {
                LoggerFactory.getDefaultLogger().warn("Could not verify object changes, return hasChanged 'true'", e);
            }
            this.hasChanged = this.beforeImage != null && ((Object)this.beforeImage).equals(currentImage) ? Boolean.FALSE : Boolean.TRUE;
        }
        return this.hasChanged;
    }
}

