/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg;

import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.query.QueryByIdentity;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.NamedRootsEntry;
import org.apache.ojb.odmg.OJBTxManager;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.TxManagerFactory;
import org.odmg.ObjectNameNotFoundException;
import org.odmg.ObjectNameNotUniqueException;

public class NamedRootsMap {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$NamedRootsMap == null ? (class$org$apache$ojb$odmg$NamedRootsMap = NamedRootsMap.class$("org.apache.ojb.odmg.NamedRootsMap")) : class$org$apache$ojb$odmg$NamedRootsMap);
    private static NamedRootsMap _instance;
    private OJBTxManager txManager = TxManagerFactory.instance();
    static /* synthetic */ Class class$org$apache$ojb$odmg$NamedRootsMap;

    private NamedRootsMap() {
    }

    public Identity get(String key) {
        NamedRootsEntry example = new NamedRootsEntry(key, null);
        try {
            PersistenceBroker broker = this.txManager.getCurrentTransaction().getBroker();
            Identity oid = new Identity(example, broker);
            NamedRootsEntry entry = (NamedRootsEntry)broker.getObjectByIdentity(oid);
            return entry == null ? null : Identity.fromByteArray(entry.getOid());
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Could not get identity for key " + key, e);
            }
            return null;
        }
    }

    public static synchronized NamedRootsMap getInstance() {
        if (_instance == null) {
            _instance = new NamedRootsMap();
        }
        return _instance;
    }

    public void put(String key, Identity oid) throws ObjectNameNotUniqueException {
        NamedRootsEntry entry = new NamedRootsEntry(key, oid.serialize());
        try {
            TransactionImpl tx = this.txManager.getCurrentTransaction();
            PersistenceBroker broker = tx.getBroker();
            NamedRootsEntry stored = (NamedRootsEntry)broker.getObjectByQuery(new QueryByIdentity(entry));
            if (stored != null) {
                throw new ObjectNameNotUniqueException("object key already found, the key " + key + " is not unique");
            }
            tx.lock(entry, 4);
        }
        catch (PersistenceBrokerException e) {
            this.log.error("Could not put identity to NamedRoots. Key was " + key + ", identity was " + oid, (Throwable)((Object)e));
            throw new OJBRuntimeException((Throwable)((Object)e));
        }
    }

    public void unbind(String key) throws ObjectNameNotFoundException {
        NamedRootsEntry example = new NamedRootsEntry(key, null);
        try {
            TransactionImpl tx = this.txManager.getCurrentTransaction();
            PersistenceBroker broker = tx.getBroker();
            NamedRootsEntry stored = (NamedRootsEntry)broker.getObjectByQuery(new QueryByIdentity(example));
            if (stored == null) {
                throw new ObjectNameNotFoundException("Could not find a bound object for key " + key);
            }
            tx.markDelete(stored);
        }
        catch (PersistenceBrokerException e) {
            this.log.error("Could not unbind identity with key " + key + " from NamedRoots", (Throwable)((Object)e));
            throw new OJBRuntimeException((Throwable)((Object)e));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

