/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg;

import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.J2EETransactionImpl;
import org.apache.ojb.odmg.OJBTxManager;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.transaction.TransactionManagerFactoryException;
import org.apache.ojb.odmg.transaction.TransactionManagerFactoryFactory;
import org.odmg.TransactionNotInProgressException;

public class JTATxManager
implements OJBTxManager {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$JTATxManager == null ? (class$org$apache$ojb$odmg$JTATxManager = JTATxManager.class$("org.apache.ojb.odmg.JTATxManager")) : class$org$apache$ojb$odmg$JTATxManager);
    private static ThreadLocal txRepository = new ThreadLocal();
    static /* synthetic */ Class class$org$apache$ojb$odmg$JTATxManager;

    public void deregisterTx(Object transaction) {
        TxBuffer buf = (TxBuffer)txRepository.get();
        if (buf != null) {
            buf.setInternTx(null);
        }
    }

    public void registerTx(TransactionImpl odmgTrans) {
        if (log.isDebugEnabled()) {
            log.debug("registerSynchronization was called");
        }
        Transaction transaction = null;
        try {
            transaction = this.getJTATransaction();
        }
        catch (SystemException e) {
            log.error("Obtain current transaction from container failed", e);
        }
        if (transaction == null) {
            log.error("Cannot get the external transaction from the external TM");
            throw new TransactionNotInProgressException("No external transaction found");
        }
        if (log.isDebugEnabled()) {
            log.debug("registerSynchronization was called with parameters\n  J2EETransactionImpl: " + odmgTrans + "\n  Transaction: " + transaction);
        }
        this.registerSynchronization(odmgTrans, transaction);
    }

    private void registerSynchronization(TransactionImpl odmgTrans, Transaction transaction) {
        if (odmgTrans == null || transaction == null) {
            log.error("One of the given parameters was null --> cannot do synchronization! omdg transaction was null: " + (odmgTrans == null) + ", external transaction was null: " + (transaction == null));
            return;
        }
        int status = -1;
        try {
            status = transaction.getStatus();
            if (status != 0) {
                throw new OJBRuntimeException("Transaction synchronization failed - wrong status of external container tx: " + JTATxManager.getStatusString(status));
            }
        }
        catch (SystemException e) {
            throw new OJBRuntimeException("Can't read status of external tx", e);
        }
        try {
            transaction.registerSynchronization((Synchronization)((J2EETransactionImpl)odmgTrans));
            txRepository.set(new TxBuffer(odmgTrans, transaction));
        }
        catch (Exception e) {
            log.error("Cannot associate PersistenceBroker with running Transaction", e);
            throw new OJBRuntimeException("Transaction synchronization failed - wrong status of external container tx", e);
        }
    }

    private static String getStatusString(int status) {
        switch (status) {
            case 0: {
                return "STATUS_ACTIVE";
            }
            case 3: {
                return "STATUS_COMMITTED";
            }
            case 8: {
                return "STATUS_COMMITTING";
            }
            case 1: {
                return "STATUS_MARKED_ROLLBACK";
            }
            case 6: {
                return "STATUS_NO_TRANSACTION";
            }
            case 2: {
                return "STATUS_PREPARED";
            }
            case 7: {
                return "STATUS_PREPARING";
            }
            case 4: {
                return "STATUS_ROLLEDBACK";
            }
            case 9: {
                return "STATUS_ROLLING_BACK";
            }
            case 5: {
                return "STATUS_UNKNOWN";
            }
        }
        return "NO STATUS FOUND";
    }

    private TransactionManager getTransactionManager() {
        TransactionManager retval = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug("getTransactionManager called");
            }
            retval = TransactionManagerFactoryFactory.instance().getTransactionManager();
        }
        catch (TransactionManagerFactoryException e) {
            log.warn("Exception trying to obtain TransactionManager from Factory", (Throwable)((Object)e));
            e.printStackTrace();
        }
        return retval;
    }

    public Transaction getJTATransaction() throws SystemException {
        if (log.isDebugEnabled()) {
            log.debug("getTransaction called");
        }
        if (this.getTransactionManager() == null) {
            log.warn("TransactionManager was null");
            return null;
        }
        return this.getTransactionManager().getTransaction();
    }

    public TransactionImpl getCurrentTransaction() {
        TransactionImpl retval = this.getTransaction();
        if (null == retval) {
            throw new TransactionNotInProgressException("Calling method needed transaction, but no transaction found via TransactionManager");
        }
        return retval;
    }

    public TransactionImpl getTransaction() {
        TxBuffer buf = (TxBuffer)txRepository.get();
        return buf != null ? buf.getInternTx() : null;
    }

    public void abortExternalTx(TransactionImpl odmgTrans) {
        if (log.isDebugEnabled()) {
            log.debug("abortExternTransaction was called");
        }
        if (odmgTrans == null) {
            return;
        }
        TxBuffer buf = (TxBuffer)txRepository.get();
        Transaction extTx = buf != null ? buf.externTx : null;
        try {
            if (extTx != null && extTx.getStatus() == 0) {
                log.info("Set extern transaction to rollback");
                extTx.setRollbackOnly();
            }
        }
        catch (Exception e) {
            log.warn("Cannot work on extern transaction", e);
        }
    }

    public void configure(Configuration config) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    final class TxBuffer {
        Transaction externTx = null;
        TransactionImpl internTx = null;

        public TxBuffer() {
        }

        public TxBuffer(TransactionImpl internTx, Transaction externTx) {
            this.internTx = internTx;
            this.externTx = externTx;
        }

        public Transaction getExternTx() {
            return this.externTx;
        }

        public void setExternTx(Transaction externTx) {
            this.externTx = externTx;
        }

        public TransactionImpl getInternTx() {
            return this.internTx;
        }

        public void setInternTx(TransactionImpl internTx) {
            this.internTx = internTx;
        }
    }
}

