/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.jdo;

import java.util.Collection;
import java.util.Iterator;
import javax.jdo.Extent;
import javax.jdo.InstanceCallbacks;
import javax.jdo.JDOFatalUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.jdo.Transaction;
import javax.jdo.spi.StateManager;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.jdo.ExtentImpl;
import org.apache.ojb.jdo.StateManagerImpl;
import org.apache.ojb.jdo.TransactionImpl;
import org.apache.ojb.otm.OTMConnection;
import org.apache.ojb.otm.copy.ObjectCopyStrategy;
import org.apache.ojb.otm.kit.SimpleKit;
import org.apache.ojb.otm.lock.LockingException;
import org.apache.ojb.otm.states.State;

public class PersistenceManagerImpl
implements PersistenceManager {
    private OTMConnection m_conn;
    private SimpleKit m_kit;
    private boolean m_multiThreaded = false;
    private boolean m_ignoreCache = false;
    private PersistenceManagerFactory m_factory;
    private String m_userID;
    private String m_password;
    private String m_alias;
    private Object m_usersObject;
    private Transaction m_tx;
    private StateManager m_stateManager;

    public PersistenceManagerImpl(PersistenceManagerFactory factory, String alias, String userid, String password) {
        this.m_factory = factory;
        this.m_userID = userid;
        this.m_password = password;
        this.m_alias = alias;
        this.m_kit = SimpleKit.getInstance();
        if (null == this.m_alias) {
            this.m_conn = this.m_kit.acquireConnection(PersistenceBrokerFactory.getDefaultKey());
        } else {
            PBKey key = new PBKey(this.m_alias, this.m_userID, this.m_password);
            this.m_conn = this.m_kit.acquireConnection(key);
        }
        this.m_stateManager = new StateManagerImpl(this);
    }

    public boolean isClosed() {
        return this.m_conn.isClosed();
    }

    public void close() {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("close()"));
        }
        this.m_conn.close();
    }

    public Transaction currentTransaction() {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("currentTransaction()"));
        }
        if (this.m_tx == null) {
            this.m_tx = new TransactionImpl(this, this.m_kit.getTransaction(this.m_conn));
        }
        return this.m_tx;
    }

    public void evict(Object o) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("evict(Object)"));
        }
        if (null != o) {
            try {
                Identity oid = this.m_conn.getIdentity(o);
                State state = this.m_conn.getEditingContext().lookupState(oid);
                if (State.PERSISTENT_CLEAN == state) {
                    if (o instanceof InstanceCallbacks) {
                        ((InstanceCallbacks)o).jdoPreClear();
                    }
                    this.m_conn.invalidate(this.m_conn.getIdentity(o));
                }
                if (null == state) {
                    this.m_conn.serviceObjectCache().remove(this.m_conn.getIdentity(o));
                }
            }
            catch (LockingException lockingException) {
                // empty catch block
            }
        }
    }

    public void evictAll(Object[] objects) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("evictAll(Object[])"));
        }
        if (null == objects) {
            throw new NullPointerException("evictAll(Object[]) was passed a null Array.");
        }
        int length = objects.length;
        for (int i = 0; i < length; ++i) {
            this.evict(objects[i]);
        }
    }

    public void evictAll(Collection collection) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("evictAll(Collection)"));
        }
        if (null == collection) {
            throw new NullPointerException("evictAll(Collection) was passed a null Collection.");
        }
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            this.evict(it.next());
        }
    }

    public void evictAll() {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("evictAll()"));
        }
        Collection collection = this.m_conn.getEditingContext().getAllObjectsInContext();
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            this.evict(it.next());
        }
        this.m_conn.serviceObjectCache().clear();
    }

    public void refresh(Object o) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("refresh(Object)"));
        }
        Identity oid = this.m_conn.getIdentity(o);
        try {
            Object refreshFrom = this.m_conn.getObjectByIdentity(oid);
            ObjectCopyStrategy strat = this.m_kit.getCopyStrategy(oid);
            strat.copy(refreshFrom, o);
            if (o instanceof InstanceCallbacks) {
                ((InstanceCallbacks)o).jdoPostLoad();
            }
            this.m_conn.getEditingContext().setState(oid, State.PERSISTENT_CLEAN);
        }
        catch (LockingException lockingException) {
            // empty catch block
        }
    }

    public void refreshAll(Object[] objects) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("refreshAll(Object[])"));
        }
        if (null == objects) {
            throw new NullPointerException("refreshAll(Object[]) was passed a null Array.");
        }
        int length = objects.length;
        for (int i = 0; i < length; ++i) {
            this.refresh(objects[i]);
        }
    }

    public void refreshAll(Collection collection) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("refreshAll(Collection)"));
        }
        if (null == collection) {
            throw new NullPointerException("refreshAll(Collection) was passed a null Collection.");
        }
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            this.refresh(it.next());
        }
    }

    public void refreshAll() {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("refreshAll()"));
        }
        if (this.currentTransaction().isActive()) {
            Collection collection = this.m_conn.getEditingContext().getAllObjectsInContext();
            Iterator it = collection.iterator();
            while (it.hasNext()) {
                this.refresh(it.next());
            }
        }
    }

    public Query newQuery() {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("newQuery()"));
        }
        return null;
    }

    public Query newQuery(Object o) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("newQuery(Object)"));
        }
        return null;
    }

    public Query newQuery(String s, Object o) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("newQuery(String, Object)"));
        }
        return null;
    }

    public Query newQuery(Class aClass) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("newQuery(Class)"));
        }
        return null;
    }

    public Query newQuery(Extent extent) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("newQuery(Extent)"));
        }
        return null;
    }

    public Query newQuery(Class aClass, Collection collection) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("newQuery(Class, Collection)"));
        }
        return null;
    }

    public Query newQuery(Class aClass, String s) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("newQuery(Class, String)"));
        }
        return null;
    }

    public Query newQuery(Class aClass, Collection collection, String s) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("newQuery(Class, Collection, String)"));
        }
        return null;
    }

    public Query newQuery(Extent extent, String s) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("newQuery(Extent, String)"));
        }
        return null;
    }

    public Extent getExtent(Class aClass, boolean b) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("getExtent(Class, boolean)"));
        }
        return new ExtentImpl(aClass, this.m_conn, this);
    }

    public Object getObjectById(Object o, boolean validate) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("getObjectById(Object, boolean)"));
        }
        Object retval = null;
        try {
            retval = this.m_conn.getObjectByIdentity((Identity)o);
        }
        catch (LockingException e) {
            e.printStackTrace();
        }
        return retval;
    }

    public Object getObjectId(Object o) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("getObjectId(Object)"));
        }
        return this.m_conn.getIdentity(o);
    }

    public Object getTransactionalObjectId(Object o) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("getTransactionalObjectId(Object)"));
        }
        return this.m_conn.getIdentity(o);
    }

    public Object newObjectIdInstance(Class aClass, String s) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("newObjectIdInstance(Class, String)"));
        }
        return null;
    }

    public void makePersistent(Object o) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("makePersistent(Object)"));
        }
        try {
            this.m_conn.makePersistent(o);
        }
        catch (LockingException lockingException) {
            // empty catch block
        }
    }

    public void makePersistentAll(Object[] objects) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("makePersistentAll(Object[])"));
        }
        if (null == objects) {
            throw new NullPointerException("makePersistentAll(Object[]) was passed a null Array.");
        }
        int length = objects.length;
        for (int i = 0; i < length; ++i) {
            this.makePersistent(objects[i]);
        }
    }

    public void makePersistentAll(Collection collection) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("makePersistentAll(Collection)"));
        }
        if (null == collection) {
            throw new NullPointerException("makePersistentAll(Collection) was passed a null Collection.");
        }
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            this.makePersistent(it.next());
        }
    }

    public void deletePersistent(Object o) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("deletePersistent(Object)"));
        }
        try {
            this.m_conn.deletePersistent(o);
        }
        catch (LockingException lockingException) {
            // empty catch block
        }
    }

    public void deletePersistentAll(Object[] objects) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("deletePersistentAll(Object[])"));
        }
        if (null == objects) {
            throw new NullPointerException("deletePersistentAll(Object[]) was passed a null Array.");
        }
        int length = objects.length;
        for (int i = 0; i < length; ++i) {
            this.deletePersistent(objects[i]);
        }
    }

    public void deletePersistentAll(Collection collection) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("deletePersistentAll(Collection)"));
        }
        if (null == collection) {
            throw new NullPointerException("deletePersistentAll(Collection) was passed a null Collection.");
        }
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            this.deletePersistent(it.next());
        }
    }

    public void makeTransient(Object o) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("makeTransient(Object)"));
        }
    }

    public void makeTransientAll(Object[] objects) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("makeTransientAll(Object[])"));
        }
        if (null == objects) {
            throw new NullPointerException("makeTransientAll(Object[]) was passed a null Array.");
        }
    }

    public void makeTransientAll(Collection collection) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("makeTransientAll(Collection)"));
        }
        if (null == collection) {
            throw new NullPointerException("makeTransientAll(Collection) was passed a null Collection.");
        }
    }

    public void makeTransactional(Object o) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("makeTransactional(Object)"));
        }
    }

    public void makeTransactionalAll(Object[] objects) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("makeTransactionalAll(Object[])"));
        }
        if (null == objects) {
            throw new NullPointerException("makeTransactionalAll(Object[]) was passed a null Array.");
        }
    }

    public void makeTransactionalAll(Collection collection) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("makeTransactionalAll(Collection)"));
        }
        if (null == collection) {
            throw new NullPointerException("makeTransactionalAll(Collection) was passed a null Collection.");
        }
    }

    public void makeNontransactional(Object o) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("makeNontransactional(Object)"));
        }
    }

    public void makeNontransactionalAll(Object[] objects) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("makeNontransactionalAll(Object[])"));
        }
        if (null == objects) {
            throw new NullPointerException("makeNontransactionalAll(Object[]) was passed a null Array.");
        }
    }

    public void makeNontransactionalAll(Collection collection) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("makeNontransactionalAll(Collection)"));
        }
        if (null == collection) {
            throw new NullPointerException("makeNontransactionalAll(Collection) was passed a null Collection.");
        }
    }

    public void retrieve(Object o) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("retrieve(Object)"));
        }
    }

    public void retrieveAll(Collection collection) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("retrieveAll(Collection)"));
        }
        if (null == collection) {
            throw new NullPointerException("retrieveAll(Collection) was passed a null Collection.");
        }
    }

    public void retrieveAll(Object[] objects) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("retrieveAll(Object[])"));
        }
        if (null == objects) {
            throw new NullPointerException("retrieveAll(Object[]) was passed a null Array.");
        }
    }

    public void setUserObject(Object o) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("setUserObject(Object)"));
        }
        this.m_usersObject = o;
    }

    public Object getUserObject() {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("getUserObject()"));
        }
        return this.m_usersObject;
    }

    public PersistenceManagerFactory getPersistenceManagerFactory() {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("getPersistenceManagerFactory()"));
        }
        return this.m_factory;
    }

    public Class getObjectIdClass(Class aClass) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("getObjectIdClass(Class)"));
        }
        return null;
    }

    public void setMultithreaded(boolean b) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("setMultithreaded(boolean)"));
        }
        this.m_multiThreaded = b;
    }

    public boolean getMultithreaded() {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("getMultithreaded()"));
        }
        return this.m_multiThreaded;
    }

    public void setIgnoreCache(boolean b) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("setIgnoreCache(boolean)"));
        }
        this.m_ignoreCache = b;
    }

    public boolean getIgnoreCache() {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("getIgnoreCache()"));
        }
        return this.m_ignoreCache;
    }

    private static final String generateIsClosedErrorMessage(String methodSignature) {
        return "PersistenceManager already closed, cannot call '" + methodSignature + "'. Obtain a new PersistenceBroker and retry.";
    }

    private static final String generateNullParameterErrorMessage(String methodSignature, String type) {
        return methodSignature + " was passed a null " + type + ".";
    }

    public void retrieveAll(Collection arg0, boolean arg1) {
    }

    public void retrieveAll(Object[] arg0, boolean arg1) {
    }
}

